/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.cmdexecutor;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.AbstractJobExecutor;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LeaseManager
extends TimerTask {
    private static Logger logger = Logger.getLogger(LeaseManager.class);
    private AbstractJobExecutor executor = null;
    private int maxLeaseTime = 0;
    private boolean isLeaseManagerConfigured = true;
    private boolean isLeaseManagerWorking = true;
    private static Object mutex = new Object();
    private final int[] status = new int[]{6, 2, 1, 3, 4};

    public LeaseManager(AbstractJobExecutor executor, int maxLeaseTime) {
        logger.debug((Object)"Call LeaseManager constructor");
        this.executor = executor;
        this.maxLeaseTime = maxLeaseTime;
    }

    public boolean isLeaseManagerConfigured() {
        return this.isLeaseManagerConfigured;
    }

    private void setLeaseManagerConfigured(boolean isLeaseManagerConfigured) {
        this.isLeaseManagerConfigured = isLeaseManagerConfigured;
    }

    public boolean isLeaseManagerWorking() {
        return this.isLeaseManagerWorking;
    }

    private void setLeaseManagerWorking(boolean isLeaseManagerWorking) {
        this.isLeaseManagerWorking = isLeaseManagerWorking;
    }

    public Calendar getBoundedLeaseTime(Calendar leaseTime) throws CommandException, IllegalArgumentException {
        if (leaseTime == null) {
            throw new IllegalArgumentException("lease time not specified!");
        }
        Calendar now = Calendar.getInstance();
        if (leaseTime.before(now)) {
            throw new CommandException("lease time (" + leaseTime.getTime() + ") expired!");
        }
        Long nowInMillis = now.getTimeInMillis();
        Long leaseInMills = leaseTime.getTimeInMillis();
        Long diffTime = (leaseInMills - nowInMillis) / 1000L;
        now.add(13, (int)(diffTime < 0L || diffTime > (long)this.maxLeaseTime ? (long)this.maxLeaseTime : diffTime));
        return now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLease(String leaseId, String userId) throws CommandException, IllegalArgumentException {
        logger.debug((Object)"Begin deleteLease");
        if (userId == null) {
            throw new IllegalArgumentException("userId not specified!");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("leaseId not specified!");
        }
        logger.debug((Object)"First synchronized (mutex)");
        Object object = mutex;
        synchronized (object) {
            try {
                this.executor.getJobDB().deleteJobLease(leaseId, userId);
            }
            catch (DatabaseException e) {
                logger.error((Object)("delete job lease is failed! " + e.getMessage()));
                throw new CommandException(e.getMessage());
            }
        }
        logger.debug((Object)"After synchronized (mutex)");
        logger.info((Object)("Lease Removed: leaseId = " + leaseId + " and userId = " + userId));
        logger.debug((Object)"End deleteLease");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar setLease(Lease lease) throws CommandException, IllegalArgumentException {
        logger.debug((Object)"Begin setLease");
        Calendar boundedLeaseTime = null;
        if (lease == null) {
            logger.error((Object)"jobLease not specified!");
            throw new IllegalArgumentException("jobLease not specified!");
        }
        if (lease.getUserId() == null) {
            logger.error((Object)"userId not specified!");
            throw new IllegalArgumentException("userId not specified!");
        }
        if (lease.getLeaseId() == null) {
            logger.error((Object)"leaseId not specified!");
            throw new IllegalArgumentException("leaseId not specified!");
        }
        if (lease.getLeaseTime() == null) {
            logger.error((Object)"leaseTime not specified!");
            throw new IllegalArgumentException("leaseTime not specified!");
        }
        boundedLeaseTime = this.getBoundedLeaseTime(lease.getLeaseTime());
        lease.setLeaseTime(boundedLeaseTime);
        logger.debug((Object)"First synchronized (mutex)");
        Object object = mutex;
        synchronized (object) {
            try {
                this.executor.getJobDB().insertJobLease(lease);
                logger.info((Object)("Lease created: leaseId = " + lease.getLeaseId() + " leaseTime = " + new Timestamp(lease.getLeaseTime().getTimeInMillis()).toString() + " userId = " + lease.getUserId()));
            }
            catch (DatabaseException de) {
                logger.debug((Object)"insertJobLease is failed. Now attempting to update ...");
                try {
                    this.executor.getJobDB().updateJobLease(lease);
                    logger.info((Object)("Lease updated: leaseId = " + lease.getLeaseId() + " leaseTime = " + new Timestamp(lease.getLeaseTime().getTimeInMillis()).toString() + " userId = " + lease.getUserId()));
                }
                catch (DatabaseException de2) {
                    logger.error((Object)("Problem to update/insert jobLease. " + de2.getMessage()));
                    throw new CommandException("Problem to update/insert jobLease. " + de2.getMessage());
                }
            }
        }
        logger.debug((Object)"After synchronized (mutex)");
        logger.debug((Object)"End setLease");
        return boundedLeaseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobLeaseId(String jobId, String leaseId, String userId) throws IllegalArgumentException, CommandException {
        logger.debug((Object)("Begin setJobLeaseId. jobId = " + jobId + " leaseId = " + leaseId + " userId = " + userId));
        if (jobId == null) {
            throw new IllegalArgumentException("jobId not specified!");
        }
        if (userId == null) {
            throw new IllegalArgumentException("userId not specified!");
        }
        logger.debug((Object)"First synchronized (mutex)");
        Object object = mutex;
        synchronized (object) {
            try {
                this.executor.getJobDB().setLeaseId(leaseId, jobId, userId);
            }
            catch (DatabaseException e) {
                throw new CommandException(e.getMessage());
            }
        }
        logger.debug((Object)"After synchronized (mutex)");
        logger.info((Object)("LeaseId field has been set for  jobId = " + jobId + " leaseId = " + leaseId + " userId = " + userId));
        logger.debug((Object)("End setJobLeaseId. jobId = " + jobId + " leaseId = " + leaseId + " userId = " + userId));
    }

    private int checkCommand(List<JobCommand> command) {
        if (command == null) {
            return 0;
        }
        int count = 1;
        JobCommand jobCmd = null;
        for (int x = 0; x < command.size(); ++x) {
            jobCmd = command.get(x);
            if (jobCmd == null || !"JOB_CANCEL".equals(jobCmd.getName()) || jobCmd.getDescription() == null || jobCmd.getDescription().indexOf("Lease") <= 0) continue;
            logger.debug((Object)("jobCmd.getExecutionCompletedTime() == null ? " + (jobCmd.getExecutionCompletedTime() == null)));
            if (jobCmd.getExecutionCompletedTime() == null) {
                return -1;
            }
            ++count;
        }
        return count;
    }

    private boolean jobCancelByLeaseManager(Job job, Calendar now) {
        boolean ok = false;
        int count = this.checkCommand(job.getCommandHistory());
        if (count != -1 && count <= 3) {
            logger.debug((Object)("The lease time is expired (" + count + "/3): the job " + job.getId() + " will be cancelled!"));
            JobCommand cmd = new JobCommand("JOB_CANCEL", job.getId());
            cmd.setCreationTime(now);
            cmd.setDescription("Job cancelled by Lease Manager! (try " + count + "/3)!");
            cmd.setUserId(job.getUserId());
            cmd.setStartSchedulingTime(now);
            cmd.setStatus(4);
            try {
                this.executor.getJobDB().insertJobCommand(cmd);
                this.executor.cancel(job);
                cmd.setStatus(6);
                this.executor.getJobDB().updateJobCommand(cmd);
                ok = true;
            }
            catch (CommandException e) {
                logger.error((Object)e.getMessage());
                cmd.setFailureReason(e.getMessage());
                cmd.setStatus(7);
                try {
                    this.executor.getJobDB().updateJobCommand(cmd);
                }
                catch (IllegalArgumentException iae) {
                    logger.error((Object)iae.getMessage());
                }
                catch (DatabaseException de) {
                    logger.error((Object)de.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage());
            }
            catch (DatabaseException e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            ok = true;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"Begin LeaseManager");
        if (this.executor == null) {
            this.setLeaseManagerConfigured(false);
            logger.error((Object)"LeaseManager is not configured: executor not specified!");
            return;
        }
        if (this.executor.getJobDB() == null) {
            this.setLeaseManagerConfigured(false);
            logger.error((Object)"LeaseManager is not configured: jobDb reference not specified!");
            return;
        }
        this.setLeaseManagerConfigured(true);
        this.setLeaseManagerWorking(true);
        Calendar now = Calendar.getInstance();
        logger.debug((Object)"First synchronized (mutex)");
        Object object = mutex;
        synchronized (object) {
            try {
                List<Lease> leaseList = this.executor.getJobDB().retrieveJobLease(now, null);
                for (Lease lease : leaseList) {
                    try {
                        this.executor.getJobDB().setLeaseExpired(lease);
                        this.executor.getJobDB().deleteJobLease(lease.getLeaseId(), lease.getUserId());
                        logger.info((Object)("Lease Removed: leaseId = " + lease.getLeaseId() + " and userId = " + lease.getUserId()));
                    }
                    catch (Exception e) {
                        logger.error((Object)("setLeaseExpired / delete job lease is failed! " + e.getMessage()));
                    }
                }
            }
            catch (DatabaseException e) {
                logger.error((Object)("retrieveJobLease for leaseId expired is failed! " + e.getMessage()));
            }
        }
        logger.debug((Object)"First synchronized (mutex)");
        try {
            List<String> jobIdListToCancel = this.executor.getJobDB().retrieveJobIdLeaseTimeExpired(this.status, null, null);
            Job job = null;
            for (int jobIndex = 0; jobIndex < jobIdListToCancel.size(); ++jobIndex) {
                logger.debug((Object)("jobIdListToCancel = " + jobIdListToCancel.get(jobIndex)));
                try {
                    job = this.executor.getJobDB().retrieveJob(jobIdListToCancel.get(jobIndex), null);
                    if (this.jobCancelByLeaseManager(job, now)) {
                        logger.info((Object)("Job has been cancelled. jobId = " + job.getId()));
                        continue;
                    }
                    logger.warn((Object)("Problem to cancel job by LeaseManager. jobId = " + job.getId()));
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        catch (DatabaseException de) {
            logger.error((Object)("Retrieving jobs expired by LeaseManager is failed! " + de.getMessage()));
        }
        this.setLeaseManagerWorking(false);
        logger.info((Object)"End LeaseManager");
    }
}

