/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.cmdexecutor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobSubmissionManagerInfo;
import org.glite.ce.creamapi.jobmanagement.db.DBInfoManager;

public final class JobSubmissionManager
extends TimerTask {
    private static Logger logger = Logger.getLogger((String)JobSubmissionManager.class.getName());
    public static final String SHOW_PARAMETER = "--show";
    public static final String TEST_PARAMETER = "--test";
    public static final int SUBMISSION_ENABLED = 0;
    public static final int SUBMISSION_DISABLED_BY_LIMITER = 1;
    public static final int SUBMISSION_DISABLED_BY_ADMIN = 2;
    private static JobSubmissionManager jobSubmissionManager = null;
    private static String gliteCreamLoadMonitorScriptPath = null;
    private static String gliteCreamLoadMonitorScriptConfigurationFile = "";
    private boolean enableScript = true;
    private boolean isLoadMonitorScriptConfigurated = false;
    private JobSubmissionManagerInfo jobSubmissionManagerInfo = new JobSubmissionManagerInfo();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();

    public static JobSubmissionManager getInstance() throws IllegalArgumentException {
        if (jobSubmissionManager == null) {
            jobSubmissionManager = new JobSubmissionManager();
        }
        return jobSubmissionManager;
    }

    private JobSubmissionManager() throws IllegalArgumentException {
        if (gliteCreamLoadMonitorScriptPath != null && !"".equals(gliteCreamLoadMonitorScriptPath)) {
            this.jobSubmissionManagerInfo.setExecutionTimestamp(Calendar.getInstance());
            this.jobSubmissionManagerInfo.setShowMessage(JobSubmissionManager.executeScript(SHOW_PARAMETER));
            logger.info((Object)"Cream LoadMonitor Script enabled.");
            this.isLoadMonitorScriptConfigurated = true;
        } else {
            logger.info((Object)"Cream LoadMonitor Script disabled.");
            this.isLoadMonitorScriptConfigurated = false;
        }
    }

    public static void setGliteCreamLoadMonitorScriptPath(String gliteCreamLMScriptPath) {
        if (gliteCreamLMScriptPath != null) {
            gliteCreamLoadMonitorScriptPath = gliteCreamLMScriptPath.trim();
            int index = gliteCreamLMScriptPath.indexOf(" ");
            if (index != -1) {
                gliteCreamLoadMonitorScriptConfigurationFile = gliteCreamLMScriptPath.substring(index + 1);
                gliteCreamLoadMonitorScriptPath = gliteCreamLMScriptPath.substring(0, index);
            }
        }
    }

    public JobSubmissionManagerInfo getJobSubmissionManagerInfo() {
        logger.debug((Object)"Begin getJobSubmissionManagerInfo");
        JobSubmissionManagerInfo clone = null;
        this.readLock.lock();
        clone = (JobSubmissionManagerInfo)this.jobSubmissionManagerInfo.clone();
        this.readLock.unlock();
        logger.debug((Object)"End getJobSubmissionManagerInfo");
        return clone;
    }

    public void enableAcceptNewJobs(int enable) {
        logger.debug((Object)("Begin enableAcceptNewJobs with enable = " + enable));
        this.writeLock.lock();
        this.enableScript = 2 != enable;
        DBInfoManager.updateSubmissionEnabled("datasource_creamdb", enable);
        this.jobSubmissionManagerInfo.setAcceptNewJobs(0 == enable);
        logger.info((Object)("AcceptNewJobs = " + this.jobSubmissionManagerInfo.isAcceptNewJobs()));
        if (!this.enableScript) {
            this.jobSubmissionManagerInfo.setTestErrorMessage(null);
            this.jobSubmissionManagerInfo.setShowMessage(null);
        }
        this.writeLock.unlock();
        logger.debug((Object)("End enableAcceptNewJobs with enable = " + enable));
    }

    public void run() {
        if (this.enableScript && this.isLoadMonitorScriptConfigurated) {
            Calendar executionTimestamp = Calendar.getInstance();
            String testErrorMessage = null;
            boolean acceptNewJobs = false;
            String showMessage = null;
            String result = null;
            try {
                result = JobSubmissionManager.executeScript(TEST_PARAMETER);
                if (result != null) {
                    acceptNewJobs = false;
                    testErrorMessage = result;
                } else {
                    acceptNewJobs = true;
                    testErrorMessage = null;
                }
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("Error in execution of gliteCreamLoadMonitorScript: " + iae.getMessage()));
                testErrorMessage = "Error in execution of gliteCreamLoadMonitorScript: " + iae.getMessage();
            }
            try {
                showMessage = result = JobSubmissionManager.executeScript(SHOW_PARAMETER);
            }
            catch (IllegalArgumentException iae) {
                logger.error((Object)("Error in execution of gliteCreamLoadMonitorScript: " + iae.getMessage()));
                showMessage = "Error in execution of gliteCreamLoadMonitorScript: " + iae.getMessage();
            }
            this.writeLock.lock();
            if (this.enableScript) {
                this.jobSubmissionManagerInfo.setExecutionTimestamp(executionTimestamp);
                this.jobSubmissionManagerInfo.setAcceptNewJobs(acceptNewJobs);
                if (acceptNewJobs) {
                    DBInfoManager.updateSubmissionEnabled("datasource_creamdb", 0);
                } else {
                    DBInfoManager.updateSubmissionEnabled("datasource_creamdb", 1);
                }
                logger.info((Object)("AcceptNewJobs by script = " + acceptNewJobs));
                this.jobSubmissionManagerInfo.setShowMessage(showMessage);
                this.jobSubmissionManagerInfo.setTestErrorMessage(testErrorMessage);
            }
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String executeScript(String parameter) throws IllegalArgumentException {
        String message;
        block50: {
            Process proc;
            block59: {
                StringBuffer outputMessage;
                block54: {
                    block58: {
                        StringBuffer errorMessage;
                        block52: {
                            message = null;
                            proc = null;
                            String[] cmd = new String[]{gliteCreamLoadMonitorScriptPath, gliteCreamLoadMonitorScriptConfigurationFile, parameter};
                            proc = Runtime.getRuntime().exec(cmd);
                            Object var5_5 = null;
                            if (proc == null) break block50;
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            errorMessage = null;
                            outputMessage = null;
                            if (proc.exitValue() == 0) break block58;
                            BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            errorMessage = new StringBuffer();
                            String inputLine = null;
                            while ((inputLine = readErr.readLine()) != null) {
                                errorMessage.append(inputLine + "\n");
                            }
                            Object var12_17 = null;
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe2) {}
                            break block52;
                            {
                                catch (IOException ioe) {
                                    logger.error((Object)ioe.getMessage());
                                    Object var12_18 = null;
                                    try {
                                        readErr.close();
                                    }
                                    catch (IOException ioe2) {}
                                    break block52;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var12_19 = null;
                                try {
                                    readErr.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                        message = errorMessage.toString();
                        logger.info((Object)("gliteCreamLoadMonitor: exitCode = " + proc.exitValue() + " messageError = " + message));
                        break block59;
                    }
                    if (!SHOW_PARAMETER.equals(parameter)) break block59;
                    BufferedReader readOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    outputMessage = new StringBuffer();
                    String outputLine = null;
                    while ((outputLine = readOut.readLine()) != null) {
                        outputMessage.append(outputLine + "\n");
                    }
                    Object var15_35 = null;
                    try {
                        readOut.close();
                    }
                    catch (IOException ioe3) {}
                    break block54;
                    {
                        catch (IOException ioe) {
                            logger.error((Object)ioe.getMessage());
                            Object var15_36 = null;
                            try {
                                readOut.close();
                            }
                            catch (IOException ioe3) {}
                            break block54;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_37 = null;
                        try {
                            readOut.close();
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (outputMessage.length() > 0) {
                    outputMessage.append("\n");
                }
                message = outputMessage.toString();
                logger.debug((Object)("gliteCreamLoadMonitor show: " + message));
            }
            try {
                proc.getInputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getErrorStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getOutputStream().close();
            }
            catch (IOException ioe) {}
            break block50;
            {
                catch (Throwable e) {
                    logger.error((Object)e.getMessage());
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                block60: {
                    block63: {
                        StringBuffer outputMessage;
                        block64: {
                            block61: {
                                StringBuffer errorMessage;
                                block62: {
                                    Object var5_6 = null;
                                    if (proc == null) break block60;
                                    try {
                                        proc.waitFor();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                    errorMessage = null;
                                    outputMessage = null;
                                    if (proc.exitValue() == 0) break block61;
                                    BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                                    errorMessage = new StringBuffer();
                                    String inputLine = null;
                                    while ((inputLine = readErr.readLine()) != null) {
                                        errorMessage.append(inputLine + "\n");
                                    }
                                    Object var12_20 = null;
                                    try {
                                        readErr.close();
                                    }
                                    catch (IOException ioe2) {}
                                    break block62;
                                    {
                                        catch (IOException ioe) {
                                            logger.error((Object)ioe.getMessage());
                                            Object var12_21 = null;
                                            try {
                                                readErr.close();
                                            }
                                            catch (IOException ioe2) {}
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        Object var12_22 = null;
                                        try {
                                            readErr.close();
                                        }
                                        catch (IOException ioe2) {
                                            // empty catch block
                                        }
                                        throw throwable2;
                                    }
                                }
                                if (errorMessage.length() > 0) {
                                    errorMessage.append("\n");
                                }
                                message = errorMessage.toString();
                                logger.info((Object)("gliteCreamLoadMonitor: exitCode = " + proc.exitValue() + " messageError = " + message));
                                break block63;
                            }
                            if (!SHOW_PARAMETER.equals(parameter)) break block63;
                            BufferedReader readOut = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            outputMessage = new StringBuffer();
                            String outputLine = null;
                            while ((outputLine = readOut.readLine()) != null) {
                                outputMessage.append(outputLine + "\n");
                            }
                            Object var15_38 = null;
                            try {
                                readOut.close();
                            }
                            catch (IOException ioe3) {}
                            break block64;
                            {
                                catch (IOException ioe) {
                                    logger.error((Object)ioe.getMessage());
                                    Object var15_39 = null;
                                    try {
                                        readOut.close();
                                    }
                                    catch (IOException ioe3) {}
                                }
                            }
                            catch (Throwable throwable3) {
                                Object var15_40 = null;
                                try {
                                    readOut.close();
                                }
                                catch (IOException ioe3) {
                                    // empty catch block
                                }
                                throw throwable3;
                            }
                        }
                        if (outputMessage.length() > 0) {
                            outputMessage.append("\n");
                        }
                        message = outputMessage.toString();
                        logger.debug((Object)("gliteCreamLoadMonitor show: " + message));
                    }
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return message;
    }
}

