/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.cmdexecutor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.creamapi.eventmanagement.Event;
import org.glite.ce.creamapi.eventmanagement.EventManagerException;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobStatusEventManagerInterface;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobStatusEventManager
implements JobStatusEventManagerInterface {
    public static final String TYPE_PROPERTYNAME = "type";
    public static final String EXIT_CODE_PROPERTYNAME = "exitCode";
    public static final String FAILURE_REASON_PROPERTYNAME = "failureReason";
    public static final String DESCRIPTION_PROPERTYNAME = "description";
    public static final String JOB_ID_PROPERTYNAME = "jobId";
    public static final String GRID_JOB_ID_PROPERTYNAME = "gridJobId";
    public static final String WORKER_NODE_PROPERTYNAME = "workerNode";
    public static final String MANAGER_TYPE = "JOBSTATUS";
    private static final Logger logger = Logger.getLogger((String)JobStatusEventManager.class.getName());
    private JobDBInterface jobDB = null;
    private int maxEvents = 1;

    public JobStatusEventManager(JobDBInterface jobDB, int maxEvents) {
        if (jobDB == null) {
            throw new IllegalArgumentException("JobStatusEventManager: parameter must be not null!");
        }
        this.jobDB = jobDB;
        this.maxEvents = maxEvents;
        logger.debug((Object)("maxEvents = " + maxEvents));
    }

    @Override
    public void deleteEvent(String eventId, String userId) throws IllegalArgumentException, EventManagerException {
        logger.warn((Object)"Method not implemented!");
        throw new EventManagerException("Method not implemented!");
    }

    @Override
    public void deleteEvents(String userId) throws IllegalArgumentException, EventManagerException {
        logger.warn((Object)"Method not implemented!");
        throw new EventManagerException("Method not implemented!");
    }

    @Override
    public Event getEvent(String eventId, String userId) throws IllegalArgumentException, EventManagerException {
        Event event = null;
        if (eventId == null) {
            throw new IllegalArgumentException("paramenter eventId must be not null!");
        }
        List<Event> eventList = null;
        try {
            eventList = this.jobDB.retrieveJobStatusAsEvent(eventId, null, null, null, null, 1, userId);
        }
        catch (DatabaseException de) {
            logger.error((Object)("Error retrieving events fom database: " + de.getMessage()));
            throw new EventManagerException("Error retrieving events fom database: " + de.getMessage());
        }
        if (eventList.size() != 0) {
            event = eventList.get(0);
        }
        return event;
    }

    @Override
    public List<Event> getEvents(String fromEventId, String toEventId, Calendar fromDate, Calendar toDate, int maxEvents, String userId) throws IllegalArgumentException, EventManagerException {
        return this.getEvents(fromEventId, toEventId, fromDate, toDate, null, Math.min(maxEvents, this.maxEvents), userId);
    }

    @Override
    public List<Event> getEvents(String fromEventId, String toEventId, Calendar fromDate, Calendar toDate, int[] jobStatusType, int maxEvents, String userId) throws IllegalArgumentException, EventManagerException {
        ArrayList<Event> eventList = new ArrayList(0);
        try {
            eventList = this.jobDB.retrieveJobStatusAsEvent(fromEventId, toEventId, fromDate, toDate, jobStatusType, Math.min(maxEvents, this.maxEvents), userId);
        }
        catch (DatabaseException de) {
            logger.error((Object)("Error retrieving events fom database: " + de.getMessage()));
            throw new EventManagerException("Error retrieving events fom database: " + de.getMessage());
        }
        return eventList;
    }

    @Override
    public void insertEvent(Event event, String userId) throws IllegalArgumentException, EventManagerException {
        logger.warn((Object)"Method not implemented!");
        throw new EventManagerException("Method not implemented!");
    }
}

