/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.cmdexecutor;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.AbstractJobExecutor;

public class JobPurger
extends Thread {
    private static Logger logger = Logger.getLogger((String)JobPurger.class.getName());
    private AbstractJobExecutor executor = null;
    private String policy = null;
    private JOB_STATUS jobStatus;
    private Calendar date;
    private int rate = 300;
    private boolean terminate = false;

    public JobPurger(AbstractJobExecutor executor, String policy, int rate) {
        this.executor = executor;
        this.policy = policy;
        this.rate = rate;
        this.start();
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    private Calendar parseDate(String date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date not specified!");
        }
        date.trim();
        GregorianCalendar todate = new GregorianCalendar();
        if (date.endsWith("minutes")) {
            todate.add(12, -Integer.parseInt(date.substring(0, date.indexOf("minutes")).trim()));
        } else if (date.endsWith("hours")) {
            todate.add(11, -Integer.parseInt(date.substring(0, date.indexOf("hours")).trim()));
        } else if (date.endsWith("days")) {
            todate.add(6, -Integer.parseInt(date.substring(0, date.indexOf("days")).trim()));
        } else if (date.endsWith("months")) {
            todate.add(2, -Integer.parseInt(date.substring(0, date.indexOf("months")).trim()));
        } else if (date.endsWith("years")) {
            todate.add(1, -Integer.parseInt(date.substring(0, date.indexOf("years")).trim()));
        } else {
            throw new IllegalArgumentException("illegal date format: " + date + "! use: time_value { minutes | hours | days | months | years }");
        }
        return todate;
    }

    private void parsePolicy(String policy) throws IllegalArgumentException, Exception {
        if (policy == null) {
            throw new IllegalArgumentException("policy not specified!");
        }
        int index = policy.indexOf(" ");
        if (index < 0) {
            throw new Exception("malformed policy " + policy);
        }
        String status = policy.substring(0, index).trim();
        if (status == null || status.length() == 0) {
            throw new Exception("job status not specified!");
        }
        JOB_STATUS[] jobStatusList = JOB_STATUS.values();
        for (int i = 0; i < jobStatusList.length; ++i) {
            if (!jobStatusList[i].getName().equalsIgnoreCase(status)) continue;
            this.jobStatus = jobStatusList[i];
            break;
        }
        if (this.jobStatus == null) {
            throw new Exception("invalid job status name: " + status + "! use { ABORTED | CANCELLED | DONE-FAILED | DONE-OK | REGISTERED }");
        }
        if (index >= policy.length()) {
            throw new Exception("date not specified!");
        }
        String dateValue = policy.substring(index, policy.length()).trim();
        if (dateValue == null || dateValue.length() == 0) {
            throw new Exception("date not specified!");
        }
        this.date = this.parseDate(dateValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.policy == null) {
            logger.error((Object)"policy not defined!");
            return;
        }
        logger.info((Object)("starting: policy=[" + this.policy + "]; rate=" + this.rate + " minutes"));
        while (!this.terminate) {
            StringTokenizer st = new StringTokenizer(this.policy, ";");
            String token = null;
            block10: while (st.hasMoreTokens() && !this.terminate) {
                token = st.nextToken().trim();
                if (token == null) continue;
                try {
                    this.parsePolicy(token);
                }
                catch (Throwable e) {
                    logger.error((Object)("policy parsing error: " + e.getMessage()));
                    continue;
                }
                try {
                    int[] purgeCompatibleStatus = new int[]{this.jobStatus.getId()};
                    List<String> jobIdList = this.executor.getJobDB().retrieveJobId(null, null, purgeCompatibleStatus, null, this.date);
                    logger.info((Object)("purging " + jobIdList.size() + " jobs with status " + this.jobStatus.getName() + " <= " + this.date.getTime()));
                    for (String jobId : jobIdList) {
                        if (this.terminate) continue block10;
                        Command purgeCmd = new Command("JOB_PURGE", "JOB_MANAGEMENT");
                        purgeCmd.setUserId("ADMIN");
                        purgeCmd.setDescription("Cancelled by CREAM's job purger");
                        purgeCmd.setAsynchronous(false);
                        purgeCmd.setCommandGroupId(jobId);
                        purgeCmd.addParameter("JOB_ID", (Serializable)((Object)jobId));
                        purgeCmd.addParameter("IS_ADMIN", (Serializable)((Object)Boolean.toString(true)));
                        purgeCmd.setPriorityLevel(0);
                        this.executor.execute(purgeCmd);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)t.getMessage());
                }
            }
            JobPurger jobPurger = this;
            synchronized (jobPurger) {
                try {
                    logger.debug((Object)("waiting " + this.rate + " minutes..."));
                    this.wait(this.rate * 60000);
                    logger.debug((Object)("waiting " + this.rate + " minutes... done"));
                }
                catch (InterruptedException e) {
                    this.terminate = true;
                }
            }
        }
        logger.info((Object)"exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        logger.info((Object)"teminate invoked!");
        this.terminate = true;
        JobPurger jobPurger = this;
        synchronized (jobPurger) {
            this.notifyAll();
        }
        logger.info((Object)"teminated!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JOB_STATUS {
        ABORTED("ABORTED", 10),
        CANCELLED("CANCELLED", 5),
        REGISTERED("REGISTERED", 0),
        DONE_FAILED("DONE-FAILED", 8),
        DONE_OK("DONE-OK", 7);

        String name;
        int id;

        private JOB_STATUS(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

