/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement.cmdexecutor;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.creamapi.cmdmanagement.AbstractCommandExecutor;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorException;
import org.glite.ce.creamapi.cmdmanagement.CommandManagerException;
import org.glite.ce.creamapi.cmdmanagement.CommandResult;
import org.glite.ce.creamapi.eventmanagement.EventManagerException;
import org.glite.ce.creamapi.eventmanagement.EventManagerFactory;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobEnumeration;
import org.glite.ce.creamapi.jobmanagement.JobManagementException;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.JobStatusChangeListener;
import org.glite.ce.creamapi.jobmanagement.JobWrapper;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobCommandConstant;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobPurger;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobStatusEventManager;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobStatusEventManagerInterface;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.JobSubmissionManager;
import org.glite.ce.creamapi.jobmanagement.cmdexecutor.LeaseManager;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;
import org.glite.ce.creamapi.jobmanagement.command.JobIdFilterFailure;
import org.glite.ce.creamapi.jobmanagement.command.JobIdFilterResult;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;
import org.glite.ce.creamapi.jobmanagement.jdl.JobFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobExecutor
extends AbstractCommandExecutor
implements JobStatusChangeListener {
    private static final Logger logger = Logger.getLogger((String)AbstractJobExecutor.class.getName());
    public static final String JOB_WRAPPER_DELEGATION_TIME_SLOT = "JOB_WRAPPER_DELEGATION_TIME_SLOT";
    public static final String JOB_WRAPPER_COPY_PROXY_MIN_RETRY_WAIT = "JOB_WRAPPER_COPY_PROXY_MIN_RETRY_WAIT";
    public static final String JOB_WRAPPER_COPY_RETRY_COUNT_ISB = "JOB_WRAPPER_COPY_RETRY_COUNT_ISB";
    public static final String JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_ISB = "JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_ISB";
    public static final String JOB_WRAPPER_COPY_RETRY_COUNT_OSB = "JOB_WRAPPER_COPY_RETRY_COUNT_OSB";
    public static final String JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_OSB = "JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_OSB";
    public static final String DELEGATION_PROXY_CERT_SANDBOX_URI = "DELEGATION_PROXY_CERT_SANDBOX_URI";
    public static final String SANDBOX_TRANSFER_METHOD = "SANDBOX_TRANSFER_METHOD";
    public static final String GSIFTP_SANDBOX_TRANSFER_METHOD = "GSIFTP";
    public static final String LRMS_SANDBOX_TRANSFER_METHOD = "LRMS";
    public static final String LRMS_INPUT_FILES = "LRMS_INPUT_FILES";
    public static final String LRMS_OUTPUT_FILES = "LRMS_OUTPUT_FILES";
    public static final String JOB_WRAPPER_TEMPLATE_PATH = "JOB_WRAPPER_TEMPLATE_PATH";
    public static final String CREAM_JOB_SENSOR_HOST = "CREAM_JOB_SENSOR_HOST";
    public static final String CREAM_JOB_SENSOR_PORT = "CREAM_JOB_SENSOR_PORT";
    public static final String JOB_SUBMISSION_MANAGER_ENABLE = "JOB_SUBMISSION_MANAGER_ENABLE";
    public static final String JOB_SUBMISSION_MANAGER_SCRIPT_PATH = "JOB_SUBMISSION_MANAGER_SCRIPT_PATH";
    private static int JOB_PURGE_RATE_DEFAULT = 300;
    private static Timer timer = null;
    private JobDBInterface jobDB;
    private LeaseManager leaseManager;
    private JobSubmissionManager jobSubmissionManager;
    private JobPurger jobPurger = null;
    private Socket socket = null;
    private ObjectOutputStream oos = null;

    protected AbstractJobExecutor(String name) throws CommandExecutorException {
        super(name, "JOB_MANAGEMENT");
        this.setCommands(JobCommandConstant.commandNameList);
        if (timer == null) {
            timer = new Timer("TIMER", true);
        }
    }

    @Override
    public void initExecutor() throws CommandExecutorException {
        String cream_sandbox_dir = this.getParameterValueAsString("CREAM_SANDBOX_DIR");
        if (cream_sandbox_dir == null) {
            throw new CommandExecutorException("parameter \"CREAM_SANDBOX_DIR\" not defined!");
        }
        String sensorHost = this.getParameterValueAsString(CREAM_JOB_SENSOR_HOST);
        if (sensorHost == null) {
            logger.warn((Object)"CREAM_JOB_SENSOR_HOST parameter not specified!");
        }
        File dir = new File(cream_sandbox_dir);
        try {
            try {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                this.makeVODir(dir);
            }
            catch (IOException ioe) {
                throw new CommandExecutorException(ioe.getMessage());
            }
            Object var6_4 = null;
            dir = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            dir = null;
            throw throwable;
        }
    }

    @Override
    public void destroy() {
        logger.info((Object)"destroy invoked!");
        super.destroy();
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        this.socket = null;
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.jobPurger != null) {
            this.jobPurger.terminate();
        }
        timer.cancel();
        timer.purge();
        timer = null;
        this.jobDB = null;
        logger.info((Object)"destroyed!");
    }

    public Job retrieveJob(String jobId) throws CommandException {
        logger.debug((Object)("Begin retrieveJob for jobId = " + jobId));
        Job job = null;
        try {
            job = this.jobDB.retrieveJob(jobId, null);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
        logger.debug((Object)("End retrieveJob for jobId = " + jobId));
        return job;
    }

    public void updateJob(Job job) throws CommandException {
        try {
            this.jobDB.update(job);
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    private JobEnumeration getJobList(Command cmd) throws IllegalArgumentException, CommandException {
        logger.debug((Object)"Begin getJobList");
        if (cmd == null) {
            throw new IllegalArgumentException("cmd not defined!");
        }
        ArrayList<Integer> compatibleStatusList = new ArrayList<Integer>(0);
        int cmdType = this.getCommandType(cmd.getName());
        if ("JOB_START".equals(cmd.getName())) {
            compatibleStatusList.add(0);
        } else if ("JOB_CANCEL".equals(cmd.getName())) {
            compatibleStatusList.add(0);
            compatibleStatusList.add(2);
            compatibleStatusList.add(6);
            compatibleStatusList.add(4);
            compatibleStatusList.add(3);
        } else if ("JOB_SET_LEASEID".equals(cmd.getName())) {
            compatibleStatusList.add(0);
            compatibleStatusList.add(1);
            compatibleStatusList.add(2);
            compatibleStatusList.add(6);
            compatibleStatusList.add(4);
            compatibleStatusList.add(3);
        } else if ("JOB_PURGE".equals(cmd.getName())) {
            compatibleStatusList.add(10);
            compatibleStatusList.add(0);
            compatibleStatusList.add(5);
            compatibleStatusList.add(7);
            compatibleStatusList.add(8);
        } else if ("JOB_RESUME".equals(cmd.getName())) {
            compatibleStatusList.add(6);
        } else if ("JOB_SUSPEND".equals(cmd.getName())) {
            compatibleStatusList.add(2);
            compatibleStatusList.add(4);
            compatibleStatusList.add(3);
        } else {
            compatibleStatusList.add(0);
            compatibleStatusList.add(1);
            compatibleStatusList.add(2);
            compatibleStatusList.add(3);
            compatibleStatusList.add(4);
            compatibleStatusList.add(5);
            compatibleStatusList.add(6);
            compatibleStatusList.add(7);
            compatibleStatusList.add(8);
            compatibleStatusList.add(9);
            compatibleStatusList.add(10);
        }
        String userId = null;
        if (cmd.getParameterAsString("IS_ADMIN") == null || cmd.getParameterAsString("IS_ADMIN").equalsIgnoreCase("false")) {
            userId = cmd.getUserId();
        }
        List<Object> jobList = null;
        Calendar fromDate = null;
        Calendar toDate = null;
        Calendar fromStatusDate = null;
        Calendar toStatusDate = null;
        String leaseId = null;
        String delegationId = null;
        if (cmd.containsParameterKey("JOB_ID")) {
            jobList = new ArrayList<String>(0);
            jobList.add(cmd.getParameterAsString("JOB_ID"));
        } else if (cmd.containsParameterKey("JOB_ID_LIST")) {
            jobList = cmd.getParameterMultivalue("JOB_ID_LIST");
        }
        fromDate = this.makeDate(cmd.getParameterAsString("FROM_DATE"));
        toDate = this.makeDate(cmd.getParameterAsString("TO_DATE"));
        leaseId = cmd.getParameterAsString("LEASE_ID");
        delegationId = cmd.getParameterAsString("DELEGATION_PROXY_ID");
        fromStatusDate = this.makeDate(cmd.getParameterAsString("FROM_STATUS_DATE"));
        toStatusDate = this.makeDate(cmd.getParameterAsString("TO_STATUS_DATE"));
        List<String> statusList = cmd.getParameterMultivalue("JOB_STATUS_LIST");
        if (statusList == null) {
            logger.debug((Object)"statusList is null!");
        }
        if (statusList != null && statusList.size() == 0) {
            logger.debug((Object)"statusList is empty!");
        }
        ArrayList<Integer> compatibleStatusToFindList = new ArrayList<Integer>(0);
        if (statusList != null) {
            for (int i = 0; i < statusList.size(); ++i) {
                for (int x = 0; x < JobStatus.statusName.length; ++x) {
                    if (!compatibleStatusList.contains(x) || !statusList.get(i).equals(JobStatus.getNameByType(x))) continue;
                    compatibleStatusToFindList.add(x);
                }
            }
        } else {
            compatibleStatusToFindList = compatibleStatusList;
        }
        if (compatibleStatusToFindList == null || compatibleStatusToFindList.size() == 0) {
            logger.error((Object)"Status specified not compatible for the request command.");
            throw new CommandException("Status specified not compatible for the request command.");
        }
        int[] compatibleStatusToFind = new int[compatibleStatusToFindList.size()];
        for (int i = 0; i < compatibleStatusToFindList.size(); ++i) {
            compatibleStatusToFind[i] = (Integer)compatibleStatusToFindList.get(i);
        }
        List<String> jobIdFound = null;
        ArrayList<JobIdFilterResult> jobIdFilterResultList = new ArrayList<JobIdFilterResult>(0);
        JobIdFilterResult jobIdFilterResult = null;
        ArrayList<Object> helpJobList = new ArrayList<Object>(0);
        try {
            int i;
            if (jobList != null && jobList.size() > 0) {
                logger.debug((Object)"JobList parameter is not null in jobFilter.");
                helpJobList.addAll(jobList);
                jobIdFound = this.jobDB.retrieveJobId(jobList, userId);
                helpJobList.removeAll(jobIdFound);
                for (i = 0; i < helpJobList.size(); ++i) {
                    jobIdFilterResult = new JobIdFilterResult();
                    jobIdFilterResult.setJobId((String)helpJobList.get(i));
                    jobIdFilterResult.setErrorCode(1);
                    jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[1]);
                    jobIdFilterResultList.add(jobIdFilterResult);
                    logger.debug((Object)("JobId = " + (String)helpJobList.get(i) + " FailureReason = " + JobIdFilterFailure.failureReason[1]));
                }
                helpJobList.clear();
                helpJobList.addAll(jobIdFound);
                if (jobIdFound != null && jobIdFound.size() > 0) {
                    jobIdFound = this.jobDB.retrieveJobId(jobIdFound, userId, compatibleStatusToFind, fromStatusDate, toStatusDate);
                    helpJobList.removeAll(jobIdFound);
                    for (i = 0; i < helpJobList.size(); ++i) {
                        jobIdFilterResult = new JobIdFilterResult();
                        jobIdFilterResult.setJobId((String)helpJobList.get(i));
                        jobIdFilterResult.setErrorCode(2);
                        jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[2]);
                        jobIdFilterResultList.add(jobIdFilterResult);
                        logger.debug((Object)("JobId = " + (String)helpJobList.get(i) + " FailureReason = " + JobIdFilterFailure.failureReason[2]));
                    }
                    helpJobList.clear();
                    helpJobList.addAll(jobIdFound);
                }
                if (jobIdFound != null && jobIdFound.size() > 0 && (fromDate != null || toDate != null)) {
                    jobIdFound = this.jobDB.retrieveByDate(jobIdFound, userId, fromDate, toDate);
                    helpJobList.removeAll(jobIdFound);
                    for (i = 0; i < helpJobList.size(); ++i) {
                        jobIdFilterResult = new JobIdFilterResult();
                        jobIdFilterResult.setJobId((String)helpJobList.get(i));
                        jobIdFilterResult.setErrorCode(5);
                        jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[5]);
                        jobIdFilterResultList.add(jobIdFilterResult);
                        logger.debug((Object)("JobId = " + (String)helpJobList.get(i) + " FailureReason = " + JobIdFilterFailure.failureReason[5]));
                    }
                    helpJobList.clear();
                    helpJobList.addAll(jobIdFound);
                }
                if (jobIdFound != null && jobIdFound.size() > 0 && delegationId != null) {
                    jobIdFound = this.jobDB.retrieveJobId(jobIdFound, delegationId, null, userId);
                    helpJobList.removeAll(jobIdFound);
                    for (i = 0; i < helpJobList.size(); ++i) {
                        jobIdFilterResult = new JobIdFilterResult();
                        jobIdFilterResult.setJobId((String)helpJobList.get(i));
                        jobIdFilterResult.setErrorCode(4);
                        jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[4]);
                        jobIdFilterResultList.add(jobIdFilterResult);
                        logger.debug((Object)("JobId = " + (String)helpJobList.get(i) + " FailureReason = " + JobIdFilterFailure.failureReason[4]));
                    }
                    helpJobList.clear();
                    helpJobList.addAll(jobIdFound);
                }
                if (jobIdFound != null && jobIdFound.size() > 0 && leaseId != null) {
                    jobIdFound = this.jobDB.retrieveJobId(jobIdFound, null, leaseId, userId);
                    helpJobList.removeAll(jobIdFound);
                    for (i = 0; i < helpJobList.size(); ++i) {
                        jobIdFilterResult = new JobIdFilterResult();
                        jobIdFilterResult.setJobId((String)helpJobList.get(i));
                        jobIdFilterResult.setErrorCode(3);
                        jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[3]);
                        jobIdFilterResultList.add(jobIdFilterResult);
                        logger.debug((Object)("JobId = " + (String)helpJobList.get(i) + " FailureReason = " + JobIdFilterFailure.failureReason[3]));
                    }
                }
            } else {
                logger.debug((Object)"JobList parameter is null in jobFilter.");
                jobIdFound = this.jobDB.retrieveJobId(userId, delegationId, compatibleStatusToFind, fromStatusDate, toStatusDate, leaseId, fromDate, toDate);
            }
            if (jobIdFound != null) {
                for (i = 0; i < jobIdFound.size(); ++i) {
                    jobIdFilterResult = new JobIdFilterResult();
                    jobIdFilterResult.setJobId(jobIdFound.get(i));
                    jobIdFilterResult.setErrorCode(0);
                    jobIdFilterResult.setFailureReason(JobIdFilterFailure.failureReason[0]);
                    jobIdFilterResultList.add(jobIdFilterResult);
                }
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage());
            throw new CommandException(e.getMessage());
        }
        JobEnumeration jobEnum = new JobEnumeration(jobIdFound, this.jobDB);
        cmd.getResult().addParameter("JOBID_FILTER_RESULT_LIST", jobIdFilterResultList);
        cmd.getResult().addParameter("JOB_ENUM", jobEnum);
        return jobEnum;
    }

    private Calendar makeDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar date = null;
        try {
            Long time = Long.parseLong(timestamp);
            date = Calendar.getInstance();
            date.setTimeInMillis(time);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return date;
    }

    private int getCommandType(String cmdName) {
        if (cmdName == null) {
            return -1;
        }
        List<String> commandNames = this.getCommands();
        for (int i = 0; i < commandNames.size(); ++i) {
            if (!cmdName.equals(commandNames.get(i))) continue;
            return i;
        }
        return -1;
    }

    private void insertJobCommand(JobCommand jobCommand, String delegationId, int[] statusType) throws CommandException {
        if (jobCommand == null) {
            throw new CommandException("jobCommand not defined!");
        }
        try {
            this.jobDB.insertJobCommand(jobCommand, delegationId, statusType);
            logger.debug((Object)("insertJobCommand local user " + jobCommand.getUserId() + " delegId = " + delegationId));
        }
        catch (DatabaseException de) {
            logger.error((Object)("insertJobCommand error: " + de.getMessage()));
            throw new CommandException(de.getMessage());
        }
        catch (IllegalArgumentException ie) {
            throw new CommandException(ie.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(Command command) throws CommandExecutorException, CommandException {
        block107: {
            AbstractJobExecutor.logger.debug((Object)"BEGIN execute");
            if (command == null) {
                throw new CommandExecutorException("command not defined!");
            }
            AbstractJobExecutor.logger.debug((Object)("executing command: " + command.toString()));
            if (!command.getCategory().equalsIgnoreCase(this.getCategory())) {
                throw new CommandException("command category mismatch: found \"" + command.getCategory() + "\" required \"" + this.getCategory() + "\"");
            }
            if (command.isAsynchronous() && command.getCommandGroupId() != null && "COMPOUND".equals(command.getCommandGroupId())) {
                jobIdList = null;
                if (command.containsParameterKey("JOB_ID_LIST")) {
                    jobIdList = command.getParameterMultivalue("JOB_ID_LIST");
                    command.deleteParameter("JOB_ID_LIST");
                } else {
                    jobIdList = this.getJobList(command).getJobIdList();
                }
                if (command.containsParameterKey("EXECUTION_MODE")) {
                    if ("S".equals(command.getParameterAsString("EXECUTION_MODE"))) {
                        command.setExecutionMode(Command.ExecutionModeValues.SERIAL);
                    } else {
                        command.setExecutionMode(Command.ExecutionModeValues.PARALLEL);
                    }
                }
                if (command.containsParameterKey("PRIORITY_LEVEL")) {
                    command.setPriorityLevel(Integer.parseInt(command.getParameterAsString("PRIORITY_LEVEL")));
                }
                if (jobIdList != null) {
                    for (String jobId : jobIdList) {
                        command.addParameter("JOB_ID", (Serializable)jobId);
                        command.setCommandGroupId(jobId);
                        try {
                            this.getCommandManager().execute(command);
                        }
                        catch (CommandManagerException e) {
                            AbstractJobExecutor.logger.error((Object)e.getMessage());
                            throw new CommandExecutorException(e.getMessage());
                        }
                    }
                }
                if (command.getExecutionCompletedTime() == null) {
                    command.setExecutionCompletedTime(Calendar.getInstance());
                }
                AbstractJobExecutor.logger.debug((Object)"END execute");
                return;
            }
            userId = command.getUserId();
            if (userId == null) {
                throw new CommandException("userId not defined!");
            }
            isAdmin = command.getParameterAsString("IS_ADMIN") != null && command.getParameterAsString("IS_ADMIN").equalsIgnoreCase("true") != false;
            cmdType = this.getCommandType(command.getName());
            if ("GET_SERVICE_INFO".equals(command.getName())) {
                jobSubmissionManagerInfo = JobSubmissionManager.getInstance().getJobSubmissionManagerInfo();
                command.getResult().addParameter("ACCEPT_NEW_JOBS", "" + jobSubmissionManagerInfo.isAcceptNewJobs());
                command.getResult().addParameter("SUBMISSION_THRESHOLD_MESSAGE", jobSubmissionManagerInfo.getShowMessage());
                command.getResult().addParameter("SUBMISSION_ERROR_MESSAGE", jobSubmissionManagerInfo.getTestErrorMessage());
                command.getResult().addParameter("SUBMISSION_EXECUTION_TIMESTAMP", jobSubmissionManagerInfo.getExecutionTimestamp());
                sensorHost = this.getParameterValueAsString("CREAM_JOB_SENSOR_HOST");
                if (sensorHost != null && !"changeme".equals(sensorHost)) {
                    command.getResult().addParameter("CEMON_URL", "https://" + sensorHost + ":8443/ce-monitor/services/CEMonitor");
                }
                jobSubmissionManagerInfo = null;
            } else {
                if ("SET_ACCEPT_NEW_JOBS".equals(command.getName())) {
                    accept = command.getParameterAsString("ACCEPT_NEW_JOBS");
                    if (accept == null) {
                        throw new CommandException("ACCEPT_NEW_JOBS value not specified!");
                    }
                    if (!isAdmin) {
                        throw new CommandException("Operation reserved only to administrator!");
                    }
                    try {
                        this.jobSubmissionManager.enableAcceptNewJobs(Integer.parseInt(accept));
                    }
                    catch (NumberFormatException nfe) {
                        throw new CommandException("ACCEPT_NEW_JOBS value not valid!");
                    }
                }
                if ("PROXY_RENEW".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling updateProxyToSandbox.");
                    delegId = command.getParameterAsString("DELEGATION_PROXY_ID");
                    if (delegId == null) {
                        throw new CommandException("parameter \"DELEGATION_PROXY_ID\" not defined!");
                    }
                    delegProxyInfo = command.getParameterAsString("DELEGATION_PROXY_INFO");
                    if (delegProxyInfo == null) {
                        throw new CommandException("parameter \"DELEGATION_PROXY_INFO\" not defined!");
                    }
                    now = Calendar.getInstance();
                    statusType = new int[]{0, 6, 2, 1, 4, 3};
                    jobCmd = new JobCommand();
                    jobCmd.setCreationTime(command.getCreationTime());
                    jobCmd.setDescription(delegProxyInfo);
                    jobCmd.setStartSchedulingTime(command.getStartProcessingTime());
                    jobCmd.setStartProcessingTime(now);
                    jobCmd.setExecutionCompletedTime(now);
                    jobCmd.setType(cmdType);
                    jobCmd.setStatus(6);
                    jobCmd.setCommandExecutorName(this.getName());
                    jobCmd.setUserId(userId);
                    this.insertJobCommand(jobCmd, delegId, statusType);
                } else if ("JOB_REGISTER".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling jobRegister.");
                    this.jobRegister(command);
                } else if ("JOB_SET_LEASEID".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling jobSetLeaseId.");
                    this.jobSetLeaseId(command);
                } else if ("DELETE_LEASE".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling deleteLease.");
                    this.deleteLease(command);
                } else if ("SET_LEASE".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling setLease.");
                    this.setLease(command);
                } else if ("GET_LEASE".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling getLease.");
                    this.getLease(command);
                } else if ("JOB_INFO".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling jobInfo.");
                    this.getJobList(command);
                } else if ("JOB_STATUS".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling jobStatus.");
                    jobEnum = this.getJobList(command);
                    user = null;
                    if (!isAdmin) {
                        user = userId;
                    }
                    try {
                        jobStatusList = this.jobDB.retrieveLastJobStatus(jobEnum.getJobIdList(), user);
                        command.getResult().addParameter("JOB_STATUS_LIST", jobStatusList);
                        if (!command.containsParameterKey("JOB_ID") && !command.containsParameterKey("JOB_ID_LIST") || jobStatusList.size() >= jobEnum.getJobIdList().size()) ** GOTO lbl334
                        jobIdList = new ArrayList<String>(jobStatusList.size());
                        for (JobStatus status : jobStatusList) {
                            jobIdList.add(status.getJobId());
                        }
                        jobEnum.getJobIdList().removeAll(jobIdList);
                        found = 0;
                        jobIdFilterResultList = (List)command.getResult().getParameter("JOBID_FILTER_RESULT_LIST");
                        for (JobIdFilterResult filterResult : jobIdFilterResultList) {
                            if (!jobEnum.getJobIdList().contains(filterResult.getJobId())) continue;
                            filterResult.setErrorCode(1);
                            filterResult.setFailureReason(JobIdFilterFailure.failureReason[1]);
                            if (++found != jobEnum.getJobIdList().size()) continue;
                            break;
                        }
                        command.getResult().addParameter("JOB_ENUM", new JobEnumeration(jobIdList, this.jobDB));
                    }
                    catch (DatabaseException e) {
                        throw new CommandException(e.getMessage());
                    }
                } else if ("QUERY_EVENT".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling queryEvent.");
                    maxEvents = 100;
                    try {
                        maxEvents = Integer.parseInt(command.getParameterAsString("MAX_QUERY_EVENT_RESULT_SIZE"));
                    }
                    catch (Throwable t) {
                        AbstractJobExecutor.logger.warn((Object)"queryEvent: wrong value for MAX_QUERY_EVENT_RESULT_SIZE");
                    }
                    jobStatusTypeArray = null;
                    if (command.containsParameterKey("statusList")) {
                        statusList = command.getParameterMultivalue("statusList");
                        jobStatusTypeArray = new int[statusList.size()];
                        for (i = 0; i < statusList.size(); ++i) {
                            jobStatusTypeArray[i] = -1;
                            for (x = 0; x < JobStatus.statusName.length; ++x) {
                                if (!statusList.get(i).equals(JobStatus.getNameByType(x))) continue;
                                jobStatusTypeArray[i] = x;
                            }
                        }
                    }
                    jobStatusEventManager = (JobStatusEventManagerInterface)EventManagerFactory.getEventManager("JOB_STATUS_EVENT_MANAGER");
                    eventList = null;
                    try {
                        eventList = jobStatusEventManager.getEvents(command.getParameterAsString("FROM_EVENT_ID"), command.getParameterAsString("TO_EVENT_ID"), this.makeDate(command.getParameterAsString("FROM_DATE")), this.makeDate(command.getParameterAsString("TO_DATE")), jobStatusTypeArray, maxEvents, userId);
                    }
                    catch (EventManagerException e) {
                        throw new CommandException(e.getMessage());
                    }
                    command.getResult().addParameter("EVENT_LIST", eventList);
                } else if ("SET_JOB_STATUS".equals(command.getName())) {
                    AbstractJobExecutor.logger.debug((Object)"Calling setJobStatus.");
                    statusType = Integer.valueOf(command.getParameterAsString("STATUS_TYPE"));
                    jobId = command.getParameterAsString("JOB_ID");
                    workerNode = command.getParameterAsString("WORKER_NODE");
                    lrmsJobId = command.getParameterAsString("LRMS_JOB_ID");
                    exitCode = command.getParameterAsString("EXIT_CODE");
                    failureReason = command.getParameterAsString("FAILURE_REASON");
                    changeTime = null;
                    if (command.containsParameterKey("STATUS_CHANGE_TIME")) {
                        changeTime = new GregorianCalendar();
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        dateFormat.setCalendar(changeTime);
                        try {
                            dateFormat.parse(command.getParameterAsString("STATUS_CHANGE_TIME"));
                        }
                        catch (ParseException e) {
                            AbstractJobExecutor.logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    status = new JobStatus(statusType, jobId, changeTime);
                    status.setExitCode(exitCode);
                    status.setFailureReason(failureReason);
                    job = null;
                    try {
                        job = this.jobDB.retrieveJob(status.getJobId(), null);
                    }
                    catch (Exception e) {
                        AbstractJobExecutor.logger.warn((Object)("job " + status.getJobId() + " not found!"));
                        return;
                    }
                    try {
                        if (!this.doOnJobStatusChanged(status, job)) break block107;
                        updateJob = false;
                        if (lrmsJobId != null && (job.getLRMSJobId() == null || job.getLRMSJobId().equalsIgnoreCase("N/A"))) {
                            job.setLRMSJobId(lrmsJobId);
                            updateJob = true;
                        }
                        if (workerNode != null) {
                            isReallyRunning = false;
                            if (job.getWorkerNode() != null && !job.getWorkerNode().equals("N/A") && status.getType() != 4) {
                                for (JobStatus oldStatus : job.getStatusHistory()) {
                                    if (oldStatus.getType() != 4) continue;
                                    isReallyRunning = true;
                                    break;
                                }
                            }
                            if (!isReallyRunning) {
                                job.setWorkerNode(workerNode);
                                updateJob = true;
                            }
                        }
                        if (!updateJob) break block107;
                        try {
                            this.jobDB.update(job);
                        }
                        catch (Throwable e) {
                            AbstractJobExecutor.logger.error((Object)e);
                        }
                    }
                    catch (JobManagementException e) {
                        AbstractJobExecutor.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    if ("JOB_LIST".equals(command.getName())) {
                        AbstractJobExecutor.logger.debug((Object)"Calling jobList.");
                        try {
                            user = null;
                            if (!isAdmin) {
                                user = userId;
                            }
                            jobIdFound = this.jobDB.retrieveJobId(user);
                            jobEnum = new JobEnumeration(jobIdFound, this.jobDB);
                            command.getResult().addParameter("JOB_ENUM", jobEnum);
                        }
                        catch (DatabaseException e) {
                            AbstractJobExecutor.logger.error((Object)e.getMessage());
                            throw new CommandException(e.getMessage());
                        }
                    }
                    jobEnum = this.getJobList(command);
                    try {
                        jobList = new ArrayList<Job>(0);
                        now = Calendar.getInstance();
                        while (jobEnum.hasMoreJobs()) {
                            job = jobEnum.nextJob();
                            jobCmd = new JobCommand();
                            jobCmd.setJobId(job.getId());
                            jobCmd.setCreationTime(command.getCreationTime());
                            jobCmd.setDescription(command.getDescription());
                            jobCmd.setStartSchedulingTime(command.getStartProcessingTime());
                            jobCmd.setStartProcessingTime(now);
                            jobCmd.setType(cmdType);
                            jobCmd.setCommandExecutorName(this.getName());
                            if (!isAdmin || job.getUserId().equals(command.getUserId())) {
                                jobCmd.setUserId(command.getUserId());
                            }
                            if ("JOB_CANCEL".equals(command.getName()) && jobCmd.getDescription() == null) {
                                if (!isAdmin || job.getUserId().equals(command.getUserId())) {
                                    jobCmd.setDescription("Cancelled by user");
                                } else {
                                    jobCmd.setDescription("Cancelled by CE admin");
                                }
                            }
                            AbstractJobExecutor.logger.debug((Object)"Calling jobDB.insertJobCommand.");
                            try {
                                this.jobDB.insertJobCommand(jobCmd);
                            }
                            catch (Throwable e) {
                                AbstractJobExecutor.logger.error((Object)e.getMessage());
                                continue;
                            }
                            AbstractJobExecutor.logger.debug((Object)"jobDB.insertJobCommand has been executed.");
                            if (jobCmd.getStatus() == 7) continue;
                            job.addCommandHistory(jobCmd);
                            jobList.add(job);
                        }
                        for (Job j : jobList) {
                            jobCmd = j.getLastCommand();
                            if (jobCmd == null) continue;
                            jobCmd.setStatus(4);
                            try {
                                if ("JOB_CANCEL".equals(command.getName())) {
                                    if (j.getLastStatus() != null && j.getLastStatus().getType() == 0) {
                                        status = new JobStatus(5, j.getId(), now);
                                        status.setDescription(jobCmd.getDescription());
                                        this.doOnJobStatusChanged(status, j);
                                    } else {
                                        this.cancel(j);
                                    }
                                } else if ("JOB_PURGE".equals(command.getName())) {
                                    this.purge(j);
                                } else if ("JOB_SUSPEND".equals(command.getName())) {
                                    this.suspend(j);
                                } else if ("JOB_RESUME".equals(command.getName())) {
                                    this.resume(j);
                                } else if ("JOB_START".equals(command.getName())) {
                                    command.addParameter("JOB", j);
                                    this.jobStart(command);
                                    sb = new StringBuffer(command.toString());
                                    if (j.getLRMSAbsLayerJobId() != null) {
                                        sb.append(" lrmsAbsJobId=").append(j.getLRMSAbsLayerJobId()).append(";");
                                    }
                                    if (j.getLRMSJobId() != null) {
                                        sb.append(" lrmsJobId=").append(j.getLRMSJobId()).append(";");
                                    }
                                    AbstractJobExecutor.logger.info((Object)sb.toString());
                                    sb = null;
                                    break;
                                }
                                if ("JOB_PURGE".equals(command.getName())) continue;
                                jobCmd.setStatus(6);
                                this.jobDB.updateJobCommand(jobCmd);
                            }
                            catch (CommandException ce) {
                                jobCmd.setStatus(7);
                                jobCmd.setFailureReason(ce.getMessage());
                                this.jobDB.updateJobCommand(jobCmd);
                            }
                        }
                        if ((invalidJobIdlist = (List)command.getResult().getParameter("JOB_ID_LIST_STATUS_NOT_COMPATIBLE_FOUND")) != null) {
                            for (String jobId : invalidJobIdlist) {
                                try {
                                    jobCmd = new JobCommand(cmdType, jobId);
                                    jobCmd.setCreationTime(command.getCreationTime());
                                    jobCmd.setDescription(command.getDescription());
                                    jobCmd.setStartSchedulingTime(command.getStartProcessingTime());
                                    jobCmd.setStatus(7);
                                    jobCmd.setFailureReason("status not compatible with the specified command!");
                                    if (!isAdmin) {
                                        jobCmd.setUserId(command.getUserId());
                                    }
                                    this.jobDB.insertJobCommand(jobCmd);
                                }
                                catch (DatabaseException e) {
                                    AbstractJobExecutor.logger.error((Object)e.getMessage());
                                }
                            }
                        }
                    }
                    catch (DatabaseException e) {
                        throw new CommandException(e.getMessage());
                    }
                    catch (JobManagementException e) {
                        throw new CommandException(e.getMessage());
                    }
                }
            }
        }
        if (command.getExecutionCompletedTime() == null) {
            command.setExecutionCompletedTime(Calendar.getInstance());
        }
        AbstractJobExecutor.logger.debug((Object)"END execute");
    }

    private String normalize(String s) {
        if (s != null) {
            return s.replaceAll("\\W", "_");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobStart(Command command) throws CommandException {
        if (command == null) {
            throw new CommandException("command not defined!");
        }
        if (!command.containsParameterKey("JOB")) {
            throw new CommandException("job not defined!");
        }
        String userDN = command.getParameterAsString("USER_DN");
        if (userDN == null) {
            throw new CommandException("parameter \"USER_DN\" not defined!");
        }
        Job job = (Job)command.getParameter("JOB");
        logger.debug((Object)("Begin jobStart for job " + job.getId()));
        JobStatus status = new JobStatus(1, job.getId());
        try {
            this.doOnJobStatusChanged(status, job);
        }
        catch (Throwable t) {
            throw new CommandException(t.getMessage());
        }
        Calendar now = Calendar.getInstance();
        CommandResult cr = null;
        String failureReason = null;
        for (int i = 1; i < 4 && cr == null; ++i) {
            failureReason = null;
            try {
                cr = this.submit(job);
                continue;
            }
            catch (CommandException ce) {
                failureReason = ce.getMessage();
                logger.warn((Object)("submission to BLAH failed [jobId=" + job.getId() + "; reason=" + failureReason + "; retry count=" + i + "/3]"));
                Calendar calendar = now;
                synchronized (calendar) {
                    try {
                        logger.debug((Object)"sleeping 10 sec...");
                        now.wait(10000L);
                        logger.debug((Object)"sleeping 10 sec... done");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
        }
        if (cr == null) {
            status = new JobStatus(10, job.getId());
            status.setDescription("submission to BLAH failed [retry count=3]");
            status.setFailureReason(failureReason);
            try {
                this.doOnJobStatusChanged(status, job);
            }
            catch (Throwable te) {
                throw new CommandException(te.getMessage());
            }
            this.setLeaseExpired(job);
            throw new CommandException("submission to BLAH failed [retry count=3]" + (failureReason != null ? ": " + failureReason : ""));
        }
        job.setLRMSJobId(cr.getParameterAsString("LRMS_JOB_ID"));
        job.setLRMSAbsLayerJobId(cr.getParameterAsString("LRMS_ABS_JOB_ID"));
        try {
            if (this.isEmptyField(job.getLRMSAbsLayerJobId())) {
                status = new JobStatus(10, job.getId());
                status.setFailureReason("LRMSAbsLayerJobId not found!");
                this.doOnJobStatusChanged(status, job);
                this.setLeaseExpired(job);
            } else {
                this.jobDB.update(job);
                JobStatus lastStatus = this.jobDB.retrieveLastJobStatus(job.getId(), command.getUserId());
                if (lastStatus.getType() == 1) {
                    status = new JobStatus(2, job.getId(), now);
                    this.doOnJobStatusChanged(status, job);
                }
            }
        }
        catch (Throwable te) {
            throw new CommandException(te.getMessage());
        }
        logger.debug((Object)("End jobStart for job " + job.getId()));
    }

    private void jobSetLeaseId(Command command) throws CommandException {
        logger.debug((Object)"Begin setJobLeaseId");
        List<String> jobIdList = null;
        String leaseId = command.getParameterAsString("NEW_LEASE_ID");
        String userId = command.getUserId();
        if (userId == null) {
            throw new CommandException("userId not specified!");
        }
        JobEnumeration jobEnum = this.getJobList(command);
        jobIdList = jobEnum.getJobIdList();
        int commandType = this.getCommandType("JOB_SET_LEASEID");
        for (int index = 0; index < jobIdList.size(); ++index) {
            JobCommand jobCmd = new JobCommand(commandType, jobIdList.get(index));
            jobCmd.setCreationTime(command.getCreationTime());
            jobCmd.setUserId(userId);
            jobCmd.setStartSchedulingTime(command.getStartSchedulingTime());
            jobCmd.setStartProcessingTime(command.getStartProcessingTime());
            jobCmd.setStatus(4);
            try {
                this.jobDB.insertJobCommand(jobCmd);
                this.leaseManager.setJobLeaseId(jobIdList.get(index), leaseId, userId);
                jobCmd.setStatus(6);
                this.jobDB.updateJobCommand(jobCmd);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                jobCmd.setStatus(7);
                jobCmd.setFailureReason(e.getMessage());
                try {
                    this.jobDB.updateJobCommand(jobCmd);
                    continue;
                }
                catch (DatabaseException de) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        logger.debug((Object)"End setJobLeaseId");
    }

    private void getLease(Command command) throws CommandException {
        logger.debug((Object)"Begin getLease");
        List<Object> leaseList = new ArrayList(0);
        try {
            if (command.containsParameterKey("LEASE_ID")) {
                Lease lease = this.jobDB.retrieveJobLease(command.getParameterAsString("LEASE_ID"), command.getUserId());
                if (lease != null) {
                    leaseList.add(lease);
                }
            } else {
                List<Lease> lease = this.jobDB.retrieveJobLease(command.getUserId());
                if (lease != null) {
                    leaseList = lease;
                }
            }
            command.getResult().addParameter("LEASE_LIST", leaseList);
        }
        catch (DatabaseException e) {
            throw new CommandException(e.getMessage());
        }
        logger.debug((Object)"End getLease");
    }

    private void deleteLease(Command command) throws CommandException {
        logger.debug((Object)"Begin deleteLease");
        if (!command.containsParameterKey("LEASE_ID")) {
            throw new CommandException("lease id not specified!");
        }
        String leaseId = command.getParameterAsString("LEASE_ID");
        String userId = command.getUserId();
        if (userId == null) {
            throw new CommandException("userId not specified!");
        }
        this.leaseManager.deleteLease(leaseId, userId);
        logger.debug((Object)"End deleteLease");
    }

    private void setLease(Command command) throws CommandException {
        logger.debug((Object)"BEGIN setLease");
        if (!command.containsParameterKey("LEASE_ID")) {
            throw new CommandException("lease id not specified!");
        }
        if (!command.containsParameterKey("LEASE_TIME")) {
            throw new CommandException("lease time not specified!");
        }
        String userId = command.getUserId();
        String leaseId = command.getParameterAsString("LEASE_ID");
        Calendar leaseTime = null;
        Calendar boundedLeaseTime = null;
        try {
            Long timestamp = Long.parseLong(command.getParameterAsString("LEASE_TIME"));
            leaseTime = Calendar.getInstance();
            leaseTime.setTimeInMillis(timestamp);
            logger.debug((Object)("leaseTime = " + leaseTime.getTime()));
            Lease lease = new Lease();
            lease.setLeaseId(leaseId);
            lease.setUserId(userId);
            lease.setLeaseTime(leaseTime);
            boundedLeaseTime = this.leaseManager.setLease(lease);
            command.getResult().addParameter("LEASE_TIME", boundedLeaseTime);
            logger.debug((Object)("boundedLeaseTime = " + boundedLeaseTime));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage());
            throw new CommandException(e.getMessage());
        }
        catch (CommandException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new CommandException(e.getMessage());
        }
        logger.debug((Object)"END setLease");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void makeVODir(File dir) throws IOException, IllegalArgumentException {
        String groups;
        Runtime runtime;
        block29: {
            if (dir == null) {
                throw new IllegalArgumentException("parameter \"dir\" not specified!");
            }
            runtime = Runtime.getRuntime();
            runtime.exec("chmod 775 " + dir.getAbsolutePath());
            Process proc = Runtime.getRuntime().exec("groups");
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            BufferedReader in = new BufferedReader(isr);
            String inputLine = "";
            groups = "";
            try {
                while ((inputLine = in.readLine()) != null) {
                    groups = groups + inputLine + " ";
                }
                Object var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                in.close();
                throw throwable;
            }
            in.close();
            proc.waitFor();
            Object var12_15 = null;
            try {
                proc.getInputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getErrorStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getOutputStream().close();
            }
            catch (IOException ioe) {}
            break block29;
            {
                catch (InterruptedException e) {
                    logger.warn((Object)("makeVODir: " + e.getMessage()));
                    var12_15 = null;
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        String[] groupArray = groups.split(" ");
        for (int i = 0; i < groupArray.length; ++i) {
            String subDirPath = dir.getAbsolutePath() + "/" + groupArray[i];
            File subDir = new File(subDirPath);
            if (!subDir.exists()) {
                subDir.mkdir();
                runtime.exec("chmod 770 " + subDirPath);
                runtime.exec("chgrp " + groupArray[i] + " " + subDirPath);
            }
            subDir = null;
        }
    }

    private boolean isEmptyField(String field) {
        return field == null || "N/A".equals(field) || field.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createJobSandboxDir(Job job, String gsiFTPcreamURL) throws CommandException, InterruptedException, IOException {
        IOException ioe222;
        Process proc;
        BufferedReader readErr;
        FilterOutputStream os;
        BufferedReader in;
        block97: {
            Runtime runtime = Runtime.getRuntime();
            in = null;
            os = null;
            readErr = null;
            proc = null;
            if (!this.containsParameterKey(JOB_WRAPPER_TEMPLATE_PATH)) {
                throw new CommandException("parameter \"JOB_WRAPPER_TEMPLATE_PATH\" not defined!");
            }
            String cream_sandbox_dir = this.getParameterValueAsString("CREAM_SANDBOX_DIR");
            if (cream_sandbox_dir == null) {
                throw new CommandException("parameter \"CREAM_SANDBOX_DIR\" not defined!");
            }
            job.setCREAMSandboxBasePath(cream_sandbox_dir);
            if (!this.containsParameterKey("CREAM_CREATE_SANDBOX_BIN_PATH")) {
                throw new CommandException("parameter \"CREAM_CREATE_SANDBOX_BIN_PATH\" not defined!");
            }
            String[] cmd = new String[]{"sudo", "-S", "-n", "-u", job.getLocalUser(), this.getParameterValueAsString("CREAM_CREATE_SANDBOX_BIN_PATH"), cream_sandbox_dir, job.getUserId(), job.getId(), "true"};
            try {
                proc = runtime.exec(cmd);
            }
            catch (Throwable e) {
                logger.error((Object)("createJobSandboxDir: " + e.getMessage()), e);
                throw new IOException("Cannot create the sandbox for job " + job.getId() + "! " + e.getMessage());
            }
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            os = new BufferedOutputStream(proc.getOutputStream());
            readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            try {
                job.setWorkingDirectory(in.readLine());
                if (job.getWorkingDirectory() == null) {
                    job.setWorkingDirectory("N/A");
                    throw new IOException();
                }
            }
            catch (IOException e) {
                throw new IOException("cannot create the job's working directory!");
            }
            if (gsiFTPcreamURL != null && job.getWorkingDirectory() != null) {
                int index;
                job.setCREAMInputSandboxURI(gsiFTPcreamURL + job.getWorkingDirectory() + "/ISB");
                job.setCREAMOutputSandboxURI(gsiFTPcreamURL + job.getWorkingDirectory() + "/OSB");
                String dsUploadFile = null;
                if (job.containsVolatilePropertyKeys("OUTPUT_DATA")) {
                    if ("N/A".equals(job.getGridJobId()) || job.getGridJobId() == null) {
                        dsUploadFile = "DSUpload_" + job.getId() + ".out";
                        job.getOutputFiles().add(dsUploadFile);
                        job.addVolatileProperty("DS_UPLOAD_OUTPUT_FILE", dsUploadFile);
                    } else {
                        job.addVolatileProperty("DS_UPLOAD_OUTPUT_FILE", "DSUpload_" + job.getGridJobId().substring(job.getGridJobId().lastIndexOf(47) + 1) + ".out");
                    }
                }
                if (this.containsParameterKey(SANDBOX_TRANSFER_METHOD)) {
                    job.addVolatileProperty(SANDBOX_TRANSFER_METHOD, this.getParameterValueAsString(SANDBOX_TRANSFER_METHOD));
                } else {
                    job.addVolatileProperty(SANDBOX_TRANSFER_METHOD, GSIFTP_SANDBOX_TRANSFER_METHOD);
                }
                if (GSIFTP_SANDBOX_TRANSFER_METHOD.equalsIgnoreCase((String)job.getVolatileProperty(SANDBOX_TRANSFER_METHOD))) {
                    if (job.getOutputFiles() != null && job.getOutputFiles().size() > 0) {
                        if (job.getOutputSandboxBaseDestURI() != null) {
                            if ("gsiftp://localhost".equalsIgnoreCase(job.getOutputSandboxBaseDestURI())) {
                                job.setOutputSandboxBaseDestURI(job.getCREAMOutputSandboxURI());
                            }
                        } else {
                            index = 0;
                            int i = 0;
                            String outputFile = null;
                            ArrayList<String> outputSandboxDestURI = new ArrayList<String>(0);
                            if (dsUploadFile != null) {
                                job.getOutputSandboxDestURI().add(job.getCREAMOutputSandboxURI() + File.separator + dsUploadFile);
                            }
                            for (String file : job.getOutputSandboxDestURI()) {
                                if (file.startsWith("gsiftp://localhost")) {
                                    outputFile = file.equals("gsiftp://localhost") ? job.getOutputFiles().get(i) : file.substring("gsiftp://localhost".length() + 1);
                                    index = outputFile.lastIndexOf("/");
                                    outputFile = index > 0 ? outputFile.substring(index + 1) : outputFile;
                                    outputSandboxDestURI.add(job.getCREAMOutputSandboxURI() + outputFile);
                                } else {
                                    outputSandboxDestURI.add(file);
                                }
                                ++i;
                            }
                            job.setOutputSandboxDestURI(outputSandboxDestURI);
                        }
                    }
                } else {
                    if (!LRMS_SANDBOX_TRANSFER_METHOD.equalsIgnoreCase((String)job.getVolatileProperty(SANDBOX_TRANSFER_METHOD))) throw new CommandException("sandbox transfer mode \"" + job.getVolatileProperty(SANDBOX_TRANSFER_METHOD) + "\" not supported!");
                    index = 0;
                    if (job.getInputFiles() != null && job.getInputFiles().size() > 0) {
                        String inputFile = null;
                        StringBuffer transferInput = new StringBuffer();
                        ArrayList<String> inputFiles = new ArrayList<String>(0);
                        ArrayList<String> lrmsInputFiles = new ArrayList<String>(0);
                        for (String file : job.getInputFiles()) {
                            if (file.startsWith("/") || file.startsWith("file://") || job.getInputSandboxBaseURI() == null && !file.startsWith("gsiftp://") && !file.startsWith("https://")) {
                                index = file.lastIndexOf("/");
                                inputFile = index > 0 ? file.substring(index + 1) : file;
                                transferInput.append(inputFile).append(",");
                                lrmsInputFiles.add(inputFile);
                                continue;
                            }
                            inputFiles.add(file);
                        }
                        if (transferInput.length() > 0) {
                            transferInput.replace(transferInput.length() - 1, transferInput.length(), "\"");
                            job.addExtraAttribute("TransferInput", "TransferInput=\"" + transferInput.toString());
                            job.addExtraAttribute("iwd", "iwd=\"" + job.getWorkingDirectory() + "/ISB\"");
                        }
                        if (inputFiles.size() == 0) {
                            job.setInputSandboxBaseURI(null);
                            job.setInputFiles(null);
                        } else {
                            job.setInputFiles(inputFiles);
                        }
                        if (lrmsInputFiles.size() > 0) {
                            job.addVolatileProperty(LRMS_INPUT_FILES, lrmsInputFiles);
                        }
                    }
                    if (job.getOutputFiles() != null && job.getOutputFiles().size() > 0) {
                        String outputFile = null;
                        String osbDir = job.getWorkingDirectory() + "/OSB/";
                        StringBuffer transferOutput = new StringBuffer();
                        StringBuffer transferOutputRemaps = new StringBuffer();
                        ArrayList<String> outputFiles = new ArrayList<String>(0);
                        ArrayList<String> lrmsOutputFiles = new ArrayList<String>(0);
                        ArrayList<String> outputSandboxDestURI = new ArrayList<String>(0);
                        if (job.getOutputSandboxBaseDestURI() != null) {
                            if ("gsiftp://localhost".equalsIgnoreCase(job.getOutputSandboxBaseDestURI())) {
                                for (String file : job.getOutputFiles()) {
                                    index = file.lastIndexOf("/");
                                    outputFile = index > 0 ? file.substring(index + 1) : file;
                                    lrmsOutputFiles.add(outputFile);
                                    transferOutput.append(outputFile).append(",");
                                    transferOutputRemaps.append(outputFile).append("=").append(osbDir).append(outputFile).append(";");
                                }
                                job.setOutputFiles(null);
                                job.setOutputSandboxBaseDestURI(null);
                            }
                        } else {
                            int i = 0;
                            if (dsUploadFile != null) {
                                job.getOutputSandboxDestURI().add("gsiftp://localhost");
                            }
                            for (String file : job.getOutputSandboxDestURI()) {
                                outputFile = job.getOutputFiles().get(i++);
                                if (file.startsWith("gsiftp://localhost")) {
                                    index = outputFile.lastIndexOf("/");
                                    outputFile = index > 0 ? outputFile.substring(index + 1) : outputFile;
                                    lrmsOutputFiles.add(outputFile);
                                    transferOutput.append(outputFile).append(",");
                                    transferOutputRemaps.append(outputFile).append("=").append(osbDir);
                                    if (file.length() > "gsiftp://localhost".length()) {
                                        outputFile = file.substring("gsiftp://localhost".length() + 1);
                                        index = outputFile.lastIndexOf("/");
                                        outputFile = index > 0 ? file.substring(index + 1) : outputFile;
                                    }
                                    transferOutputRemaps.append(outputFile).append(";");
                                    continue;
                                }
                                outputFiles.add(outputFile);
                                outputSandboxDestURI.add(file);
                            }
                            job.setOutputFiles(outputFiles.size() > 0 ? outputFiles : null);
                            job.setOutputSandboxDestURI(outputSandboxDestURI.size() > 0 ? outputSandboxDestURI : null);
                        }
                        if (transferOutput.length() > 0) {
                            transferOutput.replace(transferOutput.length() - 1, transferOutput.length(), "\"");
                            transferOutputRemaps.replace(transferOutputRemaps.length() - 1, transferOutputRemaps.length(), "\"");
                            job.addExtraAttribute("TransferOutput", "TransferOutput=\"" + transferOutput.toString());
                            job.addExtraAttribute("TransferOutputRemaps", "TransferOutputRemaps=\"" + transferOutputRemaps.toString());
                        }
                        if (lrmsOutputFiles.size() > 0) {
                            job.addVolatileProperty(LRMS_OUTPUT_FILES, lrmsOutputFiles);
                        }
                    }
                }
            } else {
                job.setCREAMInputSandboxURI("N/A");
                job.setCREAMOutputSandboxURI("N/A");
            }
            String id = "" + StrictMath.random();
            if (id.charAt(1) == '.') {
                id = id.substring(2);
            }
            if (id.length() > 20) {
                id = id.substring(0, 20);
            }
            if (gsiFTPcreamURL != null && (this.isEmptyField(job.getICEId()) || !this.isEmptyField(job.getICEId()) && !this.isEmptyField(job.getMyProxyServer()))) {
                job.addExtraAttribute("PROXY_RENEWAL", "ENABLED");
                job.addVolatileProperty(DELEGATION_PROXY_CERT_SANDBOX_URI, gsiFTPcreamURL + job.getDelegationProxyCertPath());
                if (this.containsParameterKey(JOB_WRAPPER_DELEGATION_TIME_SLOT)) {
                    job.addVolatileProperty(JOB_WRAPPER_DELEGATION_TIME_SLOT, (String)this.getParameterValue(JOB_WRAPPER_DELEGATION_TIME_SLOT));
                }
            } else {
                job.addExtraAttribute("PROXY_RENEWAL", "DISABLED");
            }
            if (this.containsParameterKey(JOB_WRAPPER_COPY_PROXY_MIN_RETRY_WAIT)) {
                job.addVolatileProperty(JOB_WRAPPER_COPY_PROXY_MIN_RETRY_WAIT, (String)this.getParameterValue(JOB_WRAPPER_COPY_PROXY_MIN_RETRY_WAIT));
            }
            if (this.containsParameterKey(JOB_WRAPPER_COPY_RETRY_COUNT_ISB)) {
                job.addVolatileProperty(JOB_WRAPPER_COPY_RETRY_COUNT_ISB, (String)this.getParameterValue(JOB_WRAPPER_COPY_RETRY_COUNT_ISB));
            }
            if (this.containsParameterKey(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_ISB)) {
                job.addVolatileProperty(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_ISB, (String)this.getParameterValue(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_ISB));
            }
            if (this.containsParameterKey(JOB_WRAPPER_COPY_RETRY_COUNT_OSB)) {
                job.addVolatileProperty(JOB_WRAPPER_COPY_RETRY_COUNT_OSB, (String)this.getParameterValue(JOB_WRAPPER_COPY_RETRY_COUNT_OSB));
            }
            if (this.containsParameterKey(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_OSB)) {
                job.addVolatileProperty(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_OSB, (String)this.getParameterValue(JOB_WRAPPER_COPY_RETRY_FIRST_WAIT_OSB));
            }
            job.addVolatileProperty(JOB_WRAPPER_TEMPLATE_PATH, this.getParameterValueAsString(JOB_WRAPPER_TEMPLATE_PATH));
            String tmpWrapper = null;
            try {
                tmpWrapper = JobWrapper.buildWrapper(job);
            }
            catch (Throwable e) {
                proc.destroy();
                throw new CommandException("cannot generate the job wrapper! the problem seems to be related to the jdl: " + e.getMessage());
            }
            if (tmpWrapper == null) {
                throw new CommandException("cannot generate the job wrapper!");
            }
            try {
                os.write(tmpWrapper.getBytes());
                ((BufferedOutputStream)os).flush();
                os.close();
                os = null;
            }
            catch (Throwable e) {
                throw new CommandException("cannot write the job wrapper (jobId = " + job.getId() + ")!");
            }
            Object var23_37 = null;
            if (proc == null) break block97;
            proc.waitFor();
            try {
                proc.getInputStream().close();
            }
            catch (IOException ioe222) {
                // empty catch block
            }
            try {
                proc.getErrorStream().close();
            }
            catch (IOException ioe222) {
                // empty catch block
            }
            try {
                proc.getOutputStream().close();
            }
            catch (IOException ioe222) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe222) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ioe222) {
                // empty catch block
            }
        }
        if (readErr == null) return;
        try {
            readErr.close();
            return;
        }
        catch (IOException ex) {}
        return;
        {
            catch (CommandException ce) {
                throw ce;
            }
            catch (Throwable exx) {
                IOException ioe222;
                if (proc == null) throw new CommandException(exx.getMessage());
                proc.waitFor();
                if (proc.exitValue() != 0) {
                    String procErrorMessage = null;
                    if (readErr.ready()) {
                        procErrorMessage = " [failure reason = \"" + readErr.readLine() + "\"]";
                    }
                    procErrorMessage = procErrorMessage + " [exit code = " + proc.exitValue() + "]";
                    throw new CommandException(exx.getMessage() + procErrorMessage);
                }
                Object var23_38 = null;
                if (proc != null) {
                    proc.waitFor();
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (readErr == null) return;
                try {
                    readErr.close();
                    return;
                }
                catch (IOException ex) {}
                return;
            }
        }
        catch (Throwable throwable) {
            IOException ioe222;
            Object var23_39 = null;
            if (proc != null) {
                proc.waitFor();
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (readErr == null) throw throwable;
            try {
                readErr.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected Job makeJobFromCmd(Command cmd) throws CommandException {
        String jdl = cmd.getParameterAsString("JDL");
        if (jdl == null) {
            throw new CommandException("JDL not defined!");
        }
        try {
            return JobFactory.makeJob(jdl);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new CommandException(e.getMessage());
        }
    }

    private void jobRegister(Command cmd) throws CommandException, CommandExecutorException {
        logger.debug((Object)"BEGIN jobRegister");
        if (cmd == null) {
            throw new CommandException("command not defined!");
        }
        JobCommand jobCmd = new JobCommand(this.getCommandType("JOB_REGISTER"));
        jobCmd.setStatus(cmd.getStatus());
        jobCmd.setCreationTime(cmd.getCreationTime());
        jobCmd.setDescription(cmd.getDescription());
        jobCmd.setUserId(cmd.getUserId());
        jobCmd.setStartSchedulingTime(cmd.getStartProcessingTime());
        try {
            Boolean autostart_b;
            String leaseId;
            List<String> fqanList;
            String userId = cmd.getUserId();
            if (userId == null) {
                throw new CommandException("userId not defined!");
            }
            Job job = this.makeJobFromCmd(cmd);
            JobStatus status = new JobStatus(0, job.getId());
            job.setUserId(userId);
            job.setLocalUser(cmd.getParameterAsString("LOCAL_USER"));
            job.setJDL(cmd.getParameterAsString("JDL"));
            job.setICEId(cmd.getParameterAsString("ICE_ID"));
            job.addCommandHistory(jobCmd);
            if (cmd.containsParameterKey("USER_VO")) {
                job.setVirtualOrganization(cmd.getParameterAsString("USER_VO"));
            }
            if (this.isEmptyField(job.getBatchSystem())) {
                throw new CommandException("\"BatchSystem\" attribute not defined into the JDL");
            }
            if (this.isEmptyField(job.getQueue())) {
                throw new CommandException("\"QueueName\" attribute not defined into the JDL");
            }
            if (!this.isBatchSystemSupported(job.getBatchSystem())) {
                throw new CommandException("Batch System " + job.getBatchSystem() + " not supported!");
            }
            String cream_sandbox_dir = this.getParameterValueAsString("CREAM_SANDBOX_DIR");
            if (cream_sandbox_dir == null) {
                throw new CommandException("parameter \"CREAM_SANDBOX_DIR\" not defined!");
            }
            job.setCreamURL(cmd.getParameterAsString("CREAM_URL"));
            job.setDelegationProxyId(cmd.getParameterAsString("DELEGATION_PROXY_ID"));
            job.setDelegationProxyInfo(cmd.getParameterAsString("DELEGATION_PROXY_INFO"));
            job.setDelegationProxyCertPath(cmd.getParameterAsString("DELEGATION_PROXY_PATH"));
            job.setLRMSAbsLayerJobId("N/A");
            job.setLRMSJobId("N/A");
            job.setWorkerNode("N/A");
            job.setWorkingDirectory("N/A");
            if (cmd.containsParameterKey("USER_DN")) {
                job.addExtraAttribute("USER_DN", cmd.getParameterAsString("USER_DN").replaceAll("\\s+", "\\\\ "));
            }
            if (cmd.containsParameterKey("USER_DN_X500")) {
                job.addExtraAttribute("USER_DN_X500", cmd.getParameterAsString("USER_DN_X500").replaceAll("\\s+", "\\\\ "));
            }
            if (cmd.containsParameterKey("LOCAL_USER_GROUP")) {
                job.addExtraAttribute("LOCAL_USER_GROUP", cmd.getParameterAsString("LOCAL_USER_GROUP"));
            }
            if (cmd.containsParameterKey("USER_FQAN") && (fqanList = cmd.getParameterMultivalue("USER_FQAN")) != null && fqanList.size() > 0) {
                StringBuffer fqanBuffer = new StringBuffer();
                for (String fqan : fqanList) {
                    fqanBuffer.append("\\\"userFQAN=").append(fqan.replaceAll("\\s+", "\\\\ ")).append("\\\"\\ ");
                }
                fqanBuffer.deleteCharAt(fqanBuffer.length() - 1);
                fqanBuffer.deleteCharAt(fqanBuffer.length() - 1);
                job.addExtraAttribute("USER_FQAN", fqanBuffer.toString());
            }
            if (this.containsParameterKey("LRMS_EVENT_LISTENER_PORT")) {
                job.setLoggerDestURI(InetAddress.getLocalHost().getHostAddress() + ":" + this.getParameterValueAsString("LRMS_EVENT_LISTENER_PORT"));
            }
            if (job.getCreamURL() != null) {
                try {
                    URL url = new URL(job.getCreamURL());
                    job.setCeId(url.getHost() + ":" + url.getPort() + "/cream-" + job.getBatchSystem() + "-" + job.getQueue());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (cmd.containsParameterKey("LEASE_ID") && (leaseId = cmd.getParameterAsString("LEASE_ID")) != null && leaseId.length() > 0) {
                Lease lease = this.jobDB.retrieveJobLease(leaseId, userId);
                if (lease != null) {
                    logger.debug((Object)("found lease \"" + leaseId + "\" = " + lease.getLeaseTime().getTime()));
                    job.setLease(lease);
                } else {
                    throw new CommandException("lease id \"" + leaseId + "\" not found!");
                }
            }
            boolean jobInserted = false;
            int count = 0;
            while (!jobInserted && count < 5) {
                try {
                    this.jobDB.insert(job);
                    jobInserted = true;
                }
                catch (DatabaseException de) {
                    if (de.getMessage().indexOf("Duplicate entry") > -1) {
                        job.setId(job.generateJobId());
                        ++count;
                        continue;
                    }
                    throw new CommandException(de.getMessage());
                }
                catch (IllegalArgumentException ie) {
                    throw new CommandException(ie.getMessage());
                }
            }
            if (!jobInserted) {
                throw new CommandException("Duplicate jobId error: cannot insert the new job (" + job.getId() + ") into the database");
            }
            jobCmd.setJobId(job.getId());
            jobCmd.setStatus(6);
            try {
                try {
                    this.createJobSandboxDir(job, cmd.getParameterAsString("GSI_FTP_CREAM_URL"));
                }
                catch (Throwable e) {
                    jobCmd.setStatus(7);
                    jobCmd.setFailureReason(e.getMessage());
                    status.setType(10);
                    status.setFailureReason(e.getMessage());
                    this.doOnJobStatusChanged(status, job);
                    throw new CommandException(e.getMessage());
                }
                Object var12_19 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                this.jobDB.update(job);
                this.jobDB.updateJobCommand(jobCmd);
                throw throwable;
            }
            this.jobDB.update(job);
            this.jobDB.updateJobCommand(jobCmd);
            this.doOnJobStatusChanged(status, job);
            String autostart = cmd.getParameterAsString("AUTOSTART");
            Boolean bl = autostart_b = autostart != null ? new Boolean(autostart) : new Boolean(Boolean.FALSE);
            if (autostart_b.booleanValue()) {
                cmd.addParameter("JOB", job);
                this.jobStart(cmd);
            }
            cmd.getResult().addParameter("JOB", job);
        }
        catch (CommandException e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new CommandExecutorException(e);
        }
        logger.debug((Object)"END jobRegister");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void purge(Job job) throws CommandException, IllegalArgumentException {
        block50: {
            StringBuffer errorMessage;
            Process proc;
            block63: {
                block52: {
                    if (job == null) {
                        throw new IllegalArgumentException("job not defined!");
                    }
                    if (this.isEmptyField(job.getWorkingDirectory())) break block50;
                    proc = null;
                    String[] cmd = new String[]{"sudo", "-S", "-n", "-u", job.getLocalUser(), this.getParameterValueAsString("CREAM_PURGE_SANDBOX_BIN_PATH"), job.getWorkingDirectory()};
                    proc = Runtime.getRuntime().exec(cmd);
                    Object var5_6 = null;
                    if (proc == null) break block50;
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    errorMessage = null;
                    if (proc.exitValue() == 0) break block63;
                    BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    errorMessage = new StringBuffer();
                    String inputLine = null;
                    while ((inputLine = readErr.readLine()) != null) {
                        errorMessage.append(inputLine);
                    }
                    Object var11_18 = null;
                    try {
                        readErr.close();
                    }
                    catch (IOException ioe2) {}
                    break block52;
                    {
                        catch (IOException ioe) {
                            logger.error((Object)ioe.getMessage());
                            Object var11_19 = null;
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe2) {}
                            break block52;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_20 = null;
                        try {
                            readErr.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (errorMessage.length() > 0) {
                    errorMessage.append("\n");
                }
            }
            try {
                proc.getInputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getErrorStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                proc.getOutputStream().close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (errorMessage != null) {
                throw new CommandException(errorMessage.toString());
            }
            break block50;
            {
                catch (Throwable e) {
                    block64: {
                        block58: {
                            logger.error((Object)e.getMessage());
                            Object var5_7 = null;
                            if (proc == null) break block50;
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            errorMessage = null;
                            if (proc.exitValue() == 0) break block64;
                            BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            errorMessage = new StringBuffer();
                            String inputLine = null;
                            while ((inputLine = readErr.readLine()) != null) {
                                errorMessage.append(inputLine);
                            }
                            Object var11_21 = null;
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe2) {}
                            break block58;
                            {
                                catch (IOException ioe) {
                                    logger.error((Object)ioe.getMessage());
                                    Object var11_22 = null;
                                    try {
                                        readErr.close();
                                    }
                                    catch (IOException ioe2) {}
                                    break block58;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var11_23 = null;
                                try {
                                    readErr.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                    }
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (errorMessage != null) {
                        throw new CommandException(errorMessage.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                block65: {
                    block66: {
                        block67: {
                            Object var5_8 = null;
                            if (proc == null) break block65;
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            errorMessage = null;
                            if (proc.exitValue() == 0) break block66;
                            BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            errorMessage = new StringBuffer();
                            String inputLine = null;
                            while ((inputLine = readErr.readLine()) != null) {
                                errorMessage.append(inputLine);
                            }
                            Object var11_24 = null;
                            try {
                                readErr.close();
                            }
                            catch (IOException ioe2) {}
                            break block67;
                            {
                                catch (IOException ioe) {
                                    logger.error((Object)ioe.getMessage());
                                    Object var11_25 = null;
                                    try {
                                        readErr.close();
                                    }
                                    catch (IOException ioe2) {}
                                }
                            }
                            catch (Throwable throwable2) {
                                Object var11_26 = null;
                                try {
                                    readErr.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                                throw throwable2;
                            }
                        }
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                    }
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (errorMessage != null) {
                        throw new CommandException(errorMessage.toString());
                    }
                }
                throw throwable;
            }
        }
        try {
            this.jobDB.delete(job.getId(), job.getUserId());
            logger.info((Object)("purge: purged job " + job.getId()));
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage());
            throw new CommandException(e.getMessage());
        }
    }

    @Override
    public void execute(List<Command> commandList) throws CommandExecutorException, CommandException {
        if (commandList == null) {
            return;
        }
        for (Command command : commandList) {
            this.execute(command);
        }
    }

    public abstract CommandResult submit(Job var1) throws CommandException;

    public abstract void cancel(Job var1) throws CommandException;

    public abstract void suspend(Job var1) throws CommandException;

    public abstract void resume(Job var1) throws CommandException;

    public abstract void renewProxy(Job var1) throws CommandException;

    public abstract void renewProxy(Job var1, boolean var2) throws CommandException;

    public abstract boolean isBatchSystemSupported(String var1);

    @Override
    public boolean doOnJobStatusChanged(JobStatus status) throws IllegalArgumentException, JobManagementException {
        Job job = null;
        try {
            job = this.jobDB.retrieveJob(status.getJobId(), null);
        }
        catch (Exception e) {
            logger.warn((Object)("job " + status.getJobId() + " not found!"));
            return false;
        }
        return this.doOnJobStatusChanged(status, job);
    }

    /*
     * Unable to fully structure code
     */
    private boolean doOnJobStatusChanged(JobStatus status, Job job) throws IllegalArgumentException, JobManagementException {
        block44: {
            block43: {
                statusUpdated = false;
                if (status == null) {
                    throw new IllegalArgumentException("job status not defined!");
                }
                if (status.getType() == 9) {
                    return statusUpdated;
                }
                if (job == null) {
                    AbstractJobExecutor.logger.warn((Object)("job " + status.getJobId() + " not found!"));
                    return false;
                }
                lastStatus = job.getLastStatus();
                if (lastStatus == null || status.getType() != lastStatus.getType()) break block43;
                if (!lastStatus.getName().startsWith("DONE")) break block44;
                try {
                    block45: {
                        if (!"W".equalsIgnoreCase(lastStatus.getExitCode())) {
                            status.setExitCode(lastStatus.getExitCode());
                        }
                        if (status.getFailureReason() == null) break block45;
                        if (lastStatus.getFailureReason() == null) ** GOTO lbl-1000
                        if (!lastStatus.getFailureReason().equals("N/A") && !status.getFailureReason().equals(lastStatus.getFailureReason())) {
                            status.setFailureReason(lastStatus.getFailureReason() + "; " + status.getFailureReason());
                        } else lbl-1000:
                        // 2 sources

                        {
                            status.setFailureReason(status.getFailureReason());
                        }
                    }
                    status.setId(lastStatus.getId());
                    this.jobDB.updateStatus(status, null);
                    statusUpdated = true;
                    AbstractJobExecutor.logger.info((Object)("JOB " + status.getJobId() + " STATUS UPDATED: " + status.getName()));
                    try {
                        this.sendNotification(job);
                    }
                    catch (Throwable e) {
                        AbstractJobExecutor.logger.error((Object)e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    AbstractJobExecutor.logger.error((Object)e);
                    throw new JobManagementException(e);
                }
                catch (DatabaseException e) {
                    AbstractJobExecutor.logger.error((Object)e);
                    throw new JobManagementException(e);
                }
            }
            if (lastStatus != null && (lastStatus.getType() == 10 || lastStatus.getType() == 5 || lastStatus.getType() == 7 || lastStatus.getType() == 8)) {
                return statusUpdated;
            }
            switch (status.getType()) {
                case 10: {
                    this.setLeaseExpired(job);
                    break;
                }
                case 5: {
                    status.setDescription("Cancelled by CE admin");
                    cancelType = this.getCommandType("JOB_CANCEL");
                    for (i = job.getCommandHistoryCount() - 1; i >= 0; --i) {
                        if (job.getCommandHistoryAt(i).getType() != cancelType) continue;
                        status.setDescription(job.getCommandHistoryAt(i).getDescription());
                        break;
                    }
                    this.setLeaseExpired(job);
                    break;
                }
                case 7: 
                case 8: {
                    if (status.getType() == 8) {
                        cancelledType = this.getCommandType("JOB_CANCEL");
                        for (i = job.getCommandHistoryCount() - 1; i >= 0; --i) {
                            if (job.getCommandHistoryAt(i).getType() != cancelledType) continue;
                            status.setType(5);
                            status.setExitCode(null);
                            status.setDescription(job.getCommandHistoryAt(i).getDescription());
                            break;
                        }
                    }
                    if ("W".equalsIgnoreCase(status.getExitCode())) {
                        time = Calendar.getInstance();
                        time.add(12, 1);
                        AbstractJobExecutor.timer.schedule((TimerTask)new GetSTDTask(status.getJobId()), time.getTime());
                        AbstractJobExecutor.timer.purge();
                    }
                    this.setLeaseExpired(job);
                    break;
                }
                case 4: {
                    if (lastStatus == null || lastStatus.getType() != 10 && lastStatus.getType() != 5 && lastStatus.getType() != 7 && lastStatus.getType() != 8) break;
                    return statusUpdated;
                }
                case 3: {
                    if (status.getTimestamp().compareTo(lastStatus.getTimestamp()) <= 0) {
                        return statusUpdated;
                    }
                    if (lastStatus != null && (lastStatus.getType() == 4 || lastStatus.getType() == 10 || lastStatus.getType() == 5 || lastStatus.getType() == 7 || lastStatus.getType() == 8)) {
                        return statusUpdated;
                    }
                    try {
                        statusList = this.jobDB.retrieveJobStatusHistory(status.getJobId(), null);
                        if (statusList == null || statusList.size() <= 2) break;
                        oldStatus = statusList.get(statusList.size() - 2);
                        status.setType(oldStatus.getType() == 4 ? 4 : 3);
                        break;
                    }
                    catch (DatabaseException e) {
                        throw new JobManagementException(e);
                    }
                }
                case 0: 
                case 1: 
                case 2: 
                case 6: {
                    if (lastStatus == null || status.getTimestamp().compareTo(lastStatus.getTimestamp()) >= 0) break;
                    AbstractJobExecutor.logger.warn((Object)("the timestamp of the new status " + status.getName() + " for the JOB " + status.getJobId() + " is older than the last one"));
                    return statusUpdated;
                }
            }
            try {
                job.addStatus(status);
                AbstractJobExecutor.logger.debug((Object)("inserting new status " + status.getName() + " for the JOB " + status.getJobId()));
                this.jobDB.insertStatus(status, null);
                statusUpdated = true;
                logInfo = new StringBuffer("JOB ");
                logInfo.append(status.getJobId());
                if (lastStatus == null) {
                    logInfo.append(" STATUS CHANGED: -- => ").append(status.getName());
                } else {
                    logInfo.append(" STATUS CHANGED: ").append(lastStatus.getName()).append(" => ").append(status.getName());
                }
                if (!this.isEmptyField(status.getDescription())) {
                    logInfo.append(" [description=").append(status.getDescription()).append("]");
                }
                if (!this.isEmptyField(status.getFailureReason())) {
                    logInfo.append(" [failureReason=" + status.getFailureReason() + "]");
                }
                if (!this.isEmptyField(status.getExitCode())) {
                    logInfo.append(" [exitCode=").append(status.getExitCode()).append("]");
                }
                if (!this.isEmptyField(job.getLocalUser())) {
                    logInfo.append(" [localUser=" + job.getLocalUser() + "]");
                }
                if (!this.isEmptyField(job.getGridJobId())) {
                    logInfo.append(" [gridJobId=" + job.getGridJobId() + "]");
                }
                if (!this.isEmptyField(job.getLRMSJobId())) {
                    logInfo.append(" [lrmsJobId=").append(job.getLRMSJobId()).append("]");
                }
                if (!this.isEmptyField(job.getWorkerNode())) {
                    logInfo.append(" [workerNode=").append(job.getWorkerNode()).append("]");
                }
                if (!this.isEmptyField(job.getDelegationProxyId())) {
                    logInfo.append(" [delegationId=").append(job.getDelegationProxyId()).append("]");
                }
                AbstractJobExecutor.logger.info((Object)logInfo.toString());
            }
            catch (IllegalArgumentException e) {
                AbstractJobExecutor.logger.error((Object)e);
                throw new JobManagementException(e);
            }
            catch (DatabaseException e) {
                AbstractJobExecutor.logger.error((Object)e);
                throw new JobManagementException(e);
            }
            try {
                this.sendNotification(job);
            }
            catch (Throwable e) {
                AbstractJobExecutor.logger.error((Object)e.getMessage());
            }
        }
        return statusUpdated;
    }

    private String getExitCode(String filePath, String userId) throws IllegalArgumentException, Exception {
        String s = this.readFile(filePath, userId);
        if (s == null) {
            return "N/A";
        }
        String pattern = "job exit status = ";
        int index = s.indexOf(pattern);
        if (index > -1) {
            s = s.substring(index + pattern.length());
            s = s.substring(0, s.indexOf(" "));
            s = s.trim();
        } else {
            s = "N/A";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readFile(String stdErrorFilePath, String userId) throws IllegalArgumentException, InterruptedException, IOException {
        String message;
        block57: {
            BufferedReader readIn;
            Process proc;
            block47: {
                message = "";
                if (stdErrorFilePath == null) {
                    throw new IllegalArgumentException("stdErrorFilePath not specified");
                }
                if (userId == null) {
                    throw new IllegalArgumentException("userId not specified!");
                }
                String[] cmd = new String[]{"sudo", "-S", "-n", "-u", userId, "/bin/cat", stdErrorFilePath};
                proc = null;
                readIn = null;
                proc = Runtime.getRuntime().exec(cmd);
                readIn = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String strLine = null;
                while ((strLine = readIn.readLine()) != null) {
                    message = message + strLine + " ";
                }
                Object var9_9 = null;
                if (proc == null) break block47;
                proc.waitFor();
                StringBuffer errorMessage = null;
                if (proc.exitValue() != 0) {
                    block48: {
                        BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                        errorMessage = new StringBuffer();
                        String inputLine = null;
                        try {
                            while ((inputLine = readErr.readLine()) != null) {
                                errorMessage.append(inputLine);
                            }
                            Object var15_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_23 = null;
                            readErr.close();
                            throw throwable;
                        }
                        readErr.close();
                        {
                            break block48;
                            catch (IOException ioe) {
                                logger.error((Object)ioe.getMessage());
                                Object var15_22 = null;
                                readErr.close();
                            }
                        }
                    }
                    if (errorMessage.length() > 0) {
                        errorMessage.append("\n");
                    }
                }
                try {
                    proc.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    proc.getErrorStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (errorMessage != null) {
                    throw new IOException(errorMessage.toString());
                }
            }
            try {
                readIn.close();
            }
            catch (IOException ioe) {}
            break block57;
            {
                catch (Throwable e) {
                    if (proc != null) {
                        proc.destroy();
                    }
                    Object var9_10 = null;
                    if (proc != null) {
                        proc.waitFor();
                        StringBuffer errorMessage = null;
                        if (proc.exitValue() != 0) {
                            block52: {
                                BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                                errorMessage = new StringBuffer();
                                String inputLine = null;
                                try {
                                    while ((inputLine = readErr.readLine()) != null) {
                                        errorMessage.append(inputLine);
                                    }
                                    Object var15_24 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var15_26 = null;
                                    readErr.close();
                                    throw throwable;
                                }
                                readErr.close();
                                {
                                    break block52;
                                    catch (IOException ioe) {
                                        logger.error((Object)ioe.getMessage());
                                        Object var15_25 = null;
                                        readErr.close();
                                    }
                                }
                            }
                            if (errorMessage.length() > 0) {
                                errorMessage.append("\n");
                            }
                        }
                        try {
                            proc.getInputStream().close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        try {
                            proc.getErrorStream().close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        try {
                            proc.getOutputStream().close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (errorMessage != null) {
                            throw new IOException(errorMessage.toString());
                        }
                    }
                    try {
                        readIn.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (proc != null) {
                    proc.waitFor();
                    StringBuffer errorMessage = null;
                    if (proc.exitValue() != 0) {
                        block56: {
                            BufferedReader readErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            errorMessage = new StringBuffer();
                            String inputLine = null;
                            try {
                                while ((inputLine = readErr.readLine()) != null) {
                                    errorMessage.append(inputLine);
                                }
                                Object var15_27 = null;
                            }
                            catch (Throwable throwable2) {
                                Object var15_29 = null;
                                readErr.close();
                                throw throwable2;
                            }
                            readErr.close();
                            {
                                break block56;
                                catch (IOException ioe) {
                                    logger.error((Object)ioe.getMessage());
                                    Object var15_28 = null;
                                    readErr.close();
                                }
                            }
                        }
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                    }
                    try {
                        proc.getInputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getErrorStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        proc.getOutputStream().close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (errorMessage != null) {
                        throw new IOException(errorMessage.toString());
                    }
                }
                try {
                    readIn.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (message.length() == 0) {
            throw new FileNotFoundException("file \"" + stdErrorFilePath + " not found!");
        }
        return message.trim();
    }

    public JobDBInterface getJobDB() {
        return this.jobDB;
    }

    public void setJobDB(JobDBInterface jobDB) throws IllegalArgumentException {
        String disableSubmissionPolicy;
        if (jobDB == null) {
            throw new IllegalArgumentException("jobDB not specified!");
        }
        this.jobDB = jobDB;
        EventManagerFactory.addEventManager("JOB_STATUS_EVENT_MANAGER", new JobStatusEventManager(jobDB, 500));
        try {
            Job job = null;
            List<String> jobPendingList = jobDB.retrieveJobId(new int[]{1}, null, null, null);
            for (String jobId : jobPendingList) {
                job = jobDB.retrieveJob(jobId, null);
                if (job == null || job.getLRMSAbsLayerJobId() != null && !"N/A".equals(job.getLRMSAbsLayerJobId()) || !this.isEmptyField(job.getLRMSAbsLayerJobId())) continue;
                if (job.getCommandHistoryCount() > 1) {
                    JobCommand cmd = job.getCommandHistoryAt(1);
                    cmd.setStatus(8);
                    cmd.setFailureReason("command aborted because its execution has been interrupted by the CREAM shutdown");
                    if ("ADMINISTRATOR".equals(cmd.getUserId())) {
                        cmd.setUserId(job.getUserId());
                    }
                    jobDB.updateJobCommand(cmd);
                    logger.info((Object)cmd.toString());
                }
                JobStatus status = job.getLastStatus();
                status.setType(10);
                status.setFailureReason("job aborted because the execution of the JOB_START command has been interrupted by the CREAM shutdown");
                status.setTimestamp(job.getLastCommand().getExecutionCompletedTime());
                jobDB.updateStatus(status, null);
                logger.info((Object)("job " + job.getId() + " aborted because the execution of the JOB_START command has been interrupted by the CREAM shutdown"));
                try {
                    this.sendNotification(job);
                }
                catch (JobManagementException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            jobDB.updateAllUnterminatedJobCommand();
        }
        catch (DatabaseException e) {
            logger.error((Object)e.getMessage());
        }
        int maxLeaseTime = 10800;
        int leaseExecutionRate = 30;
        if (this.containsParameterKey("MAX_LEASE_TIME")) {
            try {
                maxLeaseTime = Integer.parseInt(this.getParameterValueAsString("MAX_LEASE_TIME"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("MAX_LEASE_TIME parameter has a wrong value: " + this.getParameterValueAsString("MAX_LEASE_TIME") + " => using the default one: " + maxLeaseTime));
            }
        }
        if (this.containsParameterKey("LEASE_EXECUTION_RATE")) {
            try {
                leaseExecutionRate = Integer.parseInt(this.getParameterValueAsString("LEASE_EXECUTION_RATE"));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("LEASE_EXECUTION_RATE parameter has a wrong value: " + this.getParameterValueAsString("LEASE_EXECUTION_RATE") + " => using the default one: " + leaseExecutionRate));
            }
        }
        this.leaseManager = new LeaseManager(this, maxLeaseTime);
        timer.schedule((TimerTask)this.leaseManager, 0L, (long)(leaseExecutionRate * 60000));
        logger.info((Object)("LeaseManager started [maxLeaseTime=" + maxLeaseTime + "; leaseExecutionRate=" + leaseExecutionRate + "]"));
        if (this.containsParameterKey("JOB_PURGE_POLICY")) {
            int jobPurgeRate = JOB_PURGE_RATE_DEFAULT;
            if (this.containsParameterKey("JOB_PURGE_RATE")) {
                try {
                    jobPurgeRate = Integer.parseInt(this.getParameterValueAsString("JOB_PURGE_RATE"));
                }
                catch (NumberFormatException nfe) {
                    jobPurgeRate = JOB_PURGE_RATE_DEFAULT;
                }
            }
            this.jobPurger = new JobPurger(this, this.getParameterValueAsString("JOB_PURGE_POLICY"), jobPurgeRate);
        }
        if ((disableSubmissionPolicy = this.getParameterValueAsString(JOB_SUBMISSION_MANAGER_ENABLE)) != null && "TRUE".equals(disableSubmissionPolicy.toUpperCase())) {
            JobSubmissionManager.setGliteCreamLoadMonitorScriptPath(this.getParameterValueAsString(JOB_SUBMISSION_MANAGER_SCRIPT_PATH));
            this.jobSubmissionManager = JobSubmissionManager.getInstance();
            timer.schedule((TimerTask)this.jobSubmissionManager, 300000L, 600000L);
        }
    }

    private void setLeaseExpired(Job job) {
        if (job == null || job.getLease() == null) {
            return;
        }
        try {
            this.jobDB.setLeaseExpired(job.getId(), job.getLease());
        }
        catch (Throwable e) {
            logger.error((Object)("setLeaseExpired: " + e.getMessage()));
        }
    }

    private void initSocket(String sensorHost, String sensorPort) throws JobManagementException {
        if (this.socket == null) {
            if (sensorHost == null) {
                throw new JobManagementException("CREAM_JOB_SENSOR_HOST parameter not specified!");
            }
            if (sensorPort == null) {
                throw new JobManagementException("CREAM_JOB_SENSOR_PORT parameter not specified!");
            }
            logger.debug((Object)("initSocket: CREAM_JOB_SENSOR_HOST = " + sensorHost + " CREAM_JOB_SENSOR_PORT = " + sensorPort));
            try {
                int sensorPortNumber = Integer.parseInt(sensorPort);
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(sensorHost, sensorPortNumber), 500);
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
            catch (Exception e) {
                throw new JobManagementException(e.getMessage());
            }
            logger.info((Object)("initSocket: created socket for host=" + sensorHost + ":" + sensorPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNotification(Job job) throws JobManagementException {
        String sensorHost = this.getParameterValueAsString(CREAM_JOB_SENSOR_HOST);
        String sensorPort = this.getParameterValueAsString(CREAM_JOB_SENSOR_PORT);
        if (job == null || sensorHost == null || sensorPort == null) {
            return;
        }
        if (this.socket == null) {
            this.initSocket(sensorHost, sensorPort);
        }
        if (this.socket.isConnected()) {
            Socket socket = this.socket;
            synchronized (socket) {
                try {
                    try {
                        logger.debug((Object)("sendNotification: Retrieved job for jobId=" + job.getId()));
                        job.writeExternal(this.oos);
                        logger.debug((Object)"sendNotification: writeExternal perfomed");
                        this.oos.flush();
                    }
                    catch (Throwable e) {
                        logger.error((Object)("sendNotification error: " + e.getMessage()));
                        if (this.socket != null && !this.socket.isClosed()) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException e1) {
                                throw new JobManagementException(e1.getMessage());
                            }
                        }
                        this.socket = null;
                        if (this.oos != null) {
                            try {
                                this.oos.close();
                            }
                            catch (IOException e1) {
                                throw new JobManagementException(e1.getMessage());
                            }
                        }
                        Object var8_8 = null;
                        if (this.socket != null) {
                            this.socket.notifyAll();
                        }
                    }
                    Object var8_7 = null;
                    if (this.socket != null) {
                        this.socket.notifyAll();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (this.socket != null) {
                        this.socket.notifyAll();
                    }
                    throw throwable;
                }
            }
        }
        logger.warn((Object)"sendNotification: the socket is NOT connected");
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new JobManagementException(e.getMessage());
            }
        }
        this.socket = null;
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                throw new JobManagementException("socket is not connected");
            }
        }
    }

    private class GetSTDTask
    extends TimerTask {
        private String jobId = null;

        public GetSTDTask(String jobId) {
            this.jobId = jobId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Job job = null;
            try {
                job = AbstractJobExecutor.this.jobDB.retrieveJob(this.jobId, null);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("GetSTDTask - IllegalArgumentException: " + e.getMessage()));
                return;
            }
            catch (DatabaseException e) {
                logger.error((Object)("GetSTDTask - DatabaseException: " + e.getMessage()));
                return;
            }
            if (job == null) {
                return;
            }
            JobStatus lastStatus = job.getLastStatus();
            if (lastStatus == null) {
                return;
            }
            boolean update = false;
            if ("W".equalsIgnoreCase(lastStatus.getExitCode())) {
                try {
                    try {
                        String exitCode = AbstractJobExecutor.this.getExitCode(job.getWorkingDirectory() + "/StandardOutput", job.getLocalUser());
                        lastStatus.setExitCode(exitCode);
                    }
                    catch (Exception e) {
                        lastStatus.setExitCode("N/A");
                        Object var6_10 = null;
                        update = true;
                    }
                    Object var6_9 = null;
                    update = true;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    update = true;
                    throw throwable;
                }
            }
            if (lastStatus.getType() == 8 || lastStatus.getType() == 5) {
                try {
                    try {
                        String stdErrorMessage = AbstractJobExecutor.this.readFile(job.getWorkingDirectory() + "/StandardError", job.getLocalUser());
                        String errorMessage = null;
                        errorMessage = stdErrorMessage != null && !stdErrorMessage.equals("") ? ((errorMessage = lastStatus.getFailureReason()) != null && !stdErrorMessage.equals(stdErrorMessage) ? errorMessage + "; " + stdErrorMessage : stdErrorMessage) : "N/A";
                        lastStatus.setFailureReason(errorMessage);
                    }
                    catch (Exception e) {
                        if (lastStatus.getFailureReason() == null || lastStatus.getFailureReason().length() == 0) {
                            lastStatus.setFailureReason("N/A");
                        }
                        Object var8_16 = null;
                        update = true;
                    }
                    Object var8_15 = null;
                    update = true;
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    update = true;
                    throw throwable;
                }
            }
            if (update) {
                Command statusCmd = new Command("SET_JOB_STATUS", AbstractJobExecutor.this.getCategory());
                statusCmd.setAsynchronous(true);
                statusCmd.setUserId("admin");
                statusCmd.addParameter("JOB_ID", (Serializable)((Object)lastStatus.getJobId()));
                statusCmd.addParameter("STATUS_TYPE", (Serializable)((Object)("" + lastStatus.getType())));
                statusCmd.addParameter("IS_ADMIN", (Serializable)((Object)"true"));
                statusCmd.addParameter("EXIT_CODE", (Serializable)((Object)lastStatus.getExitCode()));
                statusCmd.addParameter("FAILURE_REASON", (Serializable)((Object)lastStatus.getFailureReason()));
                statusCmd.setPriorityLevel(2);
                statusCmd.setExecutionMode(Command.ExecutionModeValues.SERIAL);
                statusCmd.setCommandGroupId(lastStatus.getJobId());
                if (lastStatus.getTimestamp() != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    statusCmd.addParameter("STATUS_CHANGE_TIME", (Serializable)((Object)dateFormat.format(lastStatus.getTimestamp().getTime())));
                }
                try {
                    AbstractJobExecutor.this.getCommandManager().execute(statusCmd);
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }
}

