/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobArrayList;
import org.glite.ce.creamapi.jobmanagement.JobManagementException;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEnumeration
implements Enumeration {
    private static Logger logger = Logger.getLogger((String)JobEnumeration.class.getName());
    private List<String> jobIdList = null;
    private JobDBInterface db = null;

    public JobEnumeration(JobDBInterface db) {
        this.jobIdList = new ArrayList<String>(0);
        this.db = db;
    }

    public JobEnumeration(List<String> jobIdList, JobDBInterface db) {
        this.jobIdList = jobIdList == null ? new ArrayList(0) : jobIdList;
        this.db = db;
    }

    public List<String> getJobIdList() {
        return this.jobIdList;
    }

    protected void addAll(JobEnumeration jobEnum) {
        if (jobEnum != null) {
            this.jobIdList.addAll(jobEnum.getJobIdList());
        }
    }

    public int size() {
        return this.jobIdList.size();
    }

    @Override
    public boolean hasMoreElements() {
        return !this.jobIdList.isEmpty();
    }

    public boolean hasMoreJobs() {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        if (this.jobIdList.size() == 0) {
            return null;
        }
        return this.jobIdList.remove(0);
    }

    public String nextJobId() {
        return (String)this.nextElement();
    }

    public Job nextJob() throws JobManagementException {
        Job job = null;
        String jobId = (String)this.nextElement();
        if (jobId == null || this.db == null) {
            return null;
        }
        try {
            job = this.db.retrieveJob(jobId, null);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("IllegalArgumentException: " + e.getMessage()));
            throw new JobManagementException(e.getMessage());
        }
        catch (DatabaseException e) {
            logger.error((Object)("DatabaseException: " + e.getMessage()));
            throw new JobManagementException(e.getMessage());
        }
        return job;
    }

    public JobArrayList getJobArrayList() {
        return new JobArrayList(this.jobIdList, this.db);
    }
}

