/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.creamapi.jobmanagement.Job;
import org.glite.ce.creamapi.jobmanagement.JobManagementException;
import org.glite.ce.creamapi.jobmanagement.db.JobDBInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobArrayList {
    private static Logger logger = Logger.getLogger((String)JobArrayList.class.getName());
    private List<String> jobIdList = null;
    private JobDBInterface db = null;

    public JobArrayList() {
        this.jobIdList = new ArrayList<String>(0);
    }

    public JobArrayList(JobDBInterface db) {
        this.jobIdList = new ArrayList<String>(0);
        this.db = db;
    }

    public JobArrayList(List<String> jobIdList, JobDBInterface db) {
        this.jobIdList = jobIdList == null ? new ArrayList(0) : jobIdList;
        this.db = db;
    }

    public List<String> getJobIdList() {
        return this.jobIdList;
    }

    public JobDBInterface getJobDB() {
        return this.db;
    }

    public void setJobDB(JobDBInterface jobdb) {
        this.db = jobdb;
    }

    public Job getJob(int index) throws JobManagementException {
        Job job = null;
        if (index < 0 || index > this.jobIdList.size() - 1) {
            return null;
        }
        try {
            job = this.db.retrieveJob(this.jobIdList.get(index), null);
        }
        catch (DatabaseException e) {
            logger.error((Object)("DatabaseException: " + e.getMessage()));
            throw new JobManagementException(e.getMessage());
        }
        return job;
    }

    public String getJobId(int index) {
        if (index < 0 || index > this.jobIdList.size() - 1) {
            return null;
        }
        return this.jobIdList.get(index);
    }

    public int size() {
        if (this.jobIdList == null) {
            return 0;
        }
        return this.jobIdList.size();
    }

    public boolean isEmpty() {
        return this.jobIdList.isEmpty();
    }

    public void clear() {
        this.jobIdList.clear();
    }
}

