/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.jobmanagement;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import org.glite.ce.creamapi.jobmanagement.JobStatus;
import org.glite.ce.creamapi.jobmanagement.Lease;
import org.glite.ce.creamapi.jobmanagement.command.JobCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Job
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final String JOBTYPE_INTERACTIVE = "interactive";
    private static final String JOBTYPE_MPICH = "mpich";
    private static final String JOBTYPE_NORMAL = "normal";
    private static final Random jobIdGenerator = new Random();
    public static final String version = "1.1";
    public static final String NOT_AVAILABLE_VALUE = "N/A";
    public static final String MAX_OUTPUT_SANDBOX_SIZE = "MAX_OUTPUT_SANDBOX_SIZE";
    public static final String DELEGATION_PROXY_CERT_SANDBOX_PATH = "DELEGATION_PROXY_CERT_SANDBOX_PATH";
    public static final String WMS_HOSTNAME = "WMS_HOSTNAME";
    public static final String OUTPUT_DATA = "OUTPUT_DATA";
    public static final String DS_UPLOAD_OUTPUT_FILE = "DS_UPLOAD_OUTPUT_FILE";
    private String creamURL = null;
    private String id = null;
    private String cerequirements = null;
    private String virtualOrganization = null;
    private String userId = null;
    private String batchSystem = null;
    private String queue = null;
    private String standardInput;
    private String standardOutput;
    private String standardError = null;
    private String executable = null;
    private String delegationProxyCertPath;
    private String authNProxyCertPath = null;
    private String hlrLocation = null;
    private String loggerDestURI = null;
    private String tokenURL = null;
    private String perusalFilesDestURI;
    private String perusalListFileURI = null;
    private String prologue;
    private String prologueArguments = null;
    private String epilogue;
    private String epilogueArguments = null;
    private String sequenceCode = null;
    private String lrmsJobId;
    private String lrmsAbsLayerJobId;
    private String gridJobId;
    private String iceId;
    private String fatherJobId;
    private String ceId = null;
    private String type;
    private String creamInputSandboxURI;
    private String creamOutputSandboxURI;
    private String sandboxBasePath;
    private String inputSandboxBaseURI;
    private String outputSandboxBaseDestURI = null;
    private String workerNode = null;
    private String jdl = null;
    private String myProxyServer = null;
    private String localUser;
    private String delegationProxyId;
    private String delegationProxyInfo;
    private String workingDirectory = null;
    private List<String> childJobId = null;
    private List<String> arguments = null;
    private List<String> outputSandboxDestURI;
    private List<String> inputFiles;
    private List<String> outputFiles = null;
    private int perusalTimeInterval;
    private int nodes = 0;
    private Hashtable<String, String> extraAttribute = null;
    private Hashtable<String, String> environment = null;
    private Hashtable<String, Object> volatileProperty = null;
    private List<JobStatus> statusHistory = null;
    private List<JobCommand> commandHistory = null;
    private Lease lease = null;

    public Job() {
        this.setId(this.generateJobId());
    }

    public Job(String id) {
        if (id == null) {
            this.setId(this.generateJobId());
        } else {
            this.setId(id);
        }
    }

    public void addArgument(String arg) {
        if (arg != null) {
            this.getArguments().add(arg);
        }
    }

    public void addCommandHistory(JobCommand cmd) {
        if (cmd != null) {
            cmd.setJobId(this.id);
            this.getCommandHistory().add(cmd);
        }
    }

    public void addEnvironmentAttribute(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key not specified!");
        }
        if (value == null) {
            throw new IllegalArgumentException("value not specified!");
        }
        this.getEnvironment().put(key, value);
    }

    public void addExtraAttribute(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key not specified!");
        }
        if (value == null) {
            throw new IllegalArgumentException("value not specified!");
        }
        this.getExtraAttribute().put(key, value);
    }

    public void addStatus(JobStatus status) {
        if (status != null) {
            status.setJobId(this.id);
            this.getStatusHistory().add(status);
        }
    }

    public void addVolatileProperty(String key, Object value) throws IllegalArgumentException {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Neither the key nor the value can be null. (key=" + key + " value=" + value + ")");
        }
        this.getVolatileProperty().put(key, value);
    }

    public boolean containsExtraAttribute(String key) {
        if (key != null) {
            return this.getExtraAttribute().containsKey(key);
        }
        return false;
    }

    public boolean containsVolatilePropertyKeys(String key) {
        if (key != null) {
            return this.getVolatileProperty().containsKey(key);
        }
        return false;
    }

    public synchronized String generateJobId() {
        String suffix = "000000000" + jobIdGenerator.nextInt(1000000000);
        suffix = suffix.substring(suffix.length() - 9);
        return "CREAM" + suffix;
    }

    public List<String> getArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>(0);
        }
        return this.arguments;
    }

    public String getAuthNProxyCertPath() {
        return this.authNProxyCertPath;
    }

    public String getBatchSystem() {
        return this.batchSystem;
    }

    public String getCeId() {
        return this.ceId;
    }

    public String getCeRequirements() {
        return this.cerequirements;
    }

    public List<String> getChildJobId() {
        return this.childJobId;
    }

    public List<JobCommand> getCommandHistory() {
        if (this.commandHistory == null) {
            this.commandHistory = new ArrayList<JobCommand>(0);
        }
        return this.commandHistory;
    }

    public JobCommand getCommandHistoryAt(int index) throws IndexOutOfBoundsException {
        return this.getCommandHistory().get(index);
    }

    public int getCommandHistoryCount() {
        return this.getCommandHistory().size();
    }

    public String getCREAMInputSandboxURI() {
        return this.creamInputSandboxURI;
    }

    public String getCREAMOutputSandboxURI() {
        return this.creamOutputSandboxURI;
    }

    public String getCREAMSandboxBasePath() {
        return this.sandboxBasePath;
    }

    public String getCreamURL() {
        return this.creamURL;
    }

    public String getDelegationProxyCertPath() {
        return this.delegationProxyCertPath;
    }

    public String getDelegationProxyId() {
        return this.delegationProxyId;
    }

    public String getDelegationProxyInfo() {
        return this.delegationProxyInfo;
    }

    public Hashtable<String, String> getEnvironment() {
        if (this.environment == null) {
            this.environment = new Hashtable(0);
        }
        return this.environment;
    }

    public String getEnvironmentAttribute(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key not specified!");
        }
        return this.getEnvironment().get(key);
    }

    public String getEpilogue() {
        return this.epilogue;
    }

    public String getEpilogueArguments() {
        return this.epilogueArguments;
    }

    public String getExecutable() {
        return this.executable;
    }

    public Hashtable<String, String> getExtraAttribute() {
        if (this.extraAttribute == null) {
            this.extraAttribute = new Hashtable(0);
        }
        return this.extraAttribute;
    }

    public String getExtraAttribute(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key not specified!");
        }
        return this.extraAttribute.get(key);
    }

    public String getFatherJobId() {
        return this.fatherJobId;
    }

    public String getGridJobId() {
        return this.gridJobId;
    }

    public String getHlrLocation() {
        return this.hlrLocation;
    }

    public String getICEId() {
        return this.iceId;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getInputFiles() {
        if (this.inputFiles == null) {
            this.inputFiles = new ArrayList<String>(0);
        }
        return this.inputFiles;
    }

    public String getInputSandboxBaseURI() {
        return this.inputSandboxBaseURI;
    }

    public String getJDL() {
        return this.jdl;
    }

    public JobCommand getLastCommand() {
        List<JobCommand> cmdHistory = this.getCommandHistory();
        if (cmdHistory.size() > 0) {
            return cmdHistory.get(cmdHistory.size() - 1);
        }
        return null;
    }

    public JobStatus getLastStatus() {
        List<JobStatus> stHistory = this.getStatusHistory();
        if (stHistory.size() > 0) {
            return stHistory.get(stHistory.size() - 1);
        }
        return null;
    }

    public Lease getLease() {
        return this.lease;
    }

    public String getLocalUser() {
        return this.localUser;
    }

    public String getLoggerDestURI() {
        return this.loggerDestURI;
    }

    public String getLRMSAbsLayerJobId() {
        return this.lrmsAbsLayerJobId;
    }

    public String getLRMSJobId() {
        return this.lrmsJobId;
    }

    public String getMyProxyServer() {
        return this.myProxyServer;
    }

    public int getNodeNumber() {
        return this.nodes;
    }

    public List<String> getOutputFiles() {
        if (this.outputFiles == null) {
            this.outputFiles = new ArrayList<String>(0);
        }
        return this.outputFiles;
    }

    public String getOutputSandboxBaseDestURI() {
        return this.outputSandboxBaseDestURI;
    }

    public List<String> getOutputSandboxDestURI() {
        if (this.outputSandboxDestURI == null) {
            this.outputSandboxDestURI = new ArrayList<String>(0);
        }
        return this.outputSandboxDestURI;
    }

    public String getPerusalFilesDestURI() {
        return this.perusalFilesDestURI;
    }

    public String getPerusalListFileURI() {
        return this.perusalListFileURI;
    }

    public int getPerusalTimeInterval() {
        return this.perusalTimeInterval;
    }

    public String getPrologue() {
        return this.prologue;
    }

    public String getPrologueArguments() {
        return this.prologueArguments;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getSandboxBasePath() {
        return this.sandboxBasePath;
    }

    public String getSequenceCode() {
        return this.sequenceCode;
    }

    public String getStandardError() {
        return this.standardError;
    }

    public String getStandardInput() {
        return this.standardInput;
    }

    public String getStandardOutput() {
        return this.standardOutput;
    }

    public JobStatus getStatusAt(int index) throws IndexOutOfBoundsException {
        return this.getStatusHistory().get(index);
    }

    public int getStatusCount() {
        return this.getStatusHistory().size();
    }

    public List<JobStatus> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<JobStatus>(0);
        }
        return this.statusHistory;
    }

    public String getTokenURL() {
        return this.tokenURL;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVirtualOrganization() {
        return this.virtualOrganization;
    }

    public Hashtable<String, Object> getVolatileProperty() {
        if (this.volatileProperty == null) {
            this.volatileProperty = new Hashtable(0);
        }
        return this.volatileProperty;
    }

    public Object getVolatileProperty(String key) {
        if (key != null) {
            return this.getVolatileProperty().get(key);
        }
        return null;
    }

    public Enumeration<String> getVolatilePropertyKeys() {
        return this.getVolatileProperty().keys();
    }

    public String getWorkerNode() {
        return this.workerNode;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isInteractive() {
        return JOBTYPE_INTERACTIVE.equalsIgnoreCase(this.getType());
    }

    public boolean isMpich() {
        return JOBTYPE_MPICH.equalsIgnoreCase(this.getType());
    }

    public boolean isNormal() {
        return JOBTYPE_NORMAL.equalsIgnoreCase(this.getType());
    }

    private Calendar readCalendar(ObjectInput in) throws IOException {
        long ts = in.readLong();
        if (ts == 0L) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts);
        return result;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int k;
        String version = this.readString(in);
        if (!version.equalsIgnoreCase(version)) {
            throw new IOException("job serialization version mismatch: found \"" + version + "\" required \"" + version + "\"");
        }
        this.creamURL = this.readString(in);
        this.id = this.readString(in);
        this.lrmsJobId = this.readString(in);
        this.lrmsAbsLayerJobId = this.readString(in);
        this.gridJobId = this.readString(in);
        this.iceId = this.readString(in);
        this.fatherJobId = this.readString(in);
        this.ceId = this.readString(in);
        this.userId = this.readString(in);
        this.jdl = this.readString(in);
        this.myProxyServer = this.readString(in);
        this.workerNode = this.readString(in);
        this.cerequirements = this.readString(in);
        this.virtualOrganization = this.readString(in);
        this.batchSystem = this.readString(in);
        this.queue = this.readString(in);
        this.standardInput = this.readString(in);
        this.standardOutput = this.readString(in);
        this.standardError = this.readString(in);
        this.executable = this.readString(in);
        this.delegationProxyCertPath = this.readString(in);
        this.authNProxyCertPath = this.readString(in);
        this.hlrLocation = this.readString(in);
        this.loggerDestURI = this.readString(in);
        this.tokenURL = this.readString(in);
        this.perusalFilesDestURI = this.readString(in);
        this.perusalListFileURI = this.readString(in);
        this.prologue = this.readString(in);
        this.prologueArguments = this.readString(in);
        this.epilogue = this.readString(in);
        this.epilogueArguments = this.readString(in);
        this.sequenceCode = this.readString(in);
        this.type = this.readString(in);
        this.creamInputSandboxURI = this.readString(in);
        this.creamOutputSandboxURI = this.readString(in);
        this.sandboxBasePath = this.readString(in);
        this.inputSandboxBaseURI = this.readString(in);
        this.outputSandboxBaseDestURI = this.readString(in);
        this.localUser = this.readString(in);
        this.delegationProxyId = this.readString(in);
        this.delegationProxyInfo = this.readString(in);
        this.workingDirectory = this.readString(in);
        this.arguments = this.readStringArray(in);
        this.childJobId = this.readStringArray(in);
        this.outputSandboxDestURI = this.readStringArray(in);
        this.inputFiles = this.readStringArray(in);
        this.outputFiles = this.readStringArray(in);
        this.nodes = in.readInt();
        this.perusalTimeInterval = in.readInt();
        int htSize = in.readInt();
        if (htSize == 1) {
            this.lease = new Lease();
            this.lease.setLeaseId(this.readString(in));
            this.lease.setUserId(this.readString(in));
            this.lease.setLeaseTime(this.readCalendar(in));
        }
        if ((htSize = in.readInt()) >= 0) {
            Hashtable<String, String> environment = this.getEnvironment();
            environment.clear();
            for (k = 0; k < htSize; ++k) {
                environment.put(in.readUTF(), in.readUTF());
            }
        }
        if ((htSize = in.readInt()) >= 0) {
            Hashtable<String, String> extraAttribute = this.getExtraAttribute();
            extraAttribute.clear();
            for (k = 0; k < htSize; ++k) {
                extraAttribute.put(in.readUTF(), in.readUTF());
            }
        }
        if ((htSize = in.readInt()) >= 0) {
            List<JobStatus> stHistory = this.getStatusHistory();
            stHistory.clear();
            for (i = 0; i < htSize; ++i) {
                stHistory.add(this.readJobStatus(in));
            }
        }
        if ((htSize = in.readInt()) >= 0) {
            List<JobCommand> cmdHistory = this.getCommandHistory();
            cmdHistory.clear();
            for (i = 0; i < htSize; ++i) {
                cmdHistory.add(this.readJobCommand(in));
            }
        }
    }

    private JobCommand readJobCommand(ObjectInput in) throws IOException {
        if (in == null) {
            throw new IOException("readJobCommand error: ObjectInput is null");
        }
        JobCommand cmd = new JobCommand();
        cmd.setCommandExecutorName(this.readString(in));
        cmd.setDescription(this.readString(in));
        cmd.setFailureReason(this.readString(in));
        cmd.setJobId(this.readString(in));
        cmd.setUserId(this.readString(in));
        cmd.setCreationTime(this.readCalendar(in));
        cmd.setExecutionCompletedTime(this.readCalendar(in));
        cmd.setStartProcessingTime(this.readCalendar(in));
        cmd.setStartSchedulingTime(this.readCalendar(in));
        cmd.setStatus(in.readInt());
        cmd.setType(in.readInt());
        return cmd;
    }

    private JobStatus readJobStatus(ObjectInput in) throws IOException {
        if (in == null) {
            throw new IOException("readJobStatus error: ObjectInput is null");
        }
        JobStatus status = new JobStatus(in.readInt());
        status.setDescription(this.readString(in));
        status.setExitCode(this.readString(in));
        status.setFailureReason(this.readString(in));
        status.setJobId(this.readString(in));
        status.setTimestamp(this.readCalendar(in));
        return status;
    }

    private String readString(ObjectInput in) throws IOException {
        if (in == null) {
            throw new IOException("ObjectIntput is null");
        }
        String s = in.readUTF();
        if (s == null || s.equals("")) {
            return null;
        }
        return s;
    }

    private List<String> readStringArray(ObjectInput in) throws IOException {
        int size = in.readInt();
        if (size >= 0) {
            ArrayList<String> result = new ArrayList<String>(size);
            for (int k = 0; k < size; ++k) {
                result.add(in.readUTF());
            }
            return result;
        }
        return null;
    }

    public void setArguments(List<String> argumentList) {
        List<String> arguments = this.getArguments();
        arguments.clear();
        if (argumentList != null) {
            arguments.addAll(argumentList);
        }
    }

    public void setAuthNProxyCertPath(String authNProxyCertPath) {
        this.authNProxyCertPath = authNProxyCertPath;
    }

    public void setBatchSystem(String batchSystem) {
        this.batchSystem = batchSystem;
    }

    public void setCeId(String ceId) {
        this.ceId = ceId;
    }

    public void setCeRequirements(String cerequirements) {
        this.cerequirements = cerequirements;
    }

    public void setChildJobId(List<String> childJobId) {
        this.childJobId = childJobId;
    }

    public void setCommandHistory(List<JobCommand> cmdList) {
        List<JobCommand> cmdHistory = this.getCommandHistory();
        cmdHistory.clear();
        if (cmdList != null) {
            cmdHistory.addAll(cmdList);
        }
    }

    public void setCREAMInputSandboxURI(String inputSandboxURI) {
        this.creamInputSandboxURI = inputSandboxURI;
    }

    public void setCREAMOutputSandboxURI(String outputSandboxURI) {
        this.creamOutputSandboxURI = outputSandboxURI;
    }

    public void setCREAMSandboxBasePath(String sandboxBasePath) {
        this.sandboxBasePath = sandboxBasePath;
    }

    public void setCreamURL(String creamURL) {
        this.creamURL = creamURL;
    }

    public void setDelegationProxyCertPath(String dlgProxyCertPath) {
        this.delegationProxyCertPath = dlgProxyCertPath;
    }

    public void setDelegationProxyId(String proxyDelegationId) {
        this.delegationProxyId = proxyDelegationId;
    }

    public void setDelegationProxyInfo(String proxyInfo) {
        this.delegationProxyInfo = proxyInfo;
    }

    public void setEnvironment(Hashtable<String, String> env) {
        Hashtable<String, String> environment = this.getEnvironment();
        environment.clear();
        if (env != null) {
            environment.putAll(env);
        }
    }

    public void setEpilogue(String epilogue) {
        this.epilogue = epilogue;
    }

    public void setEpilogueArguments(String args) {
        this.epilogueArguments = args;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setExtraAttribute(Hashtable<String, String> extraAttr) {
        Hashtable<String, String> extraAttribute = this.getExtraAttribute();
        extraAttribute.clear();
        if (extraAttr != null) {
            extraAttribute.putAll(extraAttr);
        }
    }

    public void setFatherJobId(String fatherJobId) {
        this.fatherJobId = fatherJobId;
    }

    public void setGridJobId(String gridJobId) {
        this.gridJobId = gridJobId;
    }

    public void setHlrLocation(String hl) {
        this.hlrLocation = hl;
    }

    public void setICEId(String iceId) {
        this.iceId = iceId;
    }

    public void setId(String id) {
        this.id = id;
        for (JobStatus status : this.getStatusHistory()) {
            status.setJobId(id);
        }
        for (JobCommand cmd : this.getCommandHistory()) {
            cmd.setJobId(id);
        }
    }

    public void setInputFiles(List<String> inputFiles) {
        List<String> inFiles = this.getInputFiles();
        inFiles.clear();
        if (inputFiles != null) {
            inFiles.addAll(inputFiles);
        }
    }

    public void setInputSandboxBaseURI(String uri) {
        this.inputSandboxBaseURI = uri;
    }

    public void setJDL(String jdl) {
        this.jdl = jdl;
    }

    public void setLastCommand(JobCommand cmd) {
        if (cmd != null) {
            cmd.setJobId(this.id);
            List<JobCommand> cmdHistory = this.getCommandHistory();
            if (cmdHistory.size() == 0) {
                cmdHistory.add(cmd);
            } else {
                cmdHistory.set(cmdHistory.size() - 1, cmd);
            }
        }
    }

    public void setLastStatus(JobStatus status) {
        if (status != null) {
            status.setJobId(this.getId());
            List<JobStatus> stHistory = this.getStatusHistory();
            if (stHistory.size() == 0) {
                stHistory.add(status);
            } else {
                stHistory.set(stHistory.size() - 1, status);
            }
        }
    }

    public void setLease(Lease lease) {
        if (lease != null) {
            lease.setUserId(this.userId);
            if (lease.getLeaseId() == null) {
                lease.setLeaseId(this.id);
            }
        }
        this.lease = lease;
    }

    public void setLocalUser(String localUser) {
        this.localUser = localUser;
    }

    public void setLoggerDestURI(String s) {
        this.loggerDestURI = s;
    }

    public void setLRMSAbsLayerJobId(String lrmsAbsLayerJobId) {
        this.lrmsAbsLayerJobId = lrmsAbsLayerJobId;
    }

    public void setLRMSJobId(String lrmsJobId) {
        this.lrmsJobId = lrmsJobId;
    }

    public void setMyProxyServer(String myProxyServer) {
        this.myProxyServer = myProxyServer;
    }

    public void setNodeNumber(int n) {
        this.nodes = n;
    }

    public void setOutputFiles(List<String> outputFileList) {
        List<String> list = this.getOutputFiles();
        list.clear();
        if (outputFileList != null) {
            list.addAll(outputFileList);
        }
    }

    public void setOutputSandboxBaseDestURI(String uri) {
        this.outputSandboxBaseDestURI = uri;
    }

    public void setOutputSandboxDestURI(List<String> uriList) {
        List<String> list = this.getOutputSandboxDestURI();
        list.clear();
        if (uriList != null) {
            list.addAll(uriList);
        }
    }

    public void setPerusalFilesDestURI(String perusalFilesDestURI) {
        this.perusalFilesDestURI = perusalFilesDestURI;
    }

    public void setPerusalListFileURI(String perusalListFileURI) {
        this.perusalListFileURI = perusalListFileURI;
    }

    public void setPerusalTimeInterval(int perusalTimeInterval) {
        this.perusalTimeInterval = perusalTimeInterval;
    }

    public void setPrologue(String prologue) {
        this.prologue = prologue;
    }

    public void setPrologueArguments(String args) {
        this.prologueArguments = args;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setSandboxBasePath(String sandboxBasePath) {
        this.sandboxBasePath = sandboxBasePath;
    }

    public void setSequenceCode(String sequenceCode) {
        this.sequenceCode = sequenceCode;
    }

    public void setStandardError(String standardError) {
        this.standardError = standardError;
    }

    public void setStandardInput(String standardInput) {
        this.standardInput = standardInput;
    }

    public void setStandardOutput(String standardOutput) {
        this.standardOutput = standardOutput;
    }

    public void setStatusHistory(List<JobStatus> statusList) {
        List<JobStatus> stHistory = this.getStatusHistory();
        stHistory.clear();
        if (statusList != null) {
            stHistory.addAll(statusList);
        }
    }

    public void setTokenURL(String s) {
        this.tokenURL = s;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setVirtualOrganization(String vo) {
        this.virtualOrganization = vo;
    }

    public void setVolatileProperty(Hashtable<String, Object> volatileProperty) {
        Hashtable<String, Object> vlProperty = this.getVolatileProperty();
        vlProperty.clear();
        if (volatileProperty != null) {
            vlProperty.putAll(volatileProperty);
        }
    }

    public void setWorkerNode(String wn) {
        this.workerNode = wn;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private void writeCalendar(ObjectOutput out, Calendar cal) throws IOException {
        out.writeLong(cal != null ? cal.getTimeInMillis() : 0L);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out == null) {
            throw new IOException("ObjectOutput is null");
        }
        this.writeString(out, version);
        this.writeString(out, this.creamURL);
        this.writeString(out, this.id);
        this.writeString(out, this.lrmsJobId);
        this.writeString(out, this.lrmsAbsLayerJobId);
        this.writeString(out, this.gridJobId);
        this.writeString(out, this.iceId);
        this.writeString(out, this.fatherJobId);
        this.writeString(out, this.ceId);
        this.writeString(out, this.userId);
        this.writeString(out, this.jdl);
        this.writeString(out, this.myProxyServer);
        this.writeString(out, this.workerNode);
        this.writeString(out, this.cerequirements);
        this.writeString(out, this.virtualOrganization);
        this.writeString(out, this.batchSystem);
        this.writeString(out, this.queue);
        this.writeString(out, this.standardInput);
        this.writeString(out, this.standardOutput);
        this.writeString(out, this.standardError);
        this.writeString(out, this.executable);
        this.writeString(out, this.delegationProxyCertPath);
        this.writeString(out, this.authNProxyCertPath);
        this.writeString(out, this.hlrLocation);
        this.writeString(out, this.loggerDestURI);
        this.writeString(out, this.tokenURL);
        this.writeString(out, this.perusalFilesDestURI);
        this.writeString(out, this.perusalListFileURI);
        this.writeString(out, this.prologue);
        this.writeString(out, this.prologueArguments);
        this.writeString(out, this.epilogue);
        this.writeString(out, this.epilogueArguments);
        this.writeString(out, this.sequenceCode);
        this.writeString(out, this.type);
        this.writeString(out, this.creamInputSandboxURI);
        this.writeString(out, this.creamOutputSandboxURI);
        this.writeString(out, this.sandboxBasePath);
        this.writeString(out, this.inputSandboxBaseURI);
        this.writeString(out, this.outputSandboxBaseDestURI);
        this.writeString(out, this.localUser);
        this.writeString(out, this.delegationProxyId);
        this.writeString(out, this.delegationProxyInfo);
        this.writeString(out, this.workingDirectory);
        this.writeStringArray(out, this.arguments);
        this.writeStringArray(out, this.childJobId);
        this.writeStringArray(out, this.outputSandboxDestURI);
        this.writeStringArray(out, this.inputFiles);
        this.writeStringArray(out, this.outputFiles);
        out.writeInt(this.nodes);
        out.writeInt(this.perusalTimeInterval);
        if (this.lease != null) {
            out.writeInt(1);
            this.writeString(out, this.lease.getLeaseId());
            this.writeString(out, this.lease.getUserId());
            this.writeCalendar(out, this.lease.getLeaseTime());
        } else {
            out.writeInt(-1);
        }
        Hashtable<String, String> environment = this.getEnvironment();
        if (environment.size() > 0) {
            out.writeInt(environment.size());
            Enumeration<String> allKeys = environment.keys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                this.writeString(out, key);
                this.writeString(out, environment.get(key));
            }
        } else {
            out.writeInt(-1);
        }
        Hashtable<String, String> extraAttribute = this.getExtraAttribute();
        if (extraAttribute.size() > 0) {
            out.writeInt(extraAttribute.size());
            Enumeration<String> allKeys = extraAttribute.keys();
            while (allKeys.hasMoreElements()) {
                String key = allKeys.nextElement();
                this.writeString(out, key);
                this.writeString(out, extraAttribute.get(key));
            }
        } else {
            out.writeInt(-1);
        }
        List<JobStatus> stHistory = this.getStatusHistory();
        if (stHistory.size() > 0) {
            out.writeInt(stHistory.size());
            for (JobStatus status : stHistory) {
                this.writeJobStatus(out, status);
            }
        } else {
            out.writeInt(-1);
        }
        List<JobCommand> cmdHistory = this.getCommandHistory();
        if (cmdHistory.size() > 0) {
            out.writeInt(cmdHistory.size());
            for (JobCommand cmd : cmdHistory) {
                this.writeJobCommand(out, cmd);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void writeJobCommand(ObjectOutput out, JobCommand cmd) throws IllegalArgumentException, IOException {
        if (cmd == null) {
            throw new IllegalArgumentException("writeJobCommand error: jobCommand not specified!");
        }
        if (out == null) {
            throw new IOException("writeJobCommand error: ObjectInput is null");
        }
        this.writeString(out, cmd.getCommandExecutorName());
        this.writeString(out, cmd.getDescription());
        this.writeString(out, cmd.getFailureReason());
        this.writeString(out, cmd.getJobId());
        this.writeString(out, cmd.getUserId());
        this.writeCalendar(out, cmd.getCreationTime());
        this.writeCalendar(out, cmd.getExecutionCompletedTime());
        this.writeCalendar(out, cmd.getStartProcessingTime());
        this.writeCalendar(out, cmd.getStartSchedulingTime());
        out.writeInt(cmd.getStatus());
        out.writeInt(cmd.getType());
    }

    private void writeJobStatus(ObjectOutput out, JobStatus jobStatus) throws IllegalArgumentException, IOException {
        if (jobStatus == null) {
            throw new IllegalArgumentException("writeJobStatus error: jobStatus not specified!");
        }
        if (out == null) {
            throw new IOException("writeJobStatus error: ObjectInput is null");
        }
        out.writeInt(jobStatus.getType());
        this.writeString(out, jobStatus.getDescription());
        this.writeString(out, jobStatus.getExitCode());
        this.writeString(out, jobStatus.getFailureReason());
        this.writeString(out, jobStatus.getJobId());
        this.writeCalendar(out, jobStatus.getTimestamp());
    }

    private void writeString(ObjectOutput out, String s) throws IOException {
        out.writeUTF(s != null ? s : "");
    }

    private void writeStringArray(ObjectOutput out, List<String> array) throws IOException {
        if (array != null) {
            out.writeInt(array.size());
            for (int k = 0; k < array.size(); ++k) {
                out.writeUTF(array.get(k) != null ? array.get(k) : "");
            }
        } else {
            out.writeInt(-1);
        }
    }
}

