/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.eventmanagement;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.eventmanagement.EventManagerInterface;

public class EventManagerFactory {
    private static final Logger logger = Logger.getLogger((String)EventManagerFactory.class.getName());
    private static Hashtable<String, EventManagerInterface> eventManagers = new Hashtable(0);

    public static EventManagerInterface getEventManager(String type) throws IllegalArgumentException {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Parameter type must be not empty or null!");
        }
        return eventManagers.get(type);
    }

    public static void addEventManager(String type, EventManagerInterface eventManager) throws IllegalArgumentException {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Parameter type must be not empty or null!");
        }
        if (eventManager == null) {
            throw new IllegalArgumentException("Parameter eventManager must be not null");
        }
        if (eventManagers.containsKey(type)) {
            logger.error((Object)("EventManager for type= " + type + " already exists!"));
            throw new IllegalArgumentException("EventManager for type= " + type + " already exists!");
        }
        eventManagers.put(type, eventManager);
        logger.info((Object)("Added eventManager for type= " + type));
    }
}

