/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.delegationmanagement;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delegation
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private String id = "N/A";
    private String info = "N/A";
    private String certificate = null;
    private String vo = null;
    private String fqan = null;
    private String dn = null;
    private String localUser = null;
    private String localUserGroup = null;
    private String fileName = null;
    private String path = null;
    private List<String> vomsAttributes = null;
    private Date startTime = null;
    private Date expirationTime = null;
    private Date lastUpdateTime = null;
    boolean rfc = false;

    public Delegation(String id) {
        this.id = id;
    }

    public Delegation(String id, String certificate) {
        this.id = id;
        this.certificate = certificate;
    }

    public Object clone() {
        Delegation delegation = new Delegation(this.id);
        delegation.setCertificate(this.certificate);
        delegation.setInfo(this.info);
        delegation.setDN(this.dn);
        delegation.setFQAN(this.fqan);
        delegation.setVO(this.vo);
        delegation.setLocalUser(this.localUser);
        delegation.setLocalUserGroup(this.localUserGroup);
        delegation.setVOMSAttributes(this.vomsAttributes);
        delegation.setExpirationTime(this.expirationTime);
        delegation.setLastUpdateTime(this.lastUpdateTime);
        delegation.setStartTime(this.startTime);
        delegation.setPath(this.path);
        return delegation;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getDN() {
        return this.dn;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFQAN() {
        return this.fqan;
    }

    public String getFullPath() {
        if (this.path != null && this.fileName != null) {
            return this.path + this.fileName;
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getInfo() {
        return this.info;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLocalUser() {
        return this.localUser;
    }

    public String getLocalUserGroup() {
        return this.localUserGroup;
    }

    public String getPath() {
        return this.path;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getUserId() {
        if (this.fqan != null) {
            return this.normalize(this.dn + this.fqan);
        }
        return this.normalize(this.dn);
    }

    public String getVO() {
        return this.vo;
    }

    public List<String> getVOMSAttributes() {
        if (this.vomsAttributes == null) {
            this.vomsAttributes = new ArrayList<String>(0);
        }
        return this.vomsAttributes;
    }

    public boolean isRFC() {
        return this.rfc;
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.expirationTime.getTime();
    }

    private String normalize(String s) {
        if (s != null) {
            return s.replaceAll("\\W", "_");
        }
        return null;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public void setDN(String dn) {
        this.dn = dn;
    }

    public void setExpirationTime(Date time) {
        this.expirationTime = time;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFQAN(String fqan) {
        this.fqan = fqan;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setLocalUser(String localUser) {
        this.localUser = localUser;
    }

    public void setLocalUserGroup(String localUserGroup) {
        this.localUserGroup = localUserGroup;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRFC(boolean b) {
        this.rfc = b;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setVO(String vo) {
        this.vo = vo;
    }

    public void setVOMSAttributes(List<String> vomsAttributes) {
        this.vomsAttributes = vomsAttributes;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[id='");
        buff.append(this.id);
        buff.append("'; rfc=").append(this.rfc);
        if (this.dn != null) {
            buff.append("; dn='").append(this.dn);
        }
        if (this.localUser != null) {
            buff.append("'; localUser='").append(this.localUser);
        }
        if (this.vo != null) {
            buff.append("'; vo='").append(this.vo);
        }
        if (this.startTime != null || this.expirationTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (this.startTime != null) {
                buff.append("'; startTime='").append(dateFormat.format(this.startTime)).append(" (GMT)");
            }
            if (this.expirationTime != null) {
                buff.append("'; expirationTime='").append(dateFormat.format(this.expirationTime)).append(" (GMT)");
            }
        }
        buff.append("'];");
        return buff.toString();
    }
}

