/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement.queue;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;
import org.glite.ce.commonj.db.DatasourceManager;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueException;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandQueue
implements CommandQueueInterface {
    private static final Logger logger = Logger.getLogger(CommandQueue.class);
    private static final String ID_FIELD = "id";
    private static final String COMMAND_ID_FIELD = "commandId";
    private static final String COMMAND_GROUP_ID_FIELD = "commandGroupId";
    private static final String IS_SCHEDULED_FIELD = "isScheduled";
    private static final String PRIORITY_LEVEL_FIELD = "priorityLevel";
    private static final String EXECUTION_MODE_FIELD = "executionMode";
    private static final String NAME_FIELD = "name";
    private static final String VALUE_FIELD = "value";
    private static final String CATEGORY_FIELD = "category";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String STATUS_TYPE_FIELD = "statusType";
    private static final String FAILURE_REASON_FIELD = "failureReason";
    private static final String USER_ID_FIELD = "userId";
    private static final String CREATION_TIME_FIELD = "creationTime";
    private String QUEUE_TABLE = "command_queue";
    private String PARAMETER_TABLE = "command_queue_parameter";
    private String dataSourceName = null;
    private final AtomicLong maxInThroughput = new AtomicLong(0L);
    private final AtomicLong maxOutThroughput = new AtomicLong(0L);
    private final AtomicLong currentInThroughput = new AtomicLong(0L);
    private final AtomicLong currentOutThroughput = new AtomicLong(0L);
    private final AtomicLong commandInCounter = new AtomicLong(0L);
    private final AtomicLong commandOutCounter = new AtomicLong(0L);
    private final Set<String> excludedCommandGroupIdSet = new ConcurrentSkipListSet<String>();
    private final Object lock = new Object();
    private final Object queueLock = new Object();
    private final long emptyQueueTimeout = 10000L;
    private long notEmptyQueueTimeout = 1000L;
    private Calendar lastThroughputUpdate = null;
    private BlockingQueue<Command> queue;
    private FillUpQueueThread fillUpQueueThread = null;
    private boolean isOpen = false;
    private boolean isShared = false;
    private int maxQueueSize = 500;

    public CommandQueue(String dataSourceName) throws CommandQueueException {
        this(dataSourceName, 500);
    }

    public CommandQueue(String dataSourceName, int queueSize) throws CommandQueueException {
        if (dataSourceName == null) {
            logger.error((Object)"dataSourceName not defined!");
            throw new CommandQueueException("dataSourceName not specified!");
        }
        this.dataSourceName = dataSourceName;
        this.lastThroughputUpdate = Calendar.getInstance();
        this.createQueueTable();
        if (queueSize <= 0) {
            logger.warn((Object)"queueSize <= 0, using default value (500)");
            this.maxQueueSize = 500;
        } else {
            this.maxQueueSize = queueSize;
        }
        this.queue = new LinkedBlockingQueue<Command>(this.maxQueueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfTableExists(String tableName, Connection connection) throws CommandQueueException {
        if (tableName == null) {
            throw new CommandQueueException("tableName not specified!");
        }
        if (connection == null) {
            throw new CommandQueueException("connection not specified!");
        }
        logger.debug((Object)"BEGIN checkIfTableExists");
        boolean result = false;
        Statement pstmt = null;
        ResultSet rset = null;
        try {
            pstmt = connection.prepareStatement("select count(*) from " + tableName);
            rset = pstmt.executeQuery();
            if (rset != null) {
                result = true;
            }
        }
        catch (SQLException sqle) {
            result = false;
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)"END checkIfTableExists");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.isOpen = false;
        logger.warn((Object)"the queue has been closed");
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notifyAll();
            logger.debug((Object)"NotifyAll for queueLock because the queue has been closed!");
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.fillUpQueueThread = null;
        logger.info((Object)("the queue " + this.QUEUE_TABLE + " is now closed!"));
    }

    private void createQueueTable() throws CommandQueueException {
        logger.debug((Object)("BEGIN createQueueTable: " + this.QUEUE_TABLE));
        Statement pstmt = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            StringBuffer query = null;
            boolean exists = this.checkIfTableExists(this.QUEUE_TABLE, connection);
            if (!exists) {
                query = new StringBuffer("create table if not exists ");
                query.append(this.QUEUE_TABLE).append(" (");
                query.append(ID_FIELD).append(" BIGINT NOT NULL AUTO_INCREMENT, ");
                query.append(NAME_FIELD).append(" VARCHAR(256) NOT NULL, ");
                query.append(CATEGORY_FIELD).append(" VARCHAR(256) NULL, ");
                query.append(USER_ID_FIELD).append(" TEXT NOT NULL, ");
                query.append(DESCRIPTION_FIELD).append(" TEXT NULL, ");
                query.append(FAILURE_REASON_FIELD).append(" TEXT NULL, ");
                query.append(STATUS_TYPE_FIELD).append(" INTEGER NOT NULL, ");
                query.append(CREATION_TIME_FIELD).append(" TIMESTAMP NULL DEFAULT now(), ");
                query.append(IS_SCHEDULED_FIELD).append(" BOOL NOT NULL, ");
                query.append(PRIORITY_LEVEL_FIELD).append(" TINYINT UNSIGNED NOT NULL DEFAULT 0, ");
                query.append(COMMAND_GROUP_ID_FIELD).append(" VARCHAR(14) NULL, ");
                query.append(EXECUTION_MODE_FIELD).append(" CHAR(1) NOT NULL, primary key (");
                query.append(ID_FIELD).append(")) engine=InnoDB");
                pstmt = connection.prepareStatement(query.toString());
                pstmt.executeUpdate();
                logger.info((Object)(this.QUEUE_TABLE + " table created"));
            }
            if (!this.checkIfTableExists(this.PARAMETER_TABLE, connection)) {
                query = new StringBuffer("create table if not exists ");
                query.append(this.PARAMETER_TABLE).append(" (");
                query.append(ID_FIELD).append(" BIGINT NOT NULL AUTO_INCREMENT, ");
                query.append(COMMAND_ID_FIELD).append(" BIGINT NOT NULL, ");
                query.append(NAME_FIELD).append(" VARCHAR(256) NOT NULL, ");
                query.append(VALUE_FIELD).append(" TEXT NOT NULL, primary key ( ");
                query.append(ID_FIELD).append(")) engine=InnoDB");
                pstmt = connection.prepareStatement(query.toString());
                pstmt.executeUpdate();
                logger.info((Object)(this.PARAMETER_TABLE + " table created"));
                query = new StringBuffer("ALTER TABLE ");
                query.append(this.PARAMETER_TABLE).append(" ADD CONSTRAINT fk_").append(this.PARAMETER_TABLE);
                query.append(" FOREIGN KEY (").append(COMMAND_ID_FIELD).append(") REFERENCES ");
                query.append(this.QUEUE_TABLE).append(" (id) ON UPDATE CASCADE ON DELETE CASCADE");
                pstmt = connection.prepareStatement(query.toString());
                pstmt.executeUpdate();
            }
            if (exists) {
                logger.info((Object)"The queue is already existing, now I try to recover it...");
                query = new StringBuffer("update ");
                query.append(this.QUEUE_TABLE).append(" set ");
                query.append(STATUS_TYPE_FIELD).append(" = ?, ");
                query.append(DESCRIPTION_FIELD).append(" = ?, ");
                query.append(IS_SCHEDULED_FIELD).append(" = ?, ");
                query.append(PRIORITY_LEVEL_FIELD).append(" = ? where ");
                query.append(IS_SCHEDULED_FIELD).append(" = true");
                pstmt = connection.prepareStatement(query.toString());
                pstmt.setInt(1, 3);
                pstmt.setString(2, "command rescheduled by CREAM");
                pstmt.setBoolean(3, false);
                pstmt.setLong(4, 3L);
                pstmt.executeUpdate();
                logger.info((Object)"queue recovered successfully!");
            }
            connection.commit();
        }
        catch (SQLException sqle) {
            String rollbackMessage = null;
            if (connection != null) {
                try {
                    connection.rollback();
                    rollbackMessage = " (rollback performed)";
                }
                catch (SQLException sqle1) {
                    rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                }
            }
            logger.error((Object)("createQueueTable failed: cannot create the " + this.QUEUE_TABLE + " table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
            throw new CommandQueueException("Cannot create the " + this.QUEUE_TABLE + " table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)("Problem in closing connection: " + sqle2.getMessage()));
                    throw new CommandQueueException(sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)("END createQueueTable: " + this.QUEUE_TABLE));
    }

    private void deleteQueueTable() throws CommandQueueException {
        logger.debug((Object)("BEGIN deleteQueueTable " + this.QUEUE_TABLE));
        Connection connection = this.getConnection();
        Statement pstmt = null;
        try {
            pstmt = connection.prepareStatement("drop table if exists " + this.PARAMETER_TABLE);
            pstmt.executeUpdate();
            logger.debug((Object)(this.PARAMETER_TABLE + " table dropped!"));
            pstmt = connection.prepareStatement("drop table if exists " + this.QUEUE_TABLE);
            pstmt.executeUpdate();
            logger.debug((Object)(this.QUEUE_TABLE + " table dropped!"));
            connection.commit();
        }
        catch (SQLException sqle) {
            String rollbackMessage = null;
            if (connection != null) {
                try {
                    connection.rollback();
                    rollbackMessage = " (rollback performed)";
                }
                catch (SQLException sqle1) {
                    rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                }
            }
            logger.error((Object)("createQueueTable failed: cannot create the " + this.QUEUE_TABLE + " table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
            throw new CommandQueueException("Cannot delete the " + this.QUEUE_TABLE + " table: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)("Problem in closing connection: " + sqle2.getMessage()));
                    throw new CommandQueueException(sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)("END deleteQueueTable " + this.QUEUE_TABLE));
    }

    @Override
    public void dequeue(Command command) throws CommandQueueException {
        logger.debug((Object)"BEGIN dequeue");
        if (command == null) {
            throw new CommandQueueException("command not specified!");
        }
        if (command.getId() == 0L) {
            throw new CommandQueueException("command id not specified!");
        }
        Connection connection = this.getConnection();
        PreparedStatement pstmt = null;
        StringBuffer query = new StringBuffer("delete from ");
        query.append(this.QUEUE_TABLE).append(" where ");
        query.append(ID_FIELD).append(" = ?");
        try {
            pstmt = connection.prepareStatement(query.toString());
            pstmt.setLong(1, command.getId());
            int rowCount = pstmt.executeUpdate();
            logger.debug((Object)("deleted " + rowCount + " rows"));
            connection.commit();
            if (Command.ExecutionModeValues.SERIAL.equals(command.getExecutionMode())) {
                this.excludedCommandGroupIdSet.remove(command.getCommandGroupId());
            }
        }
        catch (SQLException sqle) {
            String rollbackMessage = null;
            if (connection != null) {
                try {
                    connection.rollback();
                    rollbackMessage = " (rollback performed)";
                }
                catch (SQLException sqle1) {
                    rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                }
            }
            logger.error((Object)("dequeue failed: cannot dequeue the command id=" + command.getId() + ": " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
            throw new CommandQueueException("Cannot dequeue the command id=" + command.getId() + ": " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)("Problem in closing connection: " + sqle2.getMessage()));
                    throw new CommandQueueException(sqle2.getMessage());
                }
            }
        }
        logger.debug((Object)"END dequeue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void enqueue(Command command) throws CommandQueueException {
        block40: {
            SQLException sqle22;
            Connection connection;
            ResultSet rset;
            PreparedStatement pstmt;
            block38: {
                if (command == null) {
                    throw new CommandQueueException("command not specified!");
                }
                if (command.getPriorityLevel() < 0 || command.getPriorityLevel() > 3) {
                    throw new CommandQueueException("invalid priority level=" + command.getPriorityLevel());
                }
                if (command.getExecutionMode() == Command.ExecutionModeValues.SERIAL && (command.getCommandGroupId() == null || "".equals(command.getCommandGroupId()))) {
                    logger.error((Object)"CommandGroupId field mustn't be empty for serial commands.");
                    throw new CommandQueueException("The command has a null CommandGroupId");
                }
                if (command.getUserId() == null) {
                    throw new CommandQueueException("The command has a null userId");
                }
                if (command.getCreationTime() == null) {
                    throw new CommandQueueException("The command has a null creation time");
                }
                logger.debug((Object)"BEGIN enqueue");
                StringBuffer query = new StringBuffer("insert into ");
                query.append(this.QUEUE_TABLE).append(" (");
                query.append(NAME_FIELD).append(", ");
                query.append(CATEGORY_FIELD).append(", ");
                query.append(DESCRIPTION_FIELD).append(", ");
                query.append(FAILURE_REASON_FIELD).append(", ");
                query.append(COMMAND_GROUP_ID_FIELD).append(", ");
                query.append(USER_ID_FIELD).append(", ");
                query.append(STATUS_TYPE_FIELD).append(", ");
                query.append(PRIORITY_LEVEL_FIELD).append(", ");
                query.append(IS_SCHEDULED_FIELD).append(", ");
                query.append(EXECUTION_MODE_FIELD).append(", ");
                query.append(CREATION_TIME_FIELD);
                query.append(") values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                long commandId = -1L;
                pstmt = null;
                rset = null;
                connection = this.getConnection();
                pstmt = connection.prepareStatement(query.toString(), 1);
                pstmt.setString(1, command.getName());
                pstmt.setString(2, command.getCategory());
                pstmt.setString(3, command.getDescription());
                pstmt.setString(4, command.getFailureReason());
                pstmt.setString(5, command.getCommandGroupId());
                pstmt.setString(6, command.getUserId());
                pstmt.setInt(7, command.getStatus());
                pstmt.setInt(8, command.getPriorityLevel());
                pstmt.setBoolean(9, command.isScheduled());
                pstmt.setString(10, command.getExecutionMode().getStringValue());
                pstmt.setTimestamp(11, new Timestamp(command.getCreationTime().getTimeInMillis()));
                int rowCount = pstmt.executeUpdate();
                rset = pstmt.getGeneratedKeys();
                if (rset == null || !rset.next()) {
                    throw new SQLException("Problem in retrieving autogenerated keys");
                }
                commandId = rset.getLong(1);
                command.setId(commandId);
                if (commandId <= -1L) {
                    throw new SQLException("Problem in retrieving autogenerated keys");
                }
                if (command.getParameterKeySet().size() > 0) {
                    query = new StringBuffer("insert into ");
                    query.append(this.PARAMETER_TABLE);
                    query.append(" (").append(COMMAND_ID_FIELD).append(", ");
                    query.append(NAME_FIELD).append(", ");
                    query.append(VALUE_FIELD);
                    query.append(") values(?, ?, ?)");
                    pstmt = connection.prepareStatement(query.toString(), 1);
                    rowCount = 0;
                    for (String key : command.getParameterKeySet()) {
                        List<String> valueList = command.getParameterMultivalue(key);
                        for (String value : valueList) {
                            pstmt.setLong(1, command.getId());
                            pstmt.setString(2, key);
                            pstmt.setString(3, value);
                            rowCount += pstmt.executeUpdate();
                            rset = pstmt.getGeneratedKeys();
                            if (!rset.next()) {
                                throw new SQLException("Problem in retrieving autogenerated keys");
                            }
                            pstmt.clearParameters();
                            logger.debug((Object)("Inserted parameter [name=" + key + ", value=" + value + "]"));
                        }
                    }
                }
                connection.commit();
                Iterator<String> i$ = this.lastThroughputUpdate;
                synchronized (i$) {
                    this.commandInCounter.incrementAndGet();
                }
                i$ = this.lock;
                synchronized (i$) {
                    this.lock.notifyAll();
                }
                Object var17_18 = null;
                if (pstmt == null) break block38;
                try {
                    pstmt.close();
                }
                catch (SQLException sqle22) {
                    logger.error((Object)sqle22.getMessage());
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sqle22) {
                    logger.error((Object)sqle22.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle23) {
                    logger.error((Object)("Problem in closing connection: " + sqle23.getMessage()));
                    throw new CommandQueueException(sqle23.getMessage());
                }
            }
            break block40;
            {
                catch (SQLException sqle3) {
                    String rollbackMessage = null;
                    if (connection != null) {
                        try {
                            connection.rollback();
                            rollbackMessage = " (rollback performed)";
                        }
                        catch (SQLException sqle1) {
                            rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                        }
                    }
                    logger.error((Object)("enqueue failed: cannot enqueue the command id=" + command.getId() + ": " + sqle3.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
                    throw new CommandQueueException("Cannot enqueue the command id=" + command.getId() + ": " + sqle3.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
                }
            }
            catch (Throwable throwable) {
                SQLException sqle22;
                Object var17_19 = null;
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sqle22) {
                        logger.error((Object)sqle22.getMessage());
                    }
                }
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (SQLException sqle22) {
                        logger.error((Object)sqle22.getMessage());
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle23) {
                        logger.error((Object)("Problem in closing connection: " + sqle23.getMessage()));
                        throw new CommandQueueException(sqle23.getMessage());
                    }
                }
                throw throwable;
            }
        }
        logger.debug((Object)"END enqueue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<Command> executeGetCommands(boolean scheduled, int priorityLevel, int limit) throws CommandQueueException {
        TreeMap<String, Command> commandList;
        block41: {
            SQLException sqle222;
            Connection connection;
            ResultSet rset;
            PreparedStatement pstmt;
            block39: {
                logger.debug((Object)("BEGIN executeGetCommands: scheduled=" + scheduled + "; priorityLevel=" + priorityLevel + "; limit=" + limit + "; excludedCommandGroupId.size=" + this.excludedCommandGroupIdSet.size()));
                StringBuffer query = new StringBuffer("select ");
                query.append(this.QUEUE_TABLE).append(".").append(ID_FIELD).append(" as ").append(ID_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(NAME_FIELD).append(" as ").append(NAME_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(CATEGORY_FIELD).append(" as ").append(CATEGORY_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(USER_ID_FIELD).append(" as ").append(USER_ID_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(DESCRIPTION_FIELD).append(" as ").append(DESCRIPTION_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(FAILURE_REASON_FIELD).append(" as ").append(FAILURE_REASON_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(STATUS_TYPE_FIELD).append(" as ").append(STATUS_TYPE_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(COMMAND_GROUP_ID_FIELD).append(" as ").append(COMMAND_GROUP_ID_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(CREATION_TIME_FIELD).append(" as ").append(CREATION_TIME_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(IS_SCHEDULED_FIELD).append(" as ").append(IS_SCHEDULED_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(PRIORITY_LEVEL_FIELD).append(" as ").append(PRIORITY_LEVEL_FIELD).append(", ");
                query.append(this.QUEUE_TABLE).append(".").append(EXECUTION_MODE_FIELD).append(" as ").append(EXECUTION_MODE_FIELD);
                query.append(" from ").append(this.QUEUE_TABLE).append(" where ");
                query.append(this.QUEUE_TABLE).append(".").append(IS_SCHEDULED_FIELD).append(" = ?");
                if (priorityLevel >= 0) {
                    query.append(" and ").append(this.QUEUE_TABLE).append(".").append(PRIORITY_LEVEL_FIELD).append(" = ?");
                }
                if (this.isShared) {
                    query.append(" and ").append(COMMAND_GROUP_ID_FIELD).append(" NOT IN (select ");
                    query.append(COMMAND_GROUP_ID_FIELD).append(" from ");
                    query.append(this.QUEUE_TABLE).append(" where ");
                    query.append(IS_SCHEDULED_FIELD).append(" = true and ");
                    query.append(EXECUTION_MODE_FIELD).append(" = '");
                    query.append("S").append("')");
                } else if (this.excludedCommandGroupIdSet.size() > 0) {
                    query.append(" and ").append(COMMAND_GROUP_ID_FIELD).append(" NOT IN (");
                    Set<String> set = this.excludedCommandGroupIdSet;
                    synchronized (set) {
                        for (String cmdGroupId : this.excludedCommandGroupIdSet) {
                            query.append("'").append(cmdGroupId).append("',");
                        }
                    }
                    query.replace(query.length() - 1, query.length(), ")");
                }
                query.append(" order by ").append(ID_FIELD).append(" ASC");
                if (limit >= 1) {
                    query.append(" limit ?");
                }
                query.append(" for update");
                commandList = new TreeMap<String, Command>();
                pstmt = null;
                rset = null;
                String parameterName = null;
                String parameterValue = null;
                connection = this.getConnection();
                int index = 1;
                pstmt = connection.prepareStatement(query.toString());
                pstmt.setBoolean(index++, scheduled);
                if (priorityLevel >= 0) {
                    pstmt.setInt(index++, priorityLevel);
                }
                if (limit >= 1) {
                    pstmt.setInt(index, limit);
                }
                rset = pstmt.executeQuery();
                Command command = null;
                Calendar calendar = null;
                Timestamp timestamp = null;
                if (rset != null) {
                    query = new StringBuffer(" IN (");
                    while (rset.next()) {
                        command = new Command(rset.getString(NAME_FIELD), rset.getString(CATEGORY_FIELD));
                        command.setId(rset.getLong(ID_FIELD));
                        command.setUserId(rset.getString(USER_ID_FIELD));
                        command.setDescription(rset.getString(DESCRIPTION_FIELD));
                        command.setFailureReason(rset.getString(FAILURE_REASON_FIELD));
                        command.setCommandGroupId(rset.getString(COMMAND_GROUP_ID_FIELD));
                        command.setAsynchronous(true);
                        command.setPriorityLevel(rset.getInt(PRIORITY_LEVEL_FIELD));
                        command.setExecutionMode(Command.ExecutionModeValues.PARALLEL.equals(rset.getString(EXECUTION_MODE_FIELD)) ? Command.ExecutionModeValues.PARALLEL : Command.ExecutionModeValues.SERIAL);
                        calendar = null;
                        timestamp = rset.getTimestamp(CREATION_TIME_FIELD);
                        if (timestamp != null) {
                            calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(timestamp.getTime());
                            command.setCreationTime(calendar);
                        }
                        commandList.put("" + command.getId(), command);
                        query.append("'").append(command.getId()).append("',");
                    }
                    query.replace(query.length() - 1, query.length(), ")");
                    if (commandList.size() > 0) {
                        StringBuffer setScheduledQuery = new StringBuffer("update ");
                        setScheduledQuery.append(this.QUEUE_TABLE).append(" set ").append(IS_SCHEDULED_FIELD);
                        setScheduledQuery.append(" = true where ").append(ID_FIELD).append(query);
                        pstmt = connection.prepareStatement(setScheduledQuery.toString());
                        pstmt.executeUpdate();
                        StringBuffer selectParameterQuery = new StringBuffer("select ");
                        selectParameterQuery.append(this.PARAMETER_TABLE).append(".").append(ID_FIELD).append(" as PARAMETER_ID, ");
                        selectParameterQuery.append(this.PARAMETER_TABLE).append(".").append(COMMAND_ID_FIELD).append(" as ").append(COMMAND_ID_FIELD).append(", ");
                        selectParameterQuery.append(this.PARAMETER_TABLE).append(".").append(NAME_FIELD).append(" as PARAMETER_NAME, ");
                        selectParameterQuery.append(this.PARAMETER_TABLE).append(".").append(VALUE_FIELD).append(" as PARAMETER_VALUE from ");
                        selectParameterQuery.append(this.PARAMETER_TABLE).append(" where ").append(COMMAND_ID_FIELD).append(query);
                        pstmt = connection.prepareStatement(selectParameterQuery.toString());
                        rset = pstmt.executeQuery();
                        if (rset != null) {
                            long commandId = -1L;
                            while (rset.next()) {
                                commandId = rset.getLong(COMMAND_ID_FIELD);
                                command = (Command)commandList.get("" + commandId);
                                if (commandId <= 0L) continue;
                                parameterName = rset.getString("PARAMETER_NAME");
                                parameterValue = rset.getString("PARAMETER_VALUE");
                                if (command.containsParameterKey(parameterName)) {
                                    List<String> valueList = command.getParameterMultivalue(parameterName);
                                    valueList.add(parameterValue);
                                    command.addParameter(parameterName, valueList);
                                    continue;
                                }
                                command.addParameter(parameterName, (Serializable)((Object)parameterValue));
                            }
                        }
                    }
                }
                connection.commit();
                Object var21_23 = null;
                if (pstmt == null) break block39;
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1.getMessage());
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sqle222) {
                    logger.error((Object)sqle222.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle222) {
                    logger.error((Object)("Problem in closing connection: " + sqle222.getMessage()));
                    throw new CommandQueueException(sqle222.getMessage());
                }
            }
            break block41;
            {
                catch (SQLException sqle) {
                    String rollbackMessage = null;
                    if (connection != null) {
                        try {
                            connection.rollback();
                            rollbackMessage = " (rollback performed)";
                        }
                        catch (SQLException sqle1) {
                            rollbackMessage = " (rollback failed: " + sqle1.getMessage() + ")";
                        }
                    }
                    logger.error((Object)("executeGetCommands failed: " + sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : "")));
                    throw new CommandQueueException(sqle.getMessage() + (rollbackMessage != null ? rollbackMessage : ""));
                }
            }
            catch (Throwable throwable) {
                SQLException sqle222;
                Object var21_24 = null;
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1.getMessage());
                    }
                }
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (SQLException sqle222) {
                        logger.error((Object)sqle222.getMessage());
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle222) {
                        logger.error((Object)("Problem in closing connection: " + sqle222.getMessage()));
                        throw new CommandQueueException(sqle222.getMessage());
                    }
                }
                throw throwable;
            }
        }
        logger.debug((Object)("END executeGetCommands: found #" + commandList.size() + " commands"));
        return new ArrayList<Command>(commandList.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evalutateThroughput() {
        Calendar now = Calendar.getInstance();
        long maxInThroughputTmp = 0L;
        long maxOutThroughputTmp = 0L;
        long currentInThroughputTmp = 0L;
        long currentOutThroughputTmp = 0L;
        long elapsedTimeInMillis = now.getTimeInMillis() - this.lastThroughputUpdate.getTimeInMillis();
        logger.debug((Object)("[queue=" + this.QUEUE_TABLE + "]: evaluating the throughput..."));
        Calendar calendar = this.lastThroughputUpdate;
        synchronized (calendar) {
            this.lastThroughputUpdate.setTime(now.getTime());
            maxInThroughputTmp = this.maxInThroughput.get();
            if (this.commandInCounter.get() > 0L) {
                currentInThroughputTmp = this.commandInCounter.get() * 60000L / elapsedTimeInMillis;
            }
            this.currentInThroughput.set(currentInThroughputTmp);
            if (maxInThroughputTmp < currentInThroughputTmp) {
                maxInThroughputTmp = currentInThroughputTmp;
                this.maxInThroughput.set(maxInThroughputTmp);
            }
            maxOutThroughputTmp = this.maxOutThroughput.get();
            if (this.commandOutCounter.get() > 0L) {
                currentOutThroughputTmp = this.commandOutCounter.get() * 60000L / elapsedTimeInMillis;
            }
            this.currentOutThroughput.set(currentOutThroughputTmp);
            if (maxOutThroughputTmp < currentOutThroughputTmp) {
                maxOutThroughputTmp = currentOutThroughputTmp;
                this.maxOutThroughput.set(maxOutThroughputTmp);
            }
            this.commandInCounter.set(0L);
            this.commandOutCounter.set(0L);
        }
        logger.debug((Object)("[queue=" + this.QUEUE_TABLE + "]: evaluating the throughput... done!"));
    }

    private Connection getConnection() throws CommandQueueException {
        Connection connection = null;
        try {
            connection = DatasourceManager.getConnection((String)this.dataSourceName);
        }
        catch (DatabaseException ex) {
            throw new CommandQueueException(ex.getMessage());
        }
        if (connection == null) {
            logger.error((Object)"cannot get the database connection");
            throw new CommandQueueException("cannot get the database connection");
        }
        return connection;
    }

    @Override
    public long getCurrentInThroughput() {
        return this.currentInThroughput.get();
    }

    @Override
    public long getCurrentOutThroughput() {
        return this.currentOutThroughput.get();
    }

    @Override
    public Calendar getLastThroughputUpdate() {
        return this.lastThroughputUpdate;
    }

    @Override
    public long getMaxInThroughput() {
        return this.maxInThroughput.get();
    }

    @Override
    public long getMaxOutThroughput() {
        return this.maxOutThroughput.get();
    }

    @Override
    public String getName() {
        return this.QUEUE_TABLE;
    }

    /*
     * Loose catch block
     */
    @Override
    public int getSize() throws CommandQueueException {
        int queueSize;
        block23: {
            SQLException sqle22;
            ResultSet rset;
            Statement pstmt;
            Connection connection;
            block21: {
                logger.debug((Object)"BEGIN getSize");
                connection = this.getConnection();
                pstmt = null;
                rset = null;
                queueSize = 0;
                pstmt = connection.prepareStatement("select count(1) from " + this.QUEUE_TABLE + " where isScheduled=false");
                rset = pstmt.executeQuery();
                if (rset != null) {
                    rset.next();
                    if (rset.getRow() > 0) {
                        queueSize = rset.getInt(1);
                    } else {
                        logger.debug((Object)"No command in queue");
                    }
                }
                connection.commit();
                logger.debug((Object)("queue size is " + queueSize));
                Object var7_5 = null;
                if (pstmt == null) break block21;
                try {
                    pstmt.close();
                }
                catch (SQLException sqle22) {
                    logger.error((Object)sqle22.getMessage());
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sqle22) {
                    logger.error((Object)sqle22.getMessage());
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle23) {
                    logger.error((Object)("Problem in closing connection: " + sqle23.getMessage()));
                    throw new CommandQueueException(sqle23.getMessage());
                }
            }
            break block23;
            {
                catch (SQLException sqle3) {
                    throw new CommandQueueException(sqle3.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLException sqle22;
                Object var7_6 = null;
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sqle22) {
                        logger.error((Object)sqle22.getMessage());
                    }
                }
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (SQLException sqle22) {
                        logger.error((Object)sqle22.getMessage());
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sqle23) {
                        logger.error((Object)("Problem in closing connection: " + sqle23.getMessage()));
                        throw new CommandQueueException(sqle23.getMessage());
                    }
                }
                throw throwable;
            }
        }
        logger.debug((Object)"END getSize");
        return queueSize;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public void open() {
        this.isOpen = true;
        this.fillUpQueueThread = new FillUpQueueThread();
        this.fillUpQueueThread.start();
        logger.info((Object)("the queue " + this.QUEUE_TABLE + " is now opened!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command peek() throws CommandQueueException {
        if (!this.isOpen) {
            throw new CommandQueueException("the queue " + this.QUEUE_TABLE + " is closed!");
        }
        if (this.queue.size() == 0) {
            return null;
        }
        Command command = null;
        try {
            command = (Command)this.queue.peek();
            Calendar calendar = this.lastThroughputUpdate;
            synchronized (calendar) {
                this.commandOutCounter.incrementAndGet();
            }
        }
        catch (Throwable t) {
            throw new CommandQueueException(t.getMessage());
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command poll() throws CommandQueueException {
        if (!this.isOpen) {
            throw new CommandQueueException("the queue " + this.QUEUE_TABLE + " is closed!");
        }
        if (this.queue.size() == 0) {
            return null;
        }
        Command command = null;
        try {
            command = (Command)this.queue.poll();
            this.dequeue(command);
            Calendar calendar = this.lastThroughputUpdate;
            synchronized (calendar) {
                this.commandOutCounter.incrementAndGet();
            }
        }
        catch (Throwable t) {
            throw new CommandQueueException(t.getMessage());
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command remove() throws CommandQueueException {
        if (!this.isOpen) {
            throw new CommandQueueException("the queue " + this.QUEUE_TABLE + " is closed!");
        }
        if (this.queue.size() == 0) {
            throw new CommandQueueException("the queue " + this.QUEUE_TABLE + " is empty!");
        }
        Command command = null;
        try {
            command = (Command)this.queue.remove();
            this.dequeue(command);
            Calendar calendar = this.lastThroughputUpdate;
            synchronized (calendar) {
                this.commandOutCounter.incrementAndGet();
            }
        }
        catch (Throwable t) {
            throw new CommandQueueException(t.getMessage());
        }
        return command;
    }

    @Override
    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    @Override
    public void setTimeout(long msTimeout) {
        this.notEmptyQueueTimeout = msTimeout < 0L ? 60000L : msTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Command take() throws CommandQueueException {
        Command command = null;
        try {
            Object object = this.queueLock;
            synchronized (object) {
                while (this.queue.size() == 0 && this.isOpen) {
                    logger.debug((Object)"Waiting for items because queue.size=0.");
                    this.queueLock.wait();
                }
                logger.debug((Object)("The waiting is terminated. queue.size = " + this.queue.size() + " isOpen = " + this.isOpen));
                if (this.isOpen) {
                    logger.debug((Object)"Before taking one item.");
                    command = this.queue.take();
                    logger.debug((Object)"Take item: done");
                    this.dequeue(command);
                }
            }
            logger.debug((Object)"synchronized queueLock: done.");
            object = this.lastThroughputUpdate;
            synchronized (object) {
                this.commandOutCounter.incrementAndGet();
            }
        }
        catch (Throwable t) {
            throw new CommandQueueException(t.getMessage());
        }
        logger.debug((Object)("command: " + command));
        return command;
    }

    private class FillUpQueueThread
    extends Thread {
        public FillUpQueueThread() {
            super("FillUpQueueThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.info((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: started!"));
            TreeSet commandList = new TreeSet();
            TreeSet<Object> commandToBeEnqueued1L = new TreeSet<Object>();
            TreeSet<Object> commandToBeEnqueued2L = new TreeSet<Object>();
            while (CommandQueue.this.isOpen) {
                block22: {
                    try {
                        if (!((double)CommandQueue.this.queue.size() <= (double)CommandQueue.this.maxQueueSize * 0.1) || commandToBeEnqueued2L.size() <= 0 && (long)CommandQueue.this.getSize() <= 0L) break block22;
                        commandList.clear();
                        commandList.addAll(commandToBeEnqueued2L);
                        commandToBeEnqueued2L.clear();
                        for (int priorityLevel = 3; priorityLevel >= 0 && CommandQueue.this.maxQueueSize > CommandQueue.this.queue.size() + commandToBeEnqueued1L.size() + commandToBeEnqueued2L.size(); --priorityLevel) {
                            commandList.addAll(CommandQueue.this.executeGetCommands(false, priorityLevel, CommandQueue.this.maxQueueSize - CommandQueue.this.queue.size() - commandToBeEnqueued1L.size() - commandToBeEnqueued2L.size()));
                            for (Object command : commandList) {
                                if (CommandQueue.this.excludedCommandGroupIdSet.contains(((Command)command).getCommandGroupId())) {
                                    commandToBeEnqueued2L.add(command);
                                    continue;
                                }
                                if (((Command)command).getExecutionMode().equals(Command.ExecutionModeValues.SERIAL)) {
                                    CommandQueue.this.excludedCommandGroupIdSet.add(((Command)command).getCommandGroupId());
                                }
                                commandToBeEnqueued1L.add(command);
                                ((Command)command).setStatus(2);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("status change for command [" + ((Command)command).toString() + "]"));
                            }
                            commandList.clear();
                        }
                        CommandQueue.this.queue.addAll(commandToBeEnqueued1L);
                        Object priorityLevel = CommandQueue.this.queueLock;
                        synchronized (priorityLevel) {
                            CommandQueue.this.queueLock.notifyAll();
                            logger.debug((Object)"NotifyAll (queueLock): items available.");
                        }
                        logger.debug((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: queue size = " + CommandQueue.this.queue.size()));
                        commandToBeEnqueued1L.clear();
                    }
                    catch (CommandQueueException ex) {
                        logger.error((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: " + ex.getMessage()));
                    }
                }
                try {
                    Object command;
                    long msTimeout = 0L;
                    if (CommandQueue.this.isShared) {
                        msTimeout = (long)CommandQueue.this.getSize() == 0L && commandToBeEnqueued2L.size() == 0 ? 10000L : CommandQueue.this.notEmptyQueueTimeout;
                        logger.debug((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: waiting " + msTimeout + " msec..."));
                        command = CommandQueue.this.lock;
                        synchronized (command) {
                            CommandQueue.this.lock.wait(msTimeout);
                            continue;
                        }
                    }
                    long l = msTimeout = CommandQueue.this.queue.size() == 0 && (long)CommandQueue.this.getSize() == 0L && commandToBeEnqueued2L.size() == 0 ? 0L : CommandQueue.this.notEmptyQueueTimeout;
                    if (msTimeout == 0L) {
                        logger.info((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: waiting indefinitely..."));
                        command = CommandQueue.this.lock;
                        synchronized (command) {
                            CommandQueue.this.lock.wait(msTimeout);
                            continue;
                        }
                    }
                    logger.debug((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: waiting " + msTimeout + " msec..."));
                    try {
                        Thread.sleep(msTimeout);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "] error: " + e.getMessage()));
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "] error: " + e.getMessage()));
                }
            }
            logger.info((Object)("[queue=" + CommandQueue.this.QUEUE_TABLE + "]: end"));
        }
    }
}

