/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.utils.Timer;
import org.glite.ce.commonj.utils.TimerTask;
import org.glite.ce.creamapi.cmdmanagement.Policy;
import org.glite.ce.creamapi.cmdmanagement.PolicyException;
import org.glite.ce.creamapi.cmdmanagement.PolicyManagerException;
import org.glite.ce.creamapi.cmdmanagement.PolicyTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyManager {
    private static final Logger logger = Logger.getLogger((String)PolicyManager.class.getName());
    private static Timer timer = null;
    private static PolicyManager policyManager = null;
    private Hashtable<String, PolicyTask> policyTaskTable = new Hashtable(0);
    private Hashtable<String, Policy> policyTable = new Hashtable(0);

    private PolicyManager() {
    }

    public static PolicyManager getInstance() {
        if (policyManager == null) {
            policyManager = new PolicyManager();
        }
        return policyManager;
    }

    public void addPolicy(Policy policy) throws IllegalArgumentException, PolicyManagerException {
        if (policy == null) {
            throw new IllegalArgumentException("policy not specified!");
        }
        if (policy.getName() == null) {
            throw new PolicyManagerException("policy name not specified!");
        }
        if (this.policyTable.containsKey(policy.getName())) {
            throw new PolicyManagerException("Policy " + policy.getName() + " already exists!");
        }
        this.policyTable.put(policy.getName(), policy);
        if (timer != null && this.policyTaskTable.containsKey(policy.getType())) {
            PolicyTask task = this.policyTaskTable.get(policy.getType());
            if (policy.getTimeUnit() == Policy.TIME_UNIT.DATE) {
                timer.schedule((TimerTask)new PolicyTimerTask(policy, task), policy.getDate().getTime());
            } else {
                timer.schedule((TimerTask)new PolicyTimerTask(policy, task), 0L, this.getPeriod(policy.getTimeUnit(), policy.getTimeValue()).longValue(), TimerTask.EXECUTION_TYPE.FIXED_DELAY_POST_EXECUTION);
            }
        }
        logger.info((Object)("new policy " + policy.getName() + " added!"));
    }

    public void addPolicyTask(PolicyTask task) throws IllegalArgumentException, PolicyManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task not specified!");
        }
        if (task.getName() == null) {
            throw new PolicyManagerException("task name not specified!");
        }
        if (task.getCommandExecutor() == null) {
            throw new PolicyManagerException("CommandExecutor not specified!");
        }
        if (this.policyTaskTable.containsKey(task.getName())) {
            throw new PolicyManagerException("PolicyTask " + task.getName() + " already exists!");
        }
        this.policyTaskTable.put(task.getName(), task);
        if (timer != null) {
            List<Policy> list = this.getPolicyByType(task.getName());
            for (Policy policy : list) {
                if (policy.getTimeUnit() == Policy.TIME_UNIT.DATE) {
                    timer.schedule((TimerTask)new PolicyTimerTask(policy, task), policy.getDate().getTime());
                    continue;
                }
                timer.schedule((TimerTask)new PolicyTimerTask(policy, task), 0L, this.getPeriod(policy.getTimeUnit(), policy.getTimeValue()).longValue(), TimerTask.EXECUTION_TYPE.FIXED_DELAY_POST_EXECUTION);
            }
        }
        logger.info((Object)("new PolicyTask " + task.getName() + " added!"));
    }

    public Long getPeriod(Policy.TIME_UNIT timeUnit, int timeValue) {
        Long period = 0L;
        switch (timeUnit) {
            case SECOND: {
                period = 1L;
                break;
            }
            case MINUTE: {
                period = 60L;
                break;
            }
            case HOUR: {
                period = 3600L;
                break;
            }
            case DAY: {
                period = 86400L;
                break;
            }
            case MONTH: {
                period = 2592000L;
                break;
            }
            case YEAR: {
                period = 31104000L;
            }
        }
        return period * (long)timeValue * 1000L;
    }

    public List<Policy> getPolicyByType(String type) {
        ArrayList<Policy> result = new ArrayList<Policy>(0);
        if (type == null) {
            return result;
        }
        for (Policy policy : this.policyTable.values()) {
            if (policy.getType() == null || !policy.getType().equalsIgnoreCase(type)) continue;
            result.add(policy);
        }
        return result;
    }

    public List<Policy> getPolicyList() {
        return new ArrayList<Policy>(this.policyTable.values());
    }

    public PolicyTask getPolicyTask(String name) {
        if (name != null && this.policyTaskTable.containsKey(name)) {
            return this.policyTaskTable.get(name);
        }
        return null;
    }

    public List<PolicyTask> getPolicyTaskList() {
        return new ArrayList<PolicyTask>(this.policyTaskTable.values());
    }

    public void removePolicyTask(String name) {
        if (name != null && this.policyTaskTable.containsKey(name)) {
            for (int i = 0; i < timer.size(); ++i) {
                TimerTask timerTask = timer.getTimerTask(i);
                if (timerTask == null || !timerTask.getName().equalsIgnoreCase(name)) continue;
                timerTask.cancel();
            }
            timer.purge();
            PolicyTask task = this.policyTaskTable.remove(name);
            logger.info((Object)("removed " + task.getName() + " PolicyTask"));
        }
    }

    public void setPolicyList(List<Policy> list) throws IllegalArgumentException, PolicyManagerException {
        if (list != null) {
            this.policyTable.clear();
            for (Policy policy : list) {
                this.addPolicy(policy);
            }
        }
    }

    public void setPolicyTask(List<PolicyTask> policTaskList) throws IllegalArgumentException, PolicyManagerException {
        if (this.policyTaskTable != null) {
            this.policyTaskTable.clear();
            for (PolicyTask task : policTaskList) {
                this.addPolicyTask(task);
            }
        }
    }

    public void start() {
        timer = new Timer("POLICY_TIMER", true);
        for (Policy policy : this.policyTable.values()) {
            PolicyTask task = this.getPolicyTask(policy.getType());
            if (task == null) continue;
            if (policy.getTimeUnit() == Policy.TIME_UNIT.DATE) {
                timer.schedule((TimerTask)new PolicyTimerTask(policy, task), policy.getDate().getTime());
                continue;
            }
            timer.schedule((TimerTask)new PolicyTimerTask(policy, task), 0L, this.getPeriod(policy.getTimeUnit(), policy.getTimeValue()).longValue(), TimerTask.EXECUTION_TYPE.FIXED_DELAY_POST_EXECUTION);
        }
    }

    public void stop() {
        timer.cancel();
        timer.purge();
    }

    public void destroy() {
        logger.info((Object)"destroy invoked!");
        timer.cancel();
        timer.purge();
        timer = null;
        this.policyTaskTable.clear();
        this.policyTaskTable = null;
        this.policyTable.clear();
        this.policyTable = null;
        logger.info((Object)"destroyed!");
    }

    private class PolicyTimerTask
    extends TimerTask {
        private Policy policy;
        private PolicyTask task;

        public PolicyTimerTask(Policy policy, PolicyTask task) {
            this.policy = policy;
            this.task = task;
        }

        public void run() {
            if (this.task != null) {
                logger.info((Object)(this.task.getName() + ": evaluating policy \"" + this.policy.getName() + "\"..."));
                try {
                    this.task.execute(this.policy);
                    logger.info((Object)(this.task.getName() + ": policy \"" + this.policy.getName() + "\" evaluated!"));
                }
                catch (PolicyException e) {
                    logger.info((Object)(this.task.getName() + ": policy \"" + this.policy.getName() + "\" failed with message: " + e.getMessage()));
                }
                if (this.policy.getTimeUnit() == Policy.TIME_UNIT.DATE) {
                    PolicyManager.this.policyTable.remove(this.policy.getName());
                }
            }
        }
    }
}

