/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Policy {
    private String name = null;
    private String type = null;
    private String value = null;
    private Calendar date = null;
    private TIME_UNIT timeUnit = null;
    private int timeValue = 0;

    public Policy(String name, String type, String value, Calendar date) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name not specified!");
        }
        if (type == null) {
            throw new IllegalArgumentException("type not specified!");
        }
        if (value == null) {
            throw new IllegalArgumentException("value not specified!");
        }
        if (date == null) {
            throw new IllegalArgumentException("date not specified!");
        }
        this.name = name;
        this.type = type;
        this.value = value;
        this.date = date;
        this.timeUnit = TIME_UNIT.DATE;
    }

    public Policy(String name, String type, String value, int timeValue, TIME_UNIT timeUnit) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name not specified!");
        }
        if (type == null) {
            throw new IllegalArgumentException("type not specified!");
        }
        if (value == null) {
            throw new IllegalArgumentException("value not specified!");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeField not specified!");
        }
        this.name = name;
        this.type = type;
        this.value = value;
        this.timeValue = Math.abs(timeValue);
        this.timeUnit = timeUnit;
        this.date = new GregorianCalendar();
        this.date.roll(timeUnit.getTimeUnit(), timeValue);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Policy)) {
            return false;
        }
        Policy policy = (Policy)obj;
        return this.name.equals(policy.name) && this.value.equals(policy.value) && this.type.equals(policy.type) && this.date.equals(policy.date);
    }

    public Calendar getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public TIME_UNIT getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeValue() {
        return this.timeValue;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TIME_UNIT {
        SECOND(13),
        MINUTE(12),
        HOUR(10),
        DAY(6),
        MONTH(2),
        YEAR(1),
        DATE(5);

        int field;

        private TIME_UNIT(int field) {
            this.field = field;
        }

        public int getTimeUnit() {
            return this.field;
        }
    }
}

