/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement;

import org.apache.log4j.Logger;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorInterface;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueException;

final class CommandWorker
extends Thread {
    private static final Logger logger = Logger.getLogger((String)CommandWorker.class.getName());
    private CommandExecutorInterface executor = null;
    private boolean isProcessing = false;
    private boolean exit = false;

    public CommandWorker(CommandExecutorInterface executor, int id) {
        super("WorkerThread_" + executor.getName() + "_" + id);
        this.setDaemon(true);
        this.setName("WorkerThread_" + executor.getName() + "_" + id);
        this.executor = executor;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public void terminate() {
        logger.info((Object)("terminate invoked for " + this.getName()));
        this.exit = true;
    }

    public void run() {
        Command command = null;
        do {
            logger.debug((Object)(this.getName() + " waiting for a task"));
            try {
                command = this.executor.getCommandQueue().take();
            }
            catch (CommandQueueException e) {
                if (e.getMessage().equals("queue closed!")) {
                    this.exit = true;
                } else {
                    logger.debug((Object)(this.getName() + " error: " + e.getMessage()), (Throwable)e);
                }
                command = null;
            }
            if (command == null || this.exit) continue;
            try {
                this.isProcessing = true;
                command.setStatus(4);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("status change for command [" + command.toString() + "]"));
                }
                this.executor.execute(command);
                command.setStatus(5);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("status change for command [" + command.toString() + "]"));
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage());
                command.setFailureReason(e.getMessage());
                command.setStatus(6);
                logger.info((Object)("status change for command [" + command.toString() + "]"));
            }
            this.isProcessing = false;
        } while (!this.exit && !this.isInterrupted());
        logger.info((Object)(this.getName() + " terminated!"));
    }
}

