/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.cmdmanagement.CommandResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
implements Comparable {
    private static final Logger logger = Logger.getLogger((String)Command.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int LOW_PRIORITY = 0;
    public static final int NORMAL_PRIORITY = 1;
    public static final int MEDIUM_PRIORITY = 2;
    public static final int HIGH_PRIORITY = 3;
    public static final int ACCEPTED = 0;
    public static final int QUEUED = 1;
    public static final int SCHEDULED = 2;
    public static final int RESCHEDULED = 3;
    public static final int EXECUTING = 4;
    public static final int EXECUTED_OK = 5;
    public static final int EXECUTED_ERROR = 6;
    public static final int ERROR = 7;
    public static final String[] statusName = new String[]{"ACCEPTED", "QUEUED", "SCHEDULED", "RESCHEDULED", "EXECUTING", "EXECUTED-OK", "EXECUTED-ERROR", "ERROR"};
    public static final String EXECUTION_MODE_SERIAL = "S";
    public static final String EXECUTION_MODE_PARALLEL = "P";
    private long queueId = 0L;
    private long id = -1L;
    private String cmdExecutorName = null;
    private String commandGroupId = null;
    private String userId = null;
    private String name = null;
    private String category = null;
    private String failureReason = null;
    private String description = null;
    private Calendar creationTime;
    private Calendar startSchedulingTime;
    private Calendar startProcessingTime;
    private Calendar executionCompletedTime;
    private Hashtable<String, Object> parameter = null;
    private boolean isAsynchronous = false;
    private int status;
    private int priorityLevel = 1;
    private CommandResult result;
    private ExecutionModeValues executionMode = ExecutionModeValues.SERIAL;

    public static String getStatusName(int type) {
        if (type < 0 || type >= statusName.length) {
            return null;
        }
        return statusName[type];
    }

    public Command() {
        this(null, null);
    }

    public Command(String name) {
        this(name, null);
    }

    public Command(String name, String category) {
        this.setName(name);
        this.setCreationTime(Calendar.getInstance());
        this.status = 0;
        this.parameter = new Hashtable(0);
        this.category = category;
    }

    public void addParameter(String key, List<String> value) {
        if (key != null && value != null) {
            if (this.parameter.containsKey(key)) {
                this.parameter.remove(key);
            }
            this.parameter.put(key.toUpperCase(), value);
        }
    }

    public void addParameter(String key, Serializable value) {
        if (key != null && value != null) {
            if (this.parameter.containsKey(key)) {
                this.parameter.remove(key);
            }
            this.parameter.put(key.toUpperCase(), value);
        }
    }

    public void addParameter(String key, Object value) {
        if (key != null && value != null) {
            if (this.parameter.containsKey(key)) {
                this.parameter.remove(key);
            }
            this.parameter.put(key.toUpperCase(), value);
        }
    }

    public boolean checkResult() {
        return this.result != null;
    }

    public void clearParameter() {
        this.parameter.clear();
    }

    public int compareTo(Object obj) {
        if (obj instanceof Command) {
            if (this.id < ((Command)obj).getId()) {
                return -1;
            }
            return this.id == ((Command)obj).getId() ? 0 : 1;
        }
        return 0;
    }

    public boolean containsParameterKey(String key) {
        return this.parameter.containsKey(key.toUpperCase());
    }

    public void deleteParameter(String key) {
        if (key != null && this.parameter.containsKey(key.toUpperCase())) {
            this.parameter.remove(key.toUpperCase());
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getCommandExecutorName() {
        return this.cmdExecutorName;
    }

    public String getCommandGroupId() {
        return this.commandGroupId;
    }

    public Calendar getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Calendar getExecutionCompletedTime() {
        return this.executionCompletedTime;
    }

    public ExecutionModeValues getExecutionMode() {
        return this.executionMode;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getParameter(String key) {
        if (key == null) {
            return null;
        }
        return this.parameter.get(key.toUpperCase());
    }

    public String getParameterAsString(String key) {
        if (key == null) {
            return null;
        }
        return (String)this.parameter.get(key.toUpperCase());
    }

    public Set<String> getParameterKeySet() {
        return this.parameter.keySet();
    }

    public List<String> getParameterMultivalue(String key) {
        if (key == null) {
            return null;
        }
        Object obj = this.parameter.get(key.toUpperCase());
        if (obj instanceof String) {
            ArrayList<String> list = new ArrayList<String>(0);
            list.add((String)obj);
            return list;
        }
        return (List)obj;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public long getQueueId() {
        return this.queueId;
    }

    public CommandResult getResult() {
        if (this.result == null) {
            this.result = new CommandResult();
        }
        return this.result;
    }

    public Calendar getStartProcessingTime() {
        return this.startProcessingTime;
    }

    public Calendar getStartSchedulingTime() {
        return this.startSchedulingTime;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusName() {
        return statusName[this.status];
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isInternal() {
        return !this.containsParameterKey("REMOTE_REQUEST_ADDRESS");
    }

    public boolean isScheduled() {
        return this.status == 2 || this.status == 3;
    }

    public boolean isSuccessfull() {
        return this.status == 5;
    }

    private Calendar readCalendar(ObjectInput in) throws IOException {
        long ts = in.readLong();
        if (ts == 0L) {
            return null;
        }
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(ts);
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setId(in.readLong());
        this.setCategory(in.readUTF());
        this.cmdExecutorName = in.readUTF();
        this.userId = in.readUTF();
        this.setName(in.readUTF());
        this.setStatus(in.readInt());
        this.setPriorityLevel(in.readInt());
        String executionModeRead = in.readUTF();
        if (EXECUTION_MODE_SERIAL.equals(executionModeRead)) {
            this.setExecutionMode(ExecutionModeValues.SERIAL);
        } else if (EXECUTION_MODE_PARALLEL.equals(executionModeRead)) {
            this.setExecutionMode(ExecutionModeValues.PARALLEL);
        } else {
            throw new IOException("ExecutionMode parameter is not correct: " + executionModeRead);
        }
        this.setCommandGroupId(in.readUTF());
        this.setFailureReason(in.readUTF());
        this.setCreationTime(this.readCalendar(in));
        this.setStartSchedulingTime(this.readCalendar(in));
        this.setStartProcessingTime(this.readCalendar(in));
        this.setExecutionCompletedTime(this.readCalendar(in));
        this.isAsynchronous = in.readBoolean();
        int htSize = in.readInt();
        this.parameter.clear();
        if (htSize >= 0) {
            for (int k = 0; k < htSize; ++k) {
                this.parameter.put(in.readUTF(), in.readObject());
            }
        }
    }

    public synchronized void setAsynchronous(boolean b) {
        this.isAsynchronous = b;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCommandExecutorName(String name) {
        this.cmdExecutorName = name;
    }

    public void setCommandGroupId(String commandGroupId) {
        this.commandGroupId = commandGroupId;
    }

    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionCompletedTime(Calendar executionCompletedTime) {
        this.executionCompletedTime = executionCompletedTime;
    }

    public void setExecutionMode(ExecutionModeValues executionMode) {
        this.executionMode = executionMode;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public void setQueueId(long queueId) {
        this.queueId = queueId;
    }

    public void setResult(CommandResult result) {
        this.result = result;
    }

    public void setStartProcessingTime(Calendar startProcessingTime) {
        this.startProcessingTime = startProcessingTime;
    }

    public void setStartSchedulingTime(Calendar startSchedulingTime) {
        this.startSchedulingTime = startSchedulingTime;
    }

    public void setStatus(int newStatus) {
        if (newStatus < 0 || newStatus >= statusName.length) {
            return;
        }
        this.status = newStatus;
        switch (this.status) {
            case 2: {
                this.startSchedulingTime = Calendar.getInstance();
                this.startProcessingTime = null;
                this.executionCompletedTime = null;
                break;
            }
            case 4: {
                this.startProcessingTime = Calendar.getInstance();
                this.executionCompletedTime = null;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.executionCompletedTime = Calendar.getInstance();
            }
        }
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        if (this.id != -1L) {
            info.append("ID=").append(this.id).append("; ");
        }
        info.append("NAME=\"").append(this.name).append("\"");
        info.append("; PRIORITY_LEVEL=").append(this.priorityLevel);
        info.append("; IS_ASYNCHRONOUS=").append(this.isAsynchronous);
        info.append("; STATUS=").append(statusName[this.status]);
        if (this.failureReason != null) {
            info.append("; FAILURE_REASON=\"").append(this.failureReason).append("\"");
        }
        if (this.category != null) {
            info.append("; CATEGORY=\"").append(this.category).append("\"");
        }
        if (this.cmdExecutorName != null) {
            info.append("; EXECUTOR_NAME=\"").append(this.cmdExecutorName).append("\"");
        }
        if (this.userId != null) {
            info.append("; USER_ID=\"").append(this.userId).append("\"");
        }
        if (this.description != null) {
            info.append("; DESCRIPTION=\"").append(this.description).append("\"");
        }
        if (this.creationTime != null) {
            info.append("; CREATION_TIME=\"").append(this.creationTime.getTime()).append("\"");
        }
        if (this.startProcessingTime != null) {
            info.append("; START_PROCESSING_TIME=\"").append(this.startProcessingTime.getTime()).append("\"");
        }
        if (this.executionCompletedTime != null) {
            info.append("; EXECUTION_COMPLETED_TIME=\"").append(this.executionCompletedTime.getTime()).append("\"");
        }
        Object parameterValue = null;
        for (String key : this.parameter.keySet()) {
            List list;
            if (key.startsWith("DELEGATION_") && !key.endsWith("_ID")) continue;
            parameterValue = this.parameter.get(key);
            if (parameterValue instanceof String) {
                if (((String)parameterValue).length() >= 100) continue;
                info.append("; ").append(key).append("=\"").append(parameterValue).append("\"");
                continue;
            }
            if (!(parameterValue instanceof List) || (list = (List)parameterValue).size() <= 0 || !(list.get(0) instanceof String)) continue;
            info.append("; ").append(key).append("={ ");
            for (String value : list) {
                info.append(value).append("; ");
            }
            info.replace(info.length() - 2, info.length(), " }");
        }
        return info.toString();
    }

    private void writeCalendar(ObjectOutput out, Calendar cal) throws IOException {
        out.writeLong(cal != null ? cal.getTimeInMillis() : 0L);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.getId());
        this.writeString(out, this.getCategory());
        this.writeString(out, this.cmdExecutorName);
        this.writeString(out, this.userId);
        this.writeString(out, this.getName());
        out.writeInt(this.status);
        out.writeInt(this.getPriorityLevel());
        this.writeString(out, this.getExecutionMode().getStringValue());
        this.writeString(out, this.getCommandGroupId());
        this.writeString(out, this.getFailureReason());
        this.writeCalendar(out, this.getCreationTime());
        this.writeCalendar(out, this.getStartSchedulingTime());
        this.writeCalendar(out, this.getStartProcessingTime());
        this.writeCalendar(out, this.getExecutionCompletedTime());
        out.writeBoolean(this.isAsynchronous);
        if (this.parameter != null) {
            out.writeInt(this.parameter.size());
            for (String key : this.parameter.keySet()) {
                out.writeUTF(key);
                out.writeObject(this.parameter.get(key));
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void writeString(ObjectOutput out, String s) throws IOException {
        out.writeUTF(s != null ? s : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionModeValues {
        SERIAL("S"),
        PARALLEL("P");

        private final String stringValue;

        private ExecutionModeValues(String stringValue) {
            this.stringValue = stringValue;
        }

        public boolean equals(ExecutionModeValues value) {
            if (value == null) {
                return false;
            }
            return value.getStringValue().equals(this.stringValue);
        }

        public boolean equals(String value) {
            if (value == null) {
                return false;
            }
            return value.equals(this.stringValue);
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

