/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.cmdmanagement;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.cmdmanagement.Command;
import org.glite.ce.creamapi.cmdmanagement.CommandException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorException;
import org.glite.ce.creamapi.cmdmanagement.CommandExecutorInterface;
import org.glite.ce.creamapi.cmdmanagement.CommandManagerInterface;
import org.glite.ce.creamapi.cmdmanagement.CommandWorker;
import org.glite.ce.creamapi.cmdmanagement.Parameter;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueue;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueException;
import org.glite.ce.creamapi.cmdmanagement.queue.CommandQueueInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandExecutor
implements CommandExecutorInterface {
    private static final Logger logger = Logger.getLogger((String)AbstractCommandExecutor.class.getName());
    private String name;
    private String category;
    private List<String> commands;
    private List<CommandWorker> threadPool = null;
    private CommandManagerInterface commandManager;
    private CommandQueueInterface commandQueue;
    private int commandWorkerPoolSize = 5;
    private int commandQueueSize = 500;
    private boolean commandQueueShared = false;
    private Hashtable<String, Object> parameter;
    protected ThreadGroup poolGroup = new ThreadGroup("Manager Worker Threads");
    protected String dataSourceName = null;

    protected AbstractCommandExecutor(String name, String category) throws CommandExecutorException {
        this(name, category, null);
    }

    protected AbstractCommandExecutor(String name, String category, List<String> commands) throws CommandExecutorException {
        if (name == null || name.length() == 0) {
            logger.error((Object)"command executor's name not specified!");
        }
        if (category == null || category.length() == 0) {
            logger.error((Object)"command executor's category not specified!");
        }
        this.name = name;
        this.category = category;
        this.commands = commands;
        this.parameter = new Hashtable(0);
    }

    @Override
    public void addParameter(Parameter parameter) {
        if (parameter != null) {
            this.addParameter(parameter.getName(), parameter.getValue());
        }
    }

    @Override
    public void addParameter(List<Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    @Override
    public void addParameter(String key, Object value) {
        if (key != null && value != null) {
            this.parameter.put(key, value);
        }
    }

    @Override
    public boolean checkCommandSupport(String name) {
        if (name == null || this.commands == null) {
            return false;
        }
        for (String cmdName : this.commands) {
            if (!cmdName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsParameterKey(String key) {
        if (key == null) {
            return false;
        }
        return this.parameter.containsKey(key);
    }

    @Override
    public void destroy() {
        logger.info((Object)("destroying the " + this.name + " executor..."));
        if (this.commandQueue != null) {
            this.commandQueue.close();
            do {
                for (int i = 0; i < this.threadPool.size(); ++i) {
                    if (this.threadPool.get(i).isProcessing() || this.threadPool.get(i).isInterrupted()) continue;
                    this.threadPool.get(i).terminate();
                    this.threadPool.remove(i);
                }
            } while (this.threadPool.size() > 0);
            this.threadPool.clear();
        }
        this.threadPool = null;
        this.commandQueue = null;
        this.commandManager = null;
        logger.info((Object)("executor " + this.name + " destroyed!"));
    }

    @Override
    public abstract void execute(Command var1) throws CommandExecutorException, CommandException;

    @Override
    public abstract void execute(List<Command> var1) throws CommandExecutorException, CommandException;

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public CommandManagerInterface getCommandManager() {
        return this.commandManager;
    }

    @Override
    public CommandQueueInterface getCommandQueue() {
        return this.commandQueue;
    }

    @Override
    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public int getCommandWorkerPoolSize() {
        return this.commandWorkerPoolSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Parameter getParameter(String key) {
        if (key != null) {
            return new Parameter(key, this.parameter.get(key));
        }
        return null;
    }

    public Set<String> getParameterKeySet() {
        return this.parameter.keySet();
    }

    @Override
    public List<Parameter> getParameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>(this.parameter.size());
        for (String key : this.parameter.keySet()) {
            list.add(new Parameter(key, this.parameter.get(key)));
        }
        return list;
    }

    @Override
    public Object getParameterValue(String key) {
        if (key != null) {
            return this.parameter.get(key);
        }
        return null;
    }

    @Override
    public String getParameterValueAsString(String key) {
        if (key != null) {
            return (String)this.parameter.get(key);
        }
        return null;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setCommandManager(CommandManagerInterface cmdManager) {
        this.commandManager = cmdManager;
    }

    @Override
    public void setCommands(List<String> cmd) {
        this.commands = cmd;
    }

    @Override
    public void setCommandQueueShared(boolean isShared) {
        this.commandQueueShared = isShared;
    }

    @Override
    public void setCommandQueueSize(int size) {
        if (size <= 0) {
            logger.warn((Object)("queueSize <= 0, using the default value (" + this.commandQueueSize + ")"));
        } else {
            this.commandQueueSize = size;
        }
    }

    @Override
    public void setCommandWorkerPoolSize(int size) {
        if (size < 0) {
            logger.warn((Object)("commandWorkerPoolSize <= 0, using the default value (" + this.commandWorkerPoolSize + ")"));
        } else if (size == 0) {
            this.commandWorkerPoolSize = size;
            logger.info((Object)"commandWorkerPoolSize = 0, queue disabled!");
        } else {
            this.commandWorkerPoolSize = size;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameter(List<Parameter> parameters) {
        if (this.parameter == null) {
            return;
        }
        this.parameter.clear();
        for (Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    @Override
    public void start() throws CommandExecutorException {
        logger.info((Object)("starting the " + this.name + " commandExecutor"));
        if (this.commandWorkerPoolSize > 0) {
            try {
                this.commandQueue = new CommandQueue(this.dataSourceName, this.commandQueueSize);
                this.commandQueue.setShared(this.commandQueueShared);
                this.commandQueue.open();
            }
            catch (CommandQueueException e) {
                logger.error((Object)("cannot create the queue for the " + this.name + " commandExecutor: " + e.getMessage()));
                throw new CommandExecutorException(e.getMessage());
            }
            this.threadPool = new ArrayList<CommandWorker>(this.commandWorkerPoolSize);
            CommandWorker cw = null;
            for (int i = 0; i < this.commandWorkerPoolSize; ++i) {
                cw = new CommandWorker(this, i);
                cw.start();
                this.threadPool.add(cw);
            }
        }
        logger.info((Object)(this.name + " commandExecutor started successfully"));
    }
}

