/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.activitymanagement.wrapper.adl;

import java.util.ArrayList;
import java.util.List;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.CreationFlagEnumeration;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;
import org.glite.ce.creamapi.ws.es.adl.Target_type0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    protected String uri;
    protected String delegationID;
    protected List<OptionType> option;
    protected Boolean mandatory;
    protected CreationFlagEnumeration creationFlag;
    protected Boolean useIfFailure;
    protected Boolean useIfCancel;
    protected Boolean useIfSuccess;

    public Target() {
    }

    public Target(Target_type0 target) {
        if (target != null) {
            this.delegationID = target.getDelegationID();
            if (target.getOption() != null && target.getOption().length > 0) {
                this.option = this.getOption();
                OptionType optionType = null;
                for (int i = 0; i < target.getOption().length; ++i) {
                    optionType = new OptionType();
                    optionType.setName(target.getOption()[i].getName());
                    optionType.setValue(target.getOption()[i].getValue());
                    this.option.add(optionType);
                }
            }
            this.mandatory = target.isMandatorySpecified() ? target.getMandatory() : false;
            if (target.getURI() != null) {
                this.uri = target.getURI().toString();
            }
            this.useIfCancel = target.isUseIfCancelSpecified() ? target.getUseIfCancel() : false;
            this.useIfFailure = target.isUseIfFailureSpecified() ? target.getUseIfFailure() : false;
            this.useIfSuccess = target.isUseIfSuccessSpecified() ? target.getUseIfSuccess() : true;
            this.creationFlag = target.isCreationFlagSpecified() ? CreationFlagEnumeration.fromValue(target.getCreationFlag().getValue()) : CreationFlagEnumeration.OVERWRITE;
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String value) {
        this.uri = value;
    }

    public String getDelegationID() {
        return this.delegationID;
    }

    public void setDelegationID(String value) {
        this.delegationID = value;
    }

    public List<OptionType> getOption() {
        if (this.option == null) {
            this.option = new ArrayList<OptionType>();
        }
        return this.option;
    }

    public Boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean value) {
        this.mandatory = value;
    }

    public CreationFlagEnumeration getCreationFlag() {
        return this.creationFlag;
    }

    public void setCreationFlag(CreationFlagEnumeration value) {
        this.creationFlag = value;
    }

    public Boolean isUseIfFailure() {
        return this.useIfFailure;
    }

    public void setUseIfFailure(Boolean value) {
        this.useIfFailure = value;
    }

    public Boolean isUseIfCancel() {
        return this.useIfCancel;
    }

    public void setUseIfCancel(Boolean value) {
        this.useIfCancel = value;
    }

    public Boolean isUseIfSuccess() {
        return this.useIfSuccess;
    }

    public void setUseIfSuccess(Boolean value) {
        this.useIfSuccess = value;
    }
}

