/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.activitymanagement.wrapper.adl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.ExecutableType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.Notification;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionType;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionalDuration;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.OptionalTime;
import org.glite.ce.creamapi.activitymanagement.wrapper.adl.RemoteLogging;
import org.glite.ce.creamapi.ws.es.adl.Application_type0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static final Logger logger = Logger.getLogger((String)Application.class.getName());
    protected ExecutableType executable;
    protected String input;
    protected String output;
    protected String error;
    protected List<OptionType> environment;
    protected List<ExecutableType> preExecutable;
    protected List<ExecutableType> postExecutable;
    protected List<RemoteLogging> remoteLogging;
    protected OptionalTime expirationTime;
    protected OptionalDuration wipeTime;
    protected List<Notification> notification;

    public Application() {
    }

    public Application(Application_type0 application_type0) {
        if (application_type0.getExecutable() != null) {
            this.executable = new ExecutableType(application_type0.getExecutable());
        }
        this.input = application_type0.getInput();
        this.output = application_type0.getOutput();
        this.error = application_type0.getError();
        if (application_type0.getEnvironment() != null && application_type0.getEnvironment().length > 0) {
            this.environment = this.getEnvironment();
            OptionType optionType = null;
            for (int i = 0; i < application_type0.getEnvironment().length; ++i) {
                if (application_type0.getEnvironment()[i] == null) continue;
                optionType = new OptionType();
                optionType.setName(application_type0.getEnvironment()[i].getName());
                optionType.setValue(application_type0.getEnvironment()[i].getValue());
                this.environment.add(optionType);
            }
        }
        if (application_type0.getPreExecutable() != null && application_type0.getPreExecutable().length > 0) {
            this.preExecutable = this.getPreExecutable();
            for (int i = 0; i < application_type0.getPreExecutable().length; ++i) {
                if (application_type0.getPreExecutable()[i] == null) continue;
                this.preExecutable.add(new ExecutableType(application_type0.getPreExecutable()[i]));
            }
        }
        if (application_type0.getPostExecutable() != null && application_type0.getPostExecutable().length > 0) {
            this.postExecutable = this.getPostExecutable();
            for (int i = 0; i < application_type0.getPostExecutable().length; ++i) {
                if (application_type0.getPostExecutable()[i] == null) continue;
                this.postExecutable.add(new ExecutableType(application_type0.getPostExecutable()[i]));
            }
        }
        if (application_type0.getRemoteLogging() != null && application_type0.getRemoteLogging().length > 0) {
            this.remoteLogging = this.getRemoteLogging();
            for (int i = 0; i < application_type0.getRemoteLogging().length; ++i) {
                if (application_type0.getRemoteLogging()[i] == null) continue;
                this.remoteLogging.add(new RemoteLogging(application_type0.getRemoteLogging()[i]));
            }
        }
        if (application_type0.getExpirationTime() != null) {
            this.expirationTime = new OptionalTime();
            this.expirationTime.setOptional(application_type0.getExpirationTime().getOptional());
            this.expirationTime.setValue(Application.getXMLGregorianCalendar(application_type0.getExpirationTime().getDateTime()));
        }
        if (application_type0.getWipeTime() != null) {
            this.wipeTime = new OptionalDuration();
            this.wipeTime.setOptional(application_type0.getWipeTime().getOptional());
            if (application_type0.getWipeTime().getDateTime() != null) {
                try {
                    this.wipeTime.setValue(DatatypeFactory.newInstance().newDurationDayTime(application_type0.getWipeTime().getDateTime().getTimeInMillis()));
                }
                catch (DatatypeConfigurationException e) {
                    logger.warn((Object)"Error setting duration for wipeTime.");
                }
            }
        }
        if (application_type0.getNotification() != null && application_type0.getNotification().length > 0) {
            this.notification = this.getNotification();
            for (int i = 0; i < application_type0.getNotification().length; ++i) {
                if (application_type0.getNotification()[i] == null) continue;
                this.notification.add(new Notification(application_type0.getNotification()[i]));
            }
        }
    }

    public ExecutableType getExecutable() {
        return this.executable;
    }

    public void setExecutable(ExecutableType value) {
        this.executable = value;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String value) {
        this.input = value;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String value) {
        this.output = value;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String value) {
        this.error = value;
    }

    public List<OptionType> getEnvironment() {
        if (this.environment == null) {
            this.environment = new ArrayList<OptionType>();
        }
        return this.environment;
    }

    public List<ExecutableType> getPreExecutable() {
        if (this.preExecutable == null) {
            this.preExecutable = new ArrayList<ExecutableType>();
        }
        return this.preExecutable;
    }

    public List<ExecutableType> getPostExecutable() {
        if (this.postExecutable == null) {
            this.postExecutable = new ArrayList<ExecutableType>();
        }
        return this.postExecutable;
    }

    public List<RemoteLogging> getRemoteLogging() {
        if (this.remoteLogging == null) {
            this.remoteLogging = new ArrayList<RemoteLogging>();
        }
        return this.remoteLogging;
    }

    public OptionalTime getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(OptionalTime value) {
        this.expirationTime = value;
    }

    public OptionalDuration getWipeTime() {
        return this.wipeTime;
    }

    public void setWipeTime(OptionalDuration value) {
        this.wipeTime = value;
    }

    public List<Notification> getNotification() {
        if (this.notification == null) {
            this.notification = new ArrayList<Notification>();
        }
        return this.notification;
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(Calendar calendar) {
        XMLGregorianCalendar xmlGregorianCalendar = null;
        if (calendar != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
            try {
                xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.warn((Object)ex.getMessage());
            }
        }
        return xmlGregorianCalendar;
    }
}

