/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.creamapi.activitymanagement;

import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStatus
implements Comparable<ActivityStatus> {
    private long id = 0L;
    private Boolean isTransient = Boolean.FALSE;
    private String description;
    private StatusName statusName = null;
    private List<StatusAttributeName> statusAttributes;
    private XMLGregorianCalendar timestamp = null;

    public ActivityStatus() {
        this(null);
    }

    public ActivityStatus(StatusName statusName) {
        this.statusName = statusName;
    }

    @Override
    public int compareTo(ActivityStatus status) {
        if (status == null) {
            return -1;
        }
        int result = this.statusName.compareTo(status.getStatusName());
        if (result == 0) {
            if (this.statusName == StatusName.TERMINAL && this.description.indexOf(status.getDescription()) < 0) {
                this.description = this.description.concat("; ").concat(status.getDescription());
            }
            if ((result = this.timestamp.compare(status.getTimestamp())) == 0) {
                result = this.getStatusAttributes().size() < status.getStatusAttributes().size() ? -1 : (this.getStatusAttributes().size() > status.getStatusAttributes().size() ? 1 : (this.statusAttributes.containsAll(status.getStatusAttributes()) ? 0 : -1));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean areEqual;
        if (obj == null || !(obj instanceof ActivityStatus)) {
            return false;
        }
        ActivityStatus activityStatus = (ActivityStatus)obj;
        boolean bl = areEqual = this.statusName.equals((Object)activityStatus.getStatusName()) && this.timestamp.compare(activityStatus.getTimestamp()) == 0;
        if (areEqual) {
            areEqual = this.statusAttributes != null && activityStatus.getStatusAttributes() != null && this.statusAttributes.size() == activityStatus.getStatusAttributes().size() && this.statusAttributes.containsAll(activityStatus.getStatusAttributes());
        }
        return areEqual;
    }

    public List<StatusAttributeName> getStatusAttributes() {
        if (this.statusAttributes == null) {
            this.statusAttributes = new ArrayList<StatusAttributeName>(0);
        }
        return this.statusAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    public StatusName getStatusName() {
        return this.statusName;
    }

    public XMLGregorianCalendar getTimestamp() {
        return this.timestamp;
    }

    public Boolean isTransient() {
        return this.isTransient;
    }

    public void setStatusAttributes(List<StatusAttributeName> statusAttributes) {
        this.statusAttributes = statusAttributes;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIsTransient(Boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setStatusName(StatusName statusName) {
        this.statusName = statusName;
    }

    public void setTimestamp(XMLGregorianCalendar timestamp) {
        if (timestamp != null) {
            timestamp.setMillisecond(0);
        }
        this.timestamp = timestamp;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("statusName=").append(this.statusName.getName());
        info.append("; timestamp=").append(this.timestamp.toGregorianCalendar().getTime());
        if (this.description != null) {
            info.append("; description=").append(this.description);
        }
        if (this.statusAttributes != null && this.statusAttributes.size() > 0) {
            info.append("; attributes={");
            for (StatusAttributeName attribute : this.statusAttributes) {
                info.append(attribute.getName()).append(", ");
            }
            info = info.delete(info.length() - 2, info.length());
            info.append("}");
        }
        return info.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusName {
        ACCEPTED("accepted"),
        POSTPROCESSING("postprocessing"),
        PREPROCESSING("preprocessing"),
        PROCESSING("processing"),
        PROCESSING_ACCEPTING("processing-accepting"),
        PROCESSING_QUEUED("processing-queued"),
        PROCESSING_RUNNING("processing-running"),
        TERMINAL("terminal");

        private String name;

        private StatusName(String name) {
            this.name = name;
        }

        public static StatusName fromValue(String name) {
            StatusName[] statusName = StatusName.values();
            for (int i = 0; i < statusName.length; ++i) {
                if (!statusName[i].getName().equals(name)) continue;
                return statusName[i];
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusAttributeName {
        APP_FAILURE("app-failure"),
        APP_RUNNING("app-running"),
        BATCH_SUSPEND("batch-suspend"),
        CLIENT_PAUSED("client-paused"),
        CLIENT_STAGEIN_POSSIBLE("client-stagein-possible"),
        CLIENT_STAGEOUT_POSSIBLE("client-stageout-possible"),
        DEPROVISIONING("deprovisioning"),
        EXPIRED("expired"),
        POSTPROCESSING_CANCEL("postprocessing-cancel"),
        POSTPROCESSING_FAILURE("postprocessing-failure"),
        PREPROCESSING_CANCEL("preprocessing-cancel"),
        PREPROCESSING_FAILURE("preprocessing-failure"),
        PROCESSING_CANCEL("processing-cancel"),
        PROCESSING_FAILURE("processing-failure"),
        PROVISIONING("provisioning"),
        SERVER_PAUSED("server-paused"),
        SERVER_STAGEIN("server-stagein"),
        SERVER_STAGEOUT("server-stageout"),
        VALIDATING("validating"),
        VALIDATION_FAILURE("validation-failure");

        private String name;

        private StatusAttributeName(String name) {
            this.name = name;
        }

        public static StatusAttributeName fromValue(String name) {
            StatusAttributeName[] statusAttributeName = StatusAttributeName.values();
            for (int i = 0; i < statusAttributeName.length; ++i) {
                if (!statusAttributeName[i].getName().equals(name)) continue;
                return statusAttributeName[i];
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

