/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.unittest.TLAttributes;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelAttrsConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)TopLevelAttrsConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/@*";
    private XPathExpression expr;
    private TLAttributes currentAttrs;
    private TLAttributes tmpAttrs;

    public TopLevelAttrsConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currentAttrs = null;
        this.tmpAttrs = null;
    }

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Class<?> getCategory() {
        return TLAttributes.class;
    }

    public Object[] getConfigurationElement() {
        if (this.currentAttrs != null) {
            Object[] result = new Object[]{this.currentAttrs};
            return result;
        }
        return null;
    }

    public boolean process(NodeList parsedElements) {
        String tmpID = "";
        String tmpCode = "";
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            Attr attribute = (Attr)parsedElements.item(k);
            if (attribute.getName() == "id") {
                tmpID = attribute.getValue();
                continue;
            }
            if (attribute.getName() != "code") continue;
            tmpCode = attribute.getValue();
        }
        this.tmpAttrs = new TLAttributes(tmpID, tmpCode);
        logger.debug((Object)("Commit TLAttributes: " + !this.tmpAttrs.equals(this.currentAttrs)));
        return !this.tmpAttrs.equals(this.currentAttrs);
    }

    public boolean processTriggers() {
        return false;
    }

    public void commit() {
        this.currentAttrs = this.tmpAttrs;
        this.tmpAttrs = null;
    }

    public void rollback() {
        this.tmpAttrs = null;
    }

    public File[] getTriggers() {
        return null;
    }

    public void clean() {
    }
}

