/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.glite.ce.commonj.configuration.xppm.ConfigurationEvent;
import org.glite.ce.commonj.configuration.xppm.ConfigurationListener;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.commonj.configuration.xppm.unittest.ConfigFile;
import org.glite.ce.commonj.configuration.xppm.unittest.FailureElement;
import org.glite.ce.commonj.configuration.xppm.unittest.GenericConfigListener;
import org.glite.ce.commonj.configuration.xppm.unittest.LogUtils;
import org.glite.ce.commonj.configuration.xppm.unittest.MockElement;
import org.glite.ce.commonj.configuration.xppm.unittest.SimpleElement;
import org.glite.ce.commonj.configuration.xppm.unittest.TLAttributes;

public class TestNotificationManager
extends TestCase {
    private static Logger logger = Logger.getLogger((String)TestNotificationManager.class.getName());
    private ConfigFile confFile = new ConfigFile();
    private GenericConfigListener listener = new GenericConfigListener();

    public TestNotificationManager(String name) {
        super(name);
        LogUtils.setup();
    }

    protected void setUp() throws Exception {
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new FailureElement(false, "failure content")};
        this.confFile.write(attributes, elements, false);
        this.listener.reset();
    }

    protected void tearDown() {
        this.confFile.delete();
    }

    public void testNotificationAtStartup() throws Exception {
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{this.listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 10000L, lsnrs);
        Thread.sleep(6000L);
        boolean result = true;
        for (ConfigurationEvent event : this.listener) {
            if (event.getType() == 0) continue;
            result = false;
            break;
        }
        TestNotificationManager.assertTrue((boolean)result);
    }

    public void testNotificationForInsert() throws Exception {
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{this.listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 3000L, lsnrs);
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new FailureElement(false, "failure content")};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(6000L);
        ConfigurationEvent lastEvn = this.listener.getLastEvent();
        logger.debug((Object)("Last event category " + lastEvn.getCategory().getName()));
        boolean result = lastEvn != null;
        result &= lastEvn.getCategory() == SimpleElement.class;
        TestNotificationManager.assertTrue((boolean)(result &= lastEvn.getType() == 0));
    }

    public void testNotificationForUpdate() throws Exception {
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{this.listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 3000L, lsnrs);
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new FailureElement(false, "new failure content")};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(6000L);
        ConfigurationEvent lastEvn = this.listener.getLastEvent();
        logger.debug((Object)("Last event category " + lastEvn.getCategory().getName()));
        boolean result = lastEvn != null;
        result &= lastEvn.getCategory() == FailureElement.class;
        TestNotificationManager.assertTrue((boolean)(result &= lastEvn.getType() == 1));
    }

    public void testNotificationForRemove() throws Exception {
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{this.listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 3000L, lsnrs);
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(6000L);
        ConfigurationEvent lastEvn = this.listener.getLastEvent();
        logger.debug((Object)("Last event category " + lastEvn.getCategory().getName()));
        boolean result = lastEvn != null;
        result &= lastEvn.getCategory() == FailureElement.class;
        TestNotificationManager.assertTrue((boolean)(result &= lastEvn.getType() == 2));
    }

    public void testShutdown() throws Exception {
        ConfigurationListener[] lsnrs = new ConfigurationListener[]{this.listener};
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename(), 3000L, lsnrs);
        LogUtils.startCollect(ConfigurationManager.class.getName(), "ConfigurationNotifier halted");
        Thread.sleep(1000L);
        long ts = System.currentTimeMillis();
        cMan.shutdown();
        Thread.sleep(5000L);
        LoggingEvent[] collectedEvents = LogUtils.getLoggerSnapshot();
        if (collectedEvents.length == 0) {
            TestNotificationManager.fail((String)"No shutdown event logged");
            return;
        }
        long shutdownTime = collectedEvents[0].timeStamp - ts;
        TestNotificationManager.assertTrue((shutdownTime < 1000L ? 1 : 0) != 0);
    }
}

