/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.glite.ce.commonj.configuration.xppm.unittest.ConfigFile;
import org.glite.ce.commonj.configuration.xppm.unittest.FailureElement;
import org.glite.ce.commonj.configuration.xppm.unittest.LogUtils;
import org.glite.ce.commonj.configuration.xppm.unittest.MockElement;
import org.glite.ce.commonj.configuration.xppm.unittest.SimpleElement;
import org.glite.ce.commonj.configuration.xppm.unittest.TLAttributes;

public class TestConfigurationManager
extends TestCase {
    private static Logger logger = Logger.getLogger((String)TestConfigurationManager.class.getName());
    private ConfigFile confFile = new ConfigFile();

    public TestConfigurationManager(String name) {
        super(name);
        LogUtils.setup();
    }

    protected void setUp() throws Exception {
        TLAttributes attributes = new TLAttributes("id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new FailureElement(false, "failure content")};
        this.confFile.write(attributes, elements, false);
    }

    protected void tearDown() {
        this.confFile.delete();
    }

    public void testReadSimpleConfigElement() throws Exception {
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(SimpleElement.class);
        if (tmpo.length > 0) {
            SimpleElement sElement = (SimpleElement)tmpo[0];
            TestConfigurationManager.assertTrue((sElement.value.equals("myattr") && sElement.content.trim().equals("mycontent") ? 1 : 0) != 0);
        } else {
            TestConfigurationManager.fail((String)"Missing simple element");
        }
        TestConfigurationManager.assertTrue((boolean)true);
    }

    public void testTopLevelAttribute() throws Exception {
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length > 0) {
            TLAttributes attrs = (TLAttributes)tmpo[0];
            TestConfigurationManager.assertTrue((boolean)attrs.id.equals("id-value"));
        } else {
            TestConfigurationManager.fail((String)"Missing attribute id");
        }
    }

    public void testAttributeReloading() throws Exception {
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
            return;
        }
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("new-id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new FailureElement(false, "failure content")};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(6000L);
        tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
        } else {
            TLAttributes attrs = (TLAttributes)tmpo[0];
            TestConfigurationManager.assertTrue((boolean)attrs.id.equals("new-id-value"));
        }
    }

    public void testParserErrorOnReloading() throws Exception {
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
            return;
        }
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("new-id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new FailureElement(false, "failure content")};
        this.confFile.write(attributes, elements, true);
        Thread.sleep(6000L);
        tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
        } else {
            TLAttributes attrs = (TLAttributes)tmpo[0];
            TestConfigurationManager.assertTrue((boolean)attrs.id.equals("id-value"));
        }
    }

    public void testAttributeOnRollBack() throws Exception {
        ConfigurationManager cMan = new ConfigurationManager(this.confFile.getFilename());
        Object[] tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
            return;
        }
        Thread.sleep(6000L);
        TLAttributes attributes = new TLAttributes("new-id-value", "code-value");
        MockElement[] elements = new MockElement[]{new SimpleElement("myattr", "mycontent"), new FailureElement(true, "failure content")};
        this.confFile.write(attributes, elements, false);
        Thread.sleep(6000L);
        tmpo = cMan.getConfigurationElements(TLAttributes.class);
        if (tmpo.length == 0) {
            TestConfigurationManager.fail((String)"Missing attribute id");
        } else {
            TLAttributes attrs = (TLAttributes)tmpo[0];
            TestConfigurationManager.assertTrue((boolean)attrs.id.equals("id-value"));
        }
    }
}

