/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggingEvent;
import org.glite.ce.commonj.configuration.xppm.unittest.RegexCollectorAppender;

public class LogUtils {
    private static boolean initialized = false;

    public static void setup() {
        if (!initialized) {
            Properties props = new Properties();
            props.put("log4j.rootLogger", "debug, fileout");
            props.put("log4j.logger.org.glite.ce.commonj.configuration.xppm.ConfigurationManager", "debug, regexcollector");
            props.put("log4j.appender.regexcollector", "org.glite.ce.commonj.configuration.xppm.unittest.RegexCollectorAppender");
            props.put("log4j.appender.fileout", "org.apache.log4j.RollingFileAppender");
            props.put("log4j.appender.fileout.File", System.getProperty("log4j.output.file", "/tmp/testsuite.log"));
            props.put("log4j.appender.fileout.MaxFileSize", "10000KB");
            props.put("log4j.appender.fileout.MaxBackupIndex", "100");
            props.put("log4j.appender.fileout.layout", "org.apache.log4j.PatternLayout");
            String formatStr = "%d{dd MMM yyyy HH:mm:ss,SSS} %-5p %c (%F:%L) - (%t) %m%n";
            props.put("log4j.appender.fileout.layout.ConversionPattern", formatStr);
            PropertyConfigurator.configure((Properties)props);
            initialized = true;
        }
    }

    public static void startCollect(String loggerName, String regex) {
        RegexCollectorAppender.addPattern(loggerName, regex);
    }

    public static LoggingEvent[] getLoggerSnapshot() {
        RegexCollectorAppender.resetPatternTable();
        return RegexCollectorAppender.getCollectedEvents();
    }
}

