/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.unittest.FailureElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailureElementConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)FailureElementConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/failure";
    private XPathExpression expr;
    private FailureElement[] currentElements;
    private FailureElement[] tmpElements;

    public FailureElementConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currentElements = null;
        this.tmpElements = null;
    }

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Class<?> getCategory() {
        return FailureElement.class;
    }

    public Object[] getConfigurationElement() {
        return this.currentElements;
    }

    public boolean process(NodeList parsedElements) throws CommonConfigException {
        ArrayList<FailureElement> tmpList = new ArrayList<FailureElement>();
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            Element fElem = (Element)parsedElements.item(k);
            String tmps = fElem.getAttribute("fail");
            if (tmps.equalsIgnoreCase("true")) {
                logger.info((Object)"Simulating a parsing error");
                throw new CommonConfigException("Error parsing failure element");
            }
            FailureElement item = new FailureElement(false, fElem.getTextContent());
            logger.debug((Object)("Found element " + item.content));
            tmpList.add(item);
        }
        this.tmpElements = new FailureElement[tmpList.size()];
        tmpList.toArray(this.tmpElements);
        if (this.currentElements == null || this.currentElements.length != this.tmpElements.length) {
            logger.debug((Object)"Commit FailureElement list: true");
            return true;
        }
        boolean result = false;
        for (int k = 0; k < this.tmpElements.length; ++k) {
            result |= !this.tmpElements[k].equals(this.currentElements[k]);
        }
        logger.debug((Object)("Commit FailureElement list: " + result));
        return result;
    }

    public boolean processTriggers() {
        return false;
    }

    public void commit() {
        this.currentElements = this.tmpElements;
        this.tmpElements = null;
    }

    public void rollback() {
        this.tmpElements = null;
    }

    public File[] getTriggers() {
        return null;
    }

    public void clean() {
    }
}

