/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.glite.security.delegation.GrDPConstants;
import org.glite.security.delegation.GrDPX509Util;
import org.glite.security.delegation.GrDProxyDlgeeOptions;
import org.glite.security.delegation.storage.GrDPStorage;
import org.glite.security.delegation.storage.GrDPStorageCacheElement;
import org.glite.security.delegation.storage.GrDPStorageElement;
import org.glite.security.delegation.storage.GrDPStorageException;

public class GrDPStorageFilesystem
implements GrDPStorage {
    private static Logger logger = Logger.getLogger(GrDPStorageFilesystem.class);
    private String storagePath = null;
    private String storageCachePath = null;

    public GrDPStorageFilesystem(GrDProxyDlgeeOptions dlgeeOpt) throws GrDPStorageException {
        this.storagePath = dlgeeOpt.getDlgeeStorage();
        if (this.storagePath == null) {
            logger.debug((Object)"Failed to get proxy storage path.");
            throw new GrDPStorageException("Failed to get proxy storage path.");
        }
        this.storageCachePath = this.storagePath + "/cache";
        File storageArea = new File(this.storagePath);
        File storageCacheArea = new File(this.storageCachePath);
        if (storageArea.mkdirs() && !GrDPX509Util.changeFileMode(this.storagePath, 700)) {
            throw new GrDPStorageException("Failed to update access mode (read/write for owner only) on storage area directory: '" + this.storagePath + "'");
        }
        if (storageCacheArea.mkdirs() && !GrDPX509Util.changeFileMode(this.storageCachePath, 700)) {
            throw new GrDPStorageException("Failed to update access mode (read/write for owner only) on storage area directory: '" + this.storageCachePath + "'");
        }
        if (!storageArea.exists() || !storageCacheArea.exists()) {
            throw new GrDPStorageException("Storage area or cache does not exist.");
        }
        if (!storageArea.canWrite() || !storageCacheArea.canWrite()) {
            throw new GrDPStorageException("Storage area or cache is not writable for me.");
        }
    }

    public void insertGrDPStorageCacheElement(GrDPStorageCacheElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem insertGrDPStorageCacheElement.");
        try {
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "userreq.pem", elem.getCertificateRequest().getBytes(), true);
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "userkey.pem", elem.getPrivateKey().getBytes(), true);
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "voms.attributes", GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()).getBytes(), true);
        }
        catch (IOException e) {
            logger.error((Object)"Failure while writing to filesystem.", (Throwable)e);
            throw new GrDPStorageException("Internal failure.");
        }
    }

    public void updateGrDPStorageCacheElement(GrDPStorageCacheElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem updateGrDPStorageCacheElement.");
        this.insertGrDPStorageCacheElement(elem);
    }

    public GrDPStorageCacheElement findGrDPStorageCacheElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem findGrDPStorageCacheElement.");
        logger.debug((Object)("Looking for dlg id '" + delegationID + "' and dn '" + dn + "' in cache."));
        GrDPStorageCacheElement elem = new GrDPStorageCacheElement();
        elem.setDelegationID(delegationID);
        elem.setDN(dn);
        try {
            elem.setCertificateRequest(this.readFromFile(dn, delegationID, "userreq.pem", true));
            elem.setPrivateKey(this.readFromFile(dn, delegationID, "userkey.pem", true));
            elem.setVomsAttributes(GrDPX509Util.fromStringVOMSAttrs(this.readFromFile(dn, delegationID, "voms.attributes", true)));
        }
        catch (FileNotFoundException fnfe) {
            logger.debug((Object)("Could not find entry in cache. DN '" + dn + "'; DLG ID '" + delegationID + "'."));
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)"Failure accessing filesystem.");
            throw new GrDPStorageException("Internal failure.");
        }
        return elem;
    }

    public void deleteGrDPStorageCacheElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem deleteGrDPStorageCacheElement.");
        try {
            this.removeFile(dn, delegationID, null, true);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("Could not find entry in storage. DN '" + dn + "'; DLG ID '" + delegationID + "'."));
            throw new GrDPStorageException("Failed to find credential in storage.");
        }
        catch (IOException e) {
            logger.error((Object)("Failure accessing filesystem. Exception:" + e));
            throw new GrDPStorageException("Internal Failure.");
        }
    }

    public void insertGrDPStorageElement(GrDPStorageElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem insertGrDPStorageElement.");
        try {
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "userproxy.pem", elem.getCertificate().getBytes(), false);
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "voms.attributes", GrDPX509Util.toStringVOMSAttrs(elem.getVomsAttributes()).getBytes(), false);
            this.writeToFile(elem.getDN(), elem.getDelegationID(), "termination.time", DateFormat.getDateTimeInstance(1, 1).format(elem.getTerminationTime()).getBytes(), false);
        }
        catch (IOException e) {
            logger.error((Object)"Failure while writing to filesystem.", (Throwable)e);
            throw new GrDPStorageException("Internal failure.");
        }
    }

    public void updateGrDPStorageElement(GrDPStorageElement elem) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem updateGrDPStorageElement.");
        this.insertGrDPStorageElement(elem);
    }

    public GrDPStorageElement findGrDPStorageElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem findGrDPStorageElement.");
        logger.debug((Object)("Looking for dlg id '" + delegationID + "' and dn '" + dn + "' in storage"));
        GrDPStorageElement elem = new GrDPStorageElement();
        elem.setDelegationID(delegationID);
        elem.setDN(dn);
        try {
            elem.setCertificate(this.readFromFile(dn, delegationID, "userproxy.pem", false));
            elem.setVomsAttributes(GrDPX509Util.fromStringVOMSAttrs(this.readFromFile(dn, delegationID, "voms.attributes", false)));
            Date terminationTime = null;
            try {
                terminationTime = DateFormat.getDateTimeInstance(1, 1).parse(this.readFromFile(dn, delegationID, "termination.time", false));
            }
            catch (ParseException e) {
                logger.error((Object)"Failed to parse the termination time from file. Will be null.");
            }
            elem.setTerminationTime(terminationTime);
        }
        catch (FileNotFoundException fnfe) {
            logger.debug((Object)("Could not find entry in storage. DN '" + dn + "'; DLG ID '" + delegationID + "'."));
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)("Failure accessing filesystem. Exception:" + ioe));
            throw new GrDPStorageException("Internal failure.");
        }
        return elem;
    }

    public void deleteGrDPStorageElement(String delegationID, String dn) throws GrDPStorageException {
        logger.debug((Object)"Entered GrDPStorageFilesystem deleteGrDPStorageElement.");
        try {
            this.removeFile(dn, delegationID, null, false);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)("Could not find entry in storage. DN '" + dn + "'; DLG ID '" + delegationID + "'."));
            throw new GrDPStorageException("Failed to find credential in storage.");
        }
        catch (IOException e) {
            logger.error((Object)("Failure accessing filesystem. Exception:" + e));
            throw new GrDPStorageException("Internal Failure.");
        }
    }

    private String readFromFile(String dn, String dlgID, String fileName, boolean cache) throws IOException {
        String contents = "";
        String storageArea = this.storagePath;
        if (cache) {
            storageArea = this.storageCachePath;
        }
        String dnDir = URLEncoder.encode(dn, "UTF-8");
        String filePath = storageArea + "/" + dnDir + "/" + dlgID + "/" + fileName;
        logger.debug((Object)("Reading contents from file: " + filePath));
        BufferedReader file = new BufferedReader(new FileReader(filePath));
        String tmpString = "";
        while ((tmpString = file.readLine()) != null) {
            contents = contents + tmpString + GrDPConstants.NEWLINE;
        }
        return contents;
    }

    private void writeToFile(String dn, String dlgID, String fileName, byte[] content, boolean cache) throws IOException, GrDPStorageException {
        String storageArea = this.storagePath;
        if (cache) {
            storageArea = this.storageCachePath;
        }
        String dnDir = URLEncoder.encode(dn, "UTF-8");
        String dlgDirPath = storageArea + "/" + dnDir + "/" + dlgID;
        String filePath = dlgDirPath + "/" + fileName;
        if (new File(dlgDirPath).mkdirs() && !GrDPX509Util.changeFileMode(dlgDirPath, 700)) {
            throw new GrDPStorageException("Failed to set read/write for owner only on directory '" + dlgDirPath + "'");
        }
        if (new File(filePath).createNewFile() && !GrDPX509Util.changeFileMode(filePath, 600)) {
            throw new GrDPStorageException("Failed to set read/write for owner only on file '" + filePath + "'");
        }
        logger.debug((Object)("Writing contents to file: " + filePath));
        FileOutputStream file = new FileOutputStream(filePath);
        file.write(content);
        file.close();
    }

    private void removeFile(String dn, String dlgID, String fileName, boolean cache) throws IOException {
        boolean result;
        String storageArea = this.storagePath;
        if (cache) {
            storageArea = this.storageCachePath;
        }
        String dnDir = URLEncoder.encode(dn, "UTF-8");
        String filePath = storageArea + "/" + dnDir + "/" + dlgID;
        if (fileName != null) {
            filePath = filePath + "/" + fileName;
        }
        File file = new File(filePath);
        logger.debug((Object)("File to remove: '" + filePath + "'"));
        if (file.isDirectory()) {
            logger.debug((Object)"Attempting to remove directory.");
            File[] files = file.listFiles();
            logger.debug((Object)("Num files inside: " + files.length));
            for (int i = 0; i < files.length; ++i) {
                boolean result2 = files[i].delete();
                if (result2) continue;
                throw new IOException("Failed to remove file inside directory '" + files[i].getName() + "'. Directory could/will not be removed.");
            }
        }
        if (!(result = file.delete())) {
            throw new IOException("Failed to remove file/dir '" + filePath + "'");
        }
        logger.debug((Object)("Successfully removed file/dir '" + filePath + "'"));
    }
}

