/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glite.ce.commonj.utils.TaskQueue;
import org.glite.ce.commonj.utils.TimerTask;
import org.glite.ce.commonj.utils.TimerThread;

public class Timer {
    private TaskQueue queue = new TaskQueue();
    protected boolean shutdownNow = false;
    private static final int THREAD_COUNT = 20;
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(20, 20, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static int nextSerialNumber = 0;

    private static synchronized int serialNumber() {
        return nextSerialNumber++;
    }

    public Timer() {
        this("Timer-" + Timer.serialNumber());
    }

    public Timer(boolean isDaemon) {
        this("Timer-" + Timer.serialNumber(), isDaemon);
    }

    public Timer(String name) {
        this(name, false);
    }

    public Timer(String name, boolean isDaemon) {
        TimerThread thread = new TimerThread(this.queue);
        thread.setDaemon(isDaemon);
        thread.setName(name);
        thread.start();
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, System.currentTimeMillis() + delay, 0L, null);
    }

    public void schedule(TimerTask task, Date time) {
        this.sched(task, time.getTime(), 0L, null);
    }

    public void schedule(TimerTask task, long delay, long rate, TimerTask.EXECUTION_TYPE executionType) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, System.currentTimeMillis() + delay, rate, executionType);
    }

    public void schedule(TimerTask task, Date firstTime, long rate, TimerTask.EXECUTION_TYPE executionType) {
        this.sched(task, firstTime.getTime(), rate, executionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask task, long time, long rate, TimerTask.EXECUTION_TYPE executionType) {
        if (time < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        if (rate <= 0L) {
            throw new IllegalArgumentException("Non-positive rate.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (this.shutdownNow) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = task.lock;
            synchronized (object) {
                if (task.state != TimerTask.STATUS.VIRGIN) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                task.setExecutionType(executionType);
                task.setNextExecutionTime(time);
                task.setRate(rate);
                task.setState(TimerTask.STATUS.SCHEDULED);
            }
            this.queue.add(task);
            if (this.queue.getMin() == task) {
                this.queue.notify();
            }
        }
    }

    public int size() {
        return this.queue.size();
    }

    public TimerTask getTimerTask(int i) {
        return this.queue.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.queue.close();
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.queue.clear();
            this.queue.notify();
        }
        this.pool.shutdownNow();
        this.pool.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int result = 0;
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            for (int i = this.queue.size(); i > 0; --i) {
                if (this.queue.get((int)i).state != TimerTask.STATUS.CANCELLED) continue;
                this.queue.quickRemove(i);
                ++result;
            }
            if (result != 0) {
                this.queue.heapify();
            }
        }
        return result;
    }
}

