/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import org.glite.ce.commonj.utils.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private boolean closed = false;
    private int size = 0;

    TaskQueue() {
    }

    int size() {
        return this.size;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isclosed() {
        return this.closed;
    }

    synchronized void add(TimerTask task) {
        if (++this.size == this.queue.length) {
            TimerTask[] newQueue = new TimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, newQueue, 0, this.size);
            this.queue = newQueue;
        }
        this.queue[this.size] = task;
        this.queue[this.size].setIndex(this.size);
        this.fixUp(this.size);
        this.notifyAll();
    }

    synchronized TimerTask getMin() {
        while (this.queue[1] == null && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.queue[1];
    }

    synchronized TimerTask get(int i) {
        return this.queue[i];
    }

    synchronized void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    synchronized void quickRemove(int i) {
        assert (i <= this.size);
        this.queue[i] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    synchronized void rescheduleMin(long newTime) {
        this.queue[1].setNextExecutionTime(newTime);
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int k) {
        int j;
        while (k > 1 && this.queue[j = k >> 1].getNextExecutionTime() > this.queue[k].getNextExecutionTime()) {
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[j].setIndex(j);
            this.queue[k] = tmp;
            this.queue[k].setIndex(k);
            k = j;
        }
    }

    private void fixDown(int k) {
        int j;
        while ((j = k << 1) <= this.size && j > 0) {
            if (j < this.size && this.queue[j].getNextExecutionTime() > this.queue[j + 1].getNextExecutionTime()) {
                ++j;
            }
            if (this.queue[k].getNextExecutionTime() <= this.queue[j].getNextExecutionTime()) break;
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[j].setIndex(j);
            this.queue[k] = tmp;
            this.queue[k].setIndex(k);
            k = j;
        }
    }

    void heapify() {
        for (int i = this.size / 2; i >= 1; --i) {
            this.fixDown(i);
        }
    }
}

