/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader(String href, ClassLoader parent) throws MalformedURLException {
        this(new URL(href), parent);
    }

    public JarClassLoader(URL url, ClassLoader parent) {
        super(new URL[]{url}, parent);
    }

    public void addJarURL(URL url) throws MalformedURLException {
        this.addURL(url);
    }

    public void addJarURL(String href) throws MalformedURLException {
        if (href != null) {
            this.addURL(new URL(href));
        }
    }

    public String getMainClassName(URL sensorURL) throws IOException {
        URL u = new URL("jar", "", sensorURL + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        Attributes attr = uc.getMainAttributes();
        return attr != null ? attr.getValue(Attributes.Name.MAIN_CLASS) : null;
    }

    public void invokeClass(String name, String[] args) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.loadClass(name);
        Method m = c.getMethod("main", args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }
}

