/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.axis2.context.MessageContext;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.glite.voms.FQAN;
import org.glite.voms.VOMSAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEUtils {
    private static final Logger logger = Logger.getLogger(CEUtils.class);

    public static synchronized File copyFile(String src, String dst) throws IOException {
        int len;
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (dstFile.isDirectory()) {
            dstFile = new File(dst + "/" + srcFile.getName());
        }
        dstFile.createNewFile();
        FileInputStream in = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(dstFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        out.flush();
        ((InputStream)in).close();
        ((OutputStream)out).close();
        return dstFile;
    }

    public static boolean deleteDir(File dir) {
        CEUtils.emptyDir(dir);
        return dir.delete();
    }

    public static boolean deleteDir(String path) {
        File dir = new File(path);
        return CEUtils.deleteDir(dir);
    }

    public static void emptyDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                CEUtils.emptyDir(files[i]);
            }
            files[i].delete();
        }
    }

    public static List<String> getFQAN(String vo) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        List vomsList = (List)messageContext.getProperty("user.vomsattrs");
        ArrayList<String> result = new ArrayList<String>(0);
        if (vomsList != null) {
            List fqanList = null;
            for (VOMSAttribute vomsAttr : vomsList) {
                if (vo != null && !vo.equals(vomsAttr.getVO())) continue;
                fqanList = vomsAttr.getListOfFQAN();
                if (fqanList != null) {
                    for (FQAN fqan : fqanList) {
                        result.add(fqan.getFQAN());
                    }
                }
                if (vo != null) break;
                fqanList = null;
            }
        }
        return result;
    }

    public static List<VOMSAttribute> getVOMSAttributes() {
        return (List)MessageContext.getCurrentMessageContext().getProperty("user.vomsattrs");
    }

    public static String getLocalUser() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("local.user.id");
    }

    public static String getLocalUserGroup() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("local.group.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLoggingParam(Object info) {
        Properties logProps = new Properties();
        Hashtable<String, String> containerConfigEnv = new Hashtable<String, String>(2);
        containerConfigEnv.put("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        containerConfigEnv.put("java.naming.factory.url.pkgs", "org.apache.naming");
        try {
            Context context = (Context)new InitialContext(containerConfigEnv).lookup("java:comp/env");
            File logConfFile = new File((String)context.lookup("log_configuration_file"));
            FileInputStream in = null;
            try {
                in = new FileInputStream(logConfFile);
                logProps.load(in);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    in.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception ex) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logProps.size() == 0) {
            logProps.setProperty("log4j.rootLogger", "ERROR, fileout");
            logProps.setProperty("log4j.logger.org.glite", "INFO, fileout");
            logProps.setProperty("log4j.appender.fileout", "org.apache.log4j.RollingFileAppender");
            logProps.setProperty("log4j.appender.fileout.File", "${catalina.base}/logs/glite-ce-common.log");
            logProps.setProperty("log4j.appender.fileout.MaxFileSize", "500KB");
            logProps.setProperty("log4j.appender.fileout.MaxBackupIndex", "1");
            logProps.setProperty("log4j.appender.fileout.layout", "org.apache.log4j.PatternLayout");
            logProps.setProperty("log4j.appender.fileout.layout.ConversionPattern", "%d{dd MMM yyyy HH:mm:ss,SSS} %c - %m%n");
        }
        return logProps;
    }

    public static Object getMessageContextProperty(String name) {
        return name == null ? null : MessageContext.getCurrentMessageContext().getProperty(name);
    }

    public static String getPEM(X509Certificate[] certChain) throws CertificateEncodingException {
        if (certChain == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int k = 0; k < certChain.length; ++k) {
            byte[] pemBytes = Base64.encode((byte[])certChain[k].getEncoded());
            result.append("-----BEGIN CERTIFICATE-----\n");
            for (int n = 0; n < pemBytes.length; n += 64) {
                if (pemBytes.length - n < 64) {
                    result.append(new String(pemBytes, n, pemBytes.length - n));
                } else {
                    result.append(new String(pemBytes, n, 64));
                }
                result.append("\n");
            }
            result.append("-----END CERTIFICATE-----\n");
        }
        return result.toString();
    }

    public static String getRemoteRequestAddress() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("REMOTE_REQUEST_ADDRESS");
    }

    public static X509Certificate getUserCert() {
        return (X509Certificate)MessageContext.getCurrentMessageContext().getProperty("user.certificate");
    }

    public static X509Certificate[] getUserCertChain() {
        return (X509Certificate[])MessageContext.getCurrentMessageContext().getProperty("user.certificate.chain");
    }

    public static String getUserDefaultVO() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("user.vo");
    }

    public static String getUserId() {
        String userFQAN = "";
        String userVO = CEUtils.getUserDefaultVO();
        List<String> fqanlist = null;
        if (userVO != null) {
            fqanlist = CEUtils.getFQAN(userVO);
        }
        if (fqanlist != null && fqanlist.size() > 0) {
            userFQAN = fqanlist.get(0).toString();
        }
        return CEUtils.normalize(CEUtils.getUserDN_RFC2253() + userFQAN);
    }

    public static String getUserDN_RFC2253() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("user.dn.RFC2253");
    }

    public static String getUserDN_X500() {
        return (String)MessageContext.getCurrentMessageContext().getProperty("user.dn.X500");
    }

    public static boolean isAdmin() {
        Boolean b = (Boolean)MessageContext.getCurrentMessageContext().getProperty("IS_ADMIN");
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Object loadObject(String filename) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(filename);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object obj = ois.readObject();
        ois.close();
        fis.close();
        return obj;
    }

    public static synchronized File makeDir(String path) throws IOException {
        File dir = null;
        if (path != null && !(dir = new File(path)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void makeFile(File file, String message, boolean append, boolean lock) throws IOException, IllegalArgumentException {
        block26: {
            block27: {
                int retcod;
                File tmpFile;
                block22: {
                    if (file == null) {
                        throw new IllegalArgumentException("file not specified!");
                    }
                    if (message == null) {
                        throw new IllegalArgumentException("message not specified!");
                    }
                    if (!lock) break block27;
                    tmpFile = File.createTempFile(file.getName(), null, file.getParentFile());
                    String chmod_command = "chmod 0600 " + tmpFile.toString();
                    retcod = -1;
                    Process chmodProc = null;
                    chmodProc = Runtime.getRuntime().exec(chmod_command);
                    Object var10_9 = null;
                    if (chmodProc == null) break block22;
                    try {
                        retcod = chmodProc.waitFor();
                    }
                    catch (Throwable t) {
                        logger.error((Object)("makeFile error: " + t.getMessage()));
                    }
                    try {
                        chmodProc.getInputStream().close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot close instream for " + chmod_command));
                    }
                    try {
                        chmodProc.getErrorStream().close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot close errstream for " + chmod_command));
                    }
                    try {
                        chmodProc.getOutputStream().close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot close outstream for " + chmod_command));
                    }
                    break block22;
                    {
                        catch (Exception ex) {
                            logger.error((Object)"Cannot set permissions to the store proxy certificate", (Throwable)ex);
                            retcod = -1;
                            throw new IOException("Cannot set permissions to the store proxy certificate: " + ex.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        if (chmodProc != null) {
                            try {
                                retcod = chmodProc.waitFor();
                            }
                            catch (Throwable t) {
                                logger.error((Object)("makeFile error: " + t.getMessage()));
                            }
                            try {
                                chmodProc.getInputStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close instream for " + chmod_command));
                            }
                            try {
                                chmodProc.getErrorStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close errstream for " + chmod_command));
                            }
                            try {
                                chmodProc.getOutputStream().close();
                            }
                            catch (IOException e) {
                                logger.error((Object)("Cannot close outstream for " + chmod_command));
                            }
                        }
                        throw throwable;
                    }
                }
                if (retcod != 0) {
                    tmpFile.delete();
                    throw new IOException("Could not set permissions of file " + tmpFile.toString());
                }
                FileWriter fw = new FileWriter(tmpFile, append);
                fw.write(message);
                fw.flush();
                fw.close();
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                FileLock fileLock = channel.lock();
                try {
                    tmpFile.renameTo(file);
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    fileLock.release();
                    channel.close();
                    throw throwable;
                }
                fileLock.release();
                channel.close();
                {
                    break block26;
                }
            }
            FileWriter fw = new FileWriter(file, append);
            fw.write(message);
            fw.flush();
            fw.close();
        }
    }

    public static void makeFile(String filename, String message, boolean append, boolean lock) throws IOException, IllegalArgumentException {
        if (filename == null) {
            throw new IllegalArgumentException("filename not specified!");
        }
        CEUtils.makeFile(new File(filename), message, append, lock);
    }

    public static String normalize(String s) {
        if (s != null) {
            return s.replaceAll("\\W", "_");
        }
        return null;
    }

    public static String readFile(String filename) throws IOException {
        String res = "";
        FileReader in = new FileReader(filename);
        char[] buffer = new char[1024];
        int n = 1;
        while (n > 0) {
            n = in.read(buffer, 0, buffer.length);
            if (n <= 0) continue;
            res = res + new String(buffer, 0, n);
        }
        in.close();
        return res;
    }

    public static synchronized void saveObject(String filename, Object obj) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
        fos.close();
    }

    public static String getURIWithoutDN(String uri) {
        String uriWithoutDN = null;
        if (uri != null && !"".equals(uri) && uri.indexOf("?DN=") != -1) {
            uriWithoutDN = uri.substring(0, uri.indexOf("?DN="));
            if (uriWithoutDN.charAt(uriWithoutDN.length() - 1) == '\\') {
                uriWithoutDN = uriWithoutDN.substring(0, uriWithoutDN.length() - 1);
            }
            if (uriWithoutDN.charAt(uriWithoutDN.length() - 1) == '\\') {
                uriWithoutDN = uriWithoutDN.substring(0, uriWithoutDN.length() - 1);
            }
        }
        return uriWithoutDN;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Calendar calendar) {
        XMLGregorianCalendar xmlGregorianCalendar = null;
        if (calendar != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
            try {
                xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.warn((Object)ex.getMessage());
            }
        }
        return xmlGregorianCalendar;
    }
}

