/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.utils;

public class BooleanLock {
    private boolean value;

    public BooleanLock() {
        this(false);
    }

    public BooleanLock(boolean initialValue) {
        this.value = initialValue;
    }

    public synchronized void setValue(boolean newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.notifyAll();
        }
    }

    public synchronized boolean waitToSetTrue(long msTimeout) throws InterruptedException {
        boolean success = this.waitUntilFalse(msTimeout);
        if (success) {
            this.setValue(true);
        }
        return success;
    }

    public synchronized boolean waitToSetFalse(long msTimeout) throws InterruptedException {
        boolean success = this.waitUntilTrue(msTimeout);
        if (success) {
            this.setValue(false);
        }
        return success;
    }

    public synchronized boolean isTrue() {
        return this.value;
    }

    public synchronized boolean isFalse() {
        return !this.value;
    }

    public synchronized boolean waitUntilTrue(long msTimeout) throws InterruptedException {
        return this.waitUntilStateIs(true, msTimeout);
    }

    public synchronized boolean waitUntilFalse(long msTimeout) throws InterruptedException {
        return this.waitUntilStateIs(false, msTimeout);
    }

    public synchronized boolean waitUntilStateIs(boolean state, long msTimeout) throws InterruptedException {
        if (msTimeout == 0L) {
            while (this.value != state) {
                this.wait();
            }
            return true;
        }
        long endTime = System.currentTimeMillis() + msTimeout;
        long msRemaining = msTimeout;
        while (this.value != state && msRemaining > 0L) {
            this.wait(msRemaining);
            msRemaining = endTime - System.currentTimeMillis();
        }
        return this.value == state;
    }
}

