/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.jndi.provider.fscachedprovider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.CEResource;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CEEventManager;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CEGeneralAttributes;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CEGeneralNameParser;
import org.glite.ce.commonj.jndi.provider.fscachedprovider.CacheManager;

public class CEGeneralDirContext
implements DirContext,
CEResource,
EventDirContext {
    private static Logger logger = Logger.getLogger((String)CEGeneralDirContext.class.getName());
    protected static final NameParser nameParser = new CEGeneralNameParser();
    protected static Hashtable eventManagerTable = null;
    protected static Hashtable cacheManagerTable = null;
    protected CEEventManager eventManager;
    protected CacheManager cacheManager;
    protected Hashtable environment;
    protected Name contextName;
    protected String absoluteBase = null;
    public static String CACHE_SIZE_LABEL = "cache.size";
    public static String CNAME_ATTR_LABEL = "classname";
    public static String MODTIME_ATTR_LABEL = "modificationtime";

    protected static String checkAbsolutePath(String docBase) throws NamingException {
        if (docBase == null) {
            throw new NamingException("Missing docBase or contextPath");
        }
        try {
            File base = new File(docBase).getCanonicalFile();
            if (!(base.exists() && base.isDirectory() && base.canRead())) {
                throw new NamingException("Bad docBase");
            }
            return base.getAbsolutePath();
        }
        catch (IOException ioEx) {
            throw new NamingException(ioEx.getMessage());
        }
    }

    protected CEGeneralDirContext(String docBase, Name ctxPath, Hashtable inEnv) {
        this.environment = inEnv != null ? (Hashtable)inEnv.clone() : null;
        this.absoluteBase = docBase;
        this.contextName = (Name)ctxPath.clone();
        if (eventManagerTable == null) {
            eventManagerTable = new Hashtable(0);
        }
        this.eventManager = (CEEventManager)eventManagerTable.get(this.absoluteBase);
        if (this.eventManager == null) {
            this.eventManager = new CEEventManager();
            eventManagerTable.put(this.absoluteBase, this.eventManager);
        }
        if (cacheManagerTable == null) {
            cacheManagerTable = new Hashtable(0);
        }
        this.cacheManager = (CacheManager)cacheManagerTable.get(this.absoluteBase);
        if (this.cacheManager == null) {
            Object tmpo = this.environment.get(CACHE_SIZE_LABEL);
            this.cacheManager = tmpo != null && tmpo instanceof Integer ? new CacheManager(this.absoluteBase, (Integer)tmpo) : new CacheManager(this.absoluteBase);
            cacheManagerTable.put(this.absoluteBase, this.cacheManager);
        }
    }

    protected CEGeneralDirContext(String docBase, String ctxPath, Hashtable inEnv) throws NamingException {
        this(docBase, nameParser.parse(ctxPath), inEnv);
    }

    public CEGeneralDirContext(String docBase, Hashtable inEnv) throws NamingException {
        this(CEGeneralDirContext.checkAbsolutePath(docBase), "", inEnv);
        try {
            this.cacheManager.getAttributes(this.contextName);
        }
        catch (NamingException nEx) {
            CEGeneralAttributes rootAttrs = new CEGeneralAttributes(MODTIME_ATTR_LABEL, new Long(System.currentTimeMillis()));
            this.cacheManager.putObject(this.contextName, null, rootAttrs, false);
        }
    }

    protected Context cloneCtx() {
        return new CEGeneralDirContext(this.absoluteBase, this.contextName, this.environment);
    }

    public Object clone() {
        return this.cloneCtx();
    }

    public String getAbsoluteBase() {
        return this.absoluteBase;
    }

    protected Name getCompleteName(Name name) throws NamingException {
        Name result = (Name)this.contextName.clone();
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            result.addAll(nameParser.parse(name.get(0)));
        } else {
            result.addAll(name);
        }
        for (int k = 0; k < result.size(); ++k) {
            if (!result.get(k).startsWith(".")) continue;
            throw new NamingException("Hidden files are not allowed");
        }
        return result;
    }

    public Object lookup(String name) throws NamingException {
        return this.internalLookup(nameParser.parse(name), false);
    }

    public Object lookup(Name name) throws NamingException {
        return this.internalLookup(name, false);
    }

    protected Object internalLookup(Name name, boolean isAbsolute) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneCtx();
        }
        Name targetName = isAbsolute ? name : this.getCompleteName(name);
        Object result = this.cacheManager.getObject(targetName);
        if (result instanceof File) {
            return new CEGeneralDirContext(this.absoluteBase, targetName, this.environment);
        }
        try {
            return DirectoryManager.getObjectInstance(result, name, this, this.environment, null);
        }
        catch (Exception ex) {
            throw new NamingException(ex.getMessage());
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        this.internalBind(nameParser.parse(name), obj, null, false);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.internalBind(nameParser.parse(name), obj, attrs, false);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.internalBind(name, obj, null, false);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.internalBind(name, obj, attrs, false);
    }

    protected void internalBind(Name name, Object obj, Attributes attrs, boolean allowRebind) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (obj == null) {
            throw new NamingException("Object cannot be null");
        }
        if (obj instanceof Context) {
            throw new NamingException("Cannot bind a directory");
        }
        Name targetName = this.getCompleteName(name);
        if (attrs == null || !(attrs instanceof CEGeneralAttributes)) {
            attrs = new CEGeneralAttributes(attrs);
        }
        attrs.put(CNAME_ATTR_LABEL, obj.getClass().getName());
        attrs.put(MODTIME_ATTR_LABEL, new Long(System.currentTimeMillis()));
        DirStateFactory.Result newObjRes = DirectoryManager.getStateToBind(obj, name, this, this.environment, attrs);
        this.cacheManager.putObject(targetName, newObjRes.getObject(), newObjRes.getAttributes(), allowRebind);
        if (!allowRebind) {
            this.fireEvents(targetName, 0, obj, null, null);
        } else {
            this.fireEvents(targetName, 3, obj, null, null);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.internalBind(nameParser.parse(name), obj, null, true);
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.internalBind(nameParser.parse(name), obj, attrs, true);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.internalBind(name, obj, null, true);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.internalBind(name, obj, attrs, true);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        Name target = this.getCompleteName(name);
        try {
            ArrayList evnList = this.cacheManager.recursiveRemove(target, 0);
            for (int k = 0; k < evnList.size(); ++k) {
                Object[] evnPair = (Object[])evnList.get(k);
                if (evnPair[1] == null) continue;
                this.fireEvents((Name)evnPair[0], 1, null, evnPair[1], null);
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        this.eventManager.removeAll(target);
    }

    public void rename(String source, String target) throws NamingException {
        this.rename(nameParser.parse(source), nameParser.parse(target));
    }

    public void rename(Name source, Name target) throws NamingException {
        if (source.isEmpty() || target.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        Name srcTarget = this.getCompleteName(source);
        Name dstTarget = this.getCompleteName(target);
        this.cacheManager.renameObject(srcTarget, dstTarget);
        this.fireEvents(srcTarget, 2, null, null, dstTarget);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        ArrayList attrList = this.cacheManager.getAttributeList(this.getCompleteName(name));
        ArrayList<NameClassPair> list = new ArrayList<NameClassPair>(attrList.size());
        for (int k = 0; k < attrList.size(); ++k) {
            Object[] pair = (Object[])attrList.get(k);
            Name itemName = (Name)pair[0];
            Attributes attrs = (Attributes)pair[1];
            list.add(new NameClassPair(itemName.get(itemName.size() - 1), (String)attrs.get(CNAME_ATTR_LABEL).get(0)));
        }
        return new CEGeneralEnumeration(list);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot destroy context using empty name");
        }
        Name target = this.getCompleteName(name);
        ArrayList evnList = this.cacheManager.recursiveRemove(target, 1);
        for (int k = 0; k < evnList.size(); ++k) {
            Object[] evnPair = (Object[])evnList.get(k);
            if (evnPair.length != 3) continue;
            this.fireEvents((Name)evnPair[0], 1, null, evnPair[1], evnPair[2]);
        }
        this.eventManager.removeAll(target);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name), null);
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(nameParser.parse(name), attrs);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NameAlreadyBoundException, NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name targetName = this.getCompleteName(name);
        CEGeneralDirContext subCtx = null;
        if (attrs == null || !(attrs instanceof CEGeneralAttributes)) {
            attrs = new CEGeneralAttributes(attrs);
        }
        attrs.put(CNAME_ATTR_LABEL, this.getClass().getName());
        attrs.put(MODTIME_ATTR_LABEL, new Long(System.currentTimeMillis()));
        Enumeration<String> tokens = targetName.getSuffix(this.contextName.size()).getAll();
        Name tmpName = (Name)this.contextName.clone();
        while (tokens.hasMoreElements()) {
            tmpName.add(tokens.nextElement());
            try {
                this.cacheManager.createContext(tmpName, attrs);
            }
            catch (NameAlreadyBoundException nabEx) {
                logger.debug((Object)nabEx.getMessage());
            }
            subCtx = new CEGeneralDirContext(this.absoluteBase, tmpName, this.environment);
            this.fireEvents(tmpName, 0, subCtx.clone(), null, null);
        }
        return subCtx;
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(nameParser.parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (prefix.endsWith(File.separator)) {
            return prefix + name;
        }
        return prefix + File.separator + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        String tmps = prefix.toString() + File.separator + name.toString();
        return nameParser.parse(tmps);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable(5, 0.75f);
        }
        return this.environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() {
        return this.contextName.toString();
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(nameParser.parse(name), null);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public Attributes getAttributes(String name, String[] ids) throws NamingException {
        return this.getAttributes(nameParser.parse(name), ids);
    }

    public Attributes getAttributes(Name name, String[] ids) throws NamingException {
        Attributes loadedAttrs = this.cacheManager.getAttributes(this.getCompleteName(name));
        if (ids == null) {
            return loadedAttrs;
        }
        CEGeneralAttributes result = new CEGeneralAttributes();
        for (int k = 0; k < ids.length; ++k) {
            Attribute attr = loadedAttrs.get(ids[k]);
            if (attr == null) continue;
            result.put(attr);
        }
        return result;
    }

    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.modifyAttributes(nameParser.parse(name), modOp, attrs);
    }

    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        ModificationItem[] mods = new ModificationItem[attrs.size()];
        NamingEnumeration<? extends Attribute> allAttrs = attrs.getAll();
        int r = 0;
        while (allAttrs.hasMoreElements()) {
            Attribute attr = (Attribute)allAttrs.nextElement();
            mods[r] = new ModificationItem(modOp, attr);
            ++r;
        }
        this.modifyAttributes(name, mods);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        Name targetName = this.getCompleteName(name);
        CEGeneralAttributes modAttrs = (CEGeneralAttributes)this.cacheManager.getAttributes(targetName);
        CEGeneralAttributes newAttributes = new CEGeneralAttributes();
        CEGeneralAttributes oldAttributes = new CEGeneralAttributes();
        block5: for (int k = 0; k < mods.length; ++k) {
            Attribute newAttr = mods[k].getAttribute();
            if (newAttr.getID().equals(CNAME_ATTR_LABEL)) continue;
            NamingEnumeration<?> values = newAttr.getAll();
            Attribute oldAttr = modAttrs.get(newAttr.getID());
            switch (mods[k].getModificationOp()) {
                case 1: {
                    if (oldAttr == null) {
                        modAttrs.put(newAttr);
                        newAttributes.put(newAttr);
                        continue block5;
                    }
                    while (values.hasMoreElements()) {
                        oldAttr.add(values.nextElement());
                    }
                    modAttrs.put(oldAttr);
                    newAttributes.put((Attribute)oldAttr.clone());
                    continue block5;
                }
                case 2: {
                    if (oldAttr == null) {
                        throw new AttributeModificationException(newAttr.getID());
                    }
                    modAttrs.put(newAttr);
                    newAttributes.put(newAttr);
                    oldAttributes.put(oldAttr);
                    continue block5;
                }
                case 3: {
                    if (oldAttr == null) continue block5;
                    while (values.hasMoreElements()) {
                        oldAttr.remove(values.nextElement());
                    }
                    if (oldAttr.size() == 0) {
                        modAttrs.remove(newAttr.getID());
                    } else {
                        modAttrs.put(oldAttr);
                    }
                    oldAttributes.put(oldAttr);
                }
            }
        }
        modAttrs.put(MODTIME_ATTR_LABEL, new Long(System.currentTimeMillis()));
        this.cacheManager.putObject(targetName, null, modAttrs, true);
        this.fireEvents(targetName, 3, newAttributes, oldAttributes, null);
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(nameParser.parse(name), mods);
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String name) throws NamingException {
        return this.getSchema(nameParser.parse(name));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.getSchemaClassDefinition(nameParser.parse(name));
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        ArrayList attrList = this.cacheManager.getAttributeList(this.getCompleteName(name));
        ArrayList<SearchResult> list = new ArrayList<SearchResult>(attrList.size());
        for (int k = 0; k < attrList.size(); ++k) {
            Object[] pair = (Object[])attrList.get(k);
            Name itemName = (Name)pair[0];
            CEGeneralAttributes attrs = (CEGeneralAttributes)pair[1];
            if (matchingAttributes != null && matchingAttributes.size() != 0 && !attrs.match(matchingAttributes)) continue;
            Object obj = this.lookup(itemName);
            CEGeneralAttributes resultAttrs = attrs.clone(attributesToReturn);
            list.add(new SearchResult(itemName.toString(), obj, resultAttrs));
        }
        return new CEGeneralEnumeration(list);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(nameParser.parse(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name.toString(), matchingAttributes, null);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(nameParser.parse(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(nameParser.parse(name), filterExpr, filterArgs, cons);
    }

    public String toString() {
        return this.contextName.toString();
    }

    public void close() throws NamingException {
    }

    public void addNamingListener(Name target, int scope, NamingListener lsnr) throws NamingException {
        Name tmpName = ((Name)this.contextName.clone()).addAll(target);
        this.eventManager.register(tmpName, scope, lsnr);
    }

    public void addNamingListener(String target, int scope, NamingListener lsnr) throws NamingException {
        this.addNamingListener(nameParser.parse(target), scope, lsnr);
    }

    public void addNamingListener(Name target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener lsnr) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void addNamingListener(Name target, String filter, SearchControls ctls, NamingListener lsnr) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void addNamingListener(String target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener lsnr) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void addNamingListener(String target, String filter, SearchControls ctls, NamingListener lsrn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void removeNamingListener(NamingListener lsnr) {
        this.eventManager.remove(this.contextName, lsnr);
    }

    public boolean targetMustExist() {
        return false;
    }

    protected void fireEvents(Name target, int type, Object newObj, Object oldObj, Object changeInfo) throws NamingException {
        CEEventManager.Tuple[] tuple = this.eventManager.getListeners(target, type);
        block6: for (int r = 0; r < tuple.length; ++r) {
            Name sourceName = tuple[r].getSource();
            EventDirContext evnCtx = (EventDirContext)this.internalLookup(sourceName, true);
            Name itemName = ((Name)target.clone()).getSuffix(sourceName.size());
            Binding newBd = null;
            Binding oldBd = null;
            if (newObj != null) {
                newBd = new Binding(itemName.toString(), newObj);
            }
            if (oldObj != null) {
                oldBd = new Binding(itemName.toString(), oldObj);
            }
            NamingEvent evn = new NamingEvent(evnCtx, type, newBd, oldBd, changeInfo);
            logger.debug((Object)("Firing " + tuple[r].getSource().toString()));
            switch (type) {
                case 0: {
                    ((NamespaceChangeListener)tuple[r].getListener()).objectAdded(evn);
                    continue block6;
                }
                case 1: {
                    ((NamespaceChangeListener)tuple[r].getListener()).objectRemoved(evn);
                    continue block6;
                }
                case 2: {
                    ((NamespaceChangeListener)tuple[r].getListener()).objectRenamed(evn);
                    continue block6;
                }
                case 3: {
                    ((ObjectChangeListener)tuple[r].getListener()).objectChanged(evn);
                }
            }
        }
    }

    public class CEGeneralEnumeration
    implements NamingEnumeration {
        Iterator iterator;

        public CEGeneralEnumeration(ArrayList lst) {
            this.iterator = lst.iterator();
        }

        public Object next() {
            return this.iterator.next();
        }

        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        public void close() throws NamingException {
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

