/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.db;

import java.sql.Connection;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.DatabaseException;

public class DatasourceManager {
    private static final Logger logger = Logger.getLogger(DatasourceManager.class);
    private static final HashMap<String, DataSource> datasourceCache = new HashMap(0);

    public static void destroy() {
        datasourceCache.clear();
    }

    public static boolean addDataSource(String dataSourceName, DataSource dataSource) {
        boolean isPutDatasource = false;
        if (dataSourceName == null || dataSource == null) {
            logger.warn((Object)("dataSourceName and/or dataSource is/are null: (" + dataSourceName + ", " + dataSource + ")"));
        } else if (!datasourceCache.containsKey(dataSourceName)) {
            datasourceCache.put(dataSourceName, dataSource);
            isPutDatasource = true;
        }
        return isPutDatasource;
    }

    public static Connection getConnection(String dataSourceName) throws DatabaseException {
        if (dataSourceName == null) {
            throw new DatabaseException("datasourceName not specified!");
        }
        if (!datasourceCache.containsKey(dataSourceName)) {
            throw new DatabaseException("datasourceName " + dataSourceName + " not found!");
        }
        DataSource dataSource = datasourceCache.get(dataSourceName);
        logger.debug((Object)("getConnection " + dataSourceName));
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            if (connection == null) {
                throw new DatabaseException("problem in opening connection to target database [" + dataSourceName + "]");
            }
            logger.debug((Object)("Connection got from datasource named: " + dataSourceName));
            connection.setAutoCommit(false);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage());
            throw new DatabaseException("getConnection error: " + e.getMessage());
        }
        return connection;
    }
}

