/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.db.Query;
import org.glite.ce.commonj.db.TableInterface;

public class AbstractTable
implements TableInterface {
    private static final Logger logger = Logger.getLogger(AbstractTable.class);
    protected Query sequenceIdQuery = null;
    protected Query insertQuery = null;
    protected Query deleteQuery = null;
    protected Query updateQuery = null;
    protected Query selectQuery = null;

    protected Query getSequenceIdQuery(String sequenceName) {
        if (this.sequenceIdQuery == null) {
            this.sequenceIdQuery = new Query();
            this.sequenceIdQuery.setName("SEQUENCE_ID_STATEMENT");
            this.sequenceIdQuery.setStatement("select nextVal('" + sequenceName + "')");
        }
        logger.debug((Object)("sequenceIdQuery = " + this.sequenceIdQuery.getStatement()));
        return this.sequenceIdQuery;
    }

    public PreparedStatement getPreparedStatement(Query query, Connection connection) throws SQLException, IllegalArgumentException {
        if (query == null) {
            throw new IllegalArgumentException("query not specified!");
        }
        if (query.getName() == null) {
            throw new IllegalArgumentException("query name not specified!");
        }
        if (query.getStatement() == null) {
            throw new IllegalArgumentException("query statement not specified!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection not specified!");
        }
        PreparedStatement statement = connection.prepareStatement(query.getStatement(), 1);
        if (statement == null) {
            throw new SQLException("cannot create a PrepareStatement for the query \"" + query.getStatement() + "\"");
        }
        return statement;
    }

    /*
     * Loose catch block
     */
    public long executeSequenceId(String sequenceName, Connection connection) throws SQLException, IllegalArgumentException {
        long id;
        block17: {
            ResultSet rset;
            PreparedStatement pstmt;
            block16: {
                block15: {
                    if (sequenceName == null) {
                        throw new IllegalArgumentException("sequenceName not specified!");
                    }
                    if (connection == null) {
                        throw new IllegalArgumentException("connection not specified!");
                    }
                    id = -1L;
                    pstmt = null;
                    rset = null;
                    pstmt = this.getPreparedStatement(this.getSequenceIdQuery(sequenceName), connection);
                    rset = pstmt.executeQuery();
                    if (rset == null) break block15;
                    rset.next();
                    id = rset.getLong(1);
                }
                Object var9_6 = null;
                if (pstmt == null) break block16;
                try {
                    pstmt.close();
                }
                catch (SQLException sqle1) {
                    logger.error((Object)sqle1);
                }
            }
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (SQLException sqle2) {
                    logger.error((Object)sqle2);
                }
            }
            break block17;
            {
                catch (SQLException sqle) {
                    throw sqle;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sqle1) {
                        logger.error((Object)sqle1);
                    }
                }
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (SQLException sqle2) {
                        logger.error((Object)sqle2);
                    }
                }
                throw throwable;
            }
        }
        return id;
    }
}

