/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ChainConfig;
import org.glite.ce.commonj.authz.gjaf.CloseException;
import org.glite.ce.commonj.authz.gjaf.InitializeException;
import org.glite.ce.commonj.authz.gjaf.ServicePDP;
import org.glite.security.util.X500Principal;

public class GridMapServicePDP
implements ServicePDP {
    private static Logger logger = Logger.getLogger((String)GridMapServicePDP.class.getName());
    public static final String GRID_MAP_FILE = "gridMapFile";
    private static final Pattern mapFilePattern = Pattern.compile("^\\s*\"(/[^=/\"]+=[^/\"]+/[^\"]+)\"\\s+([^\\s]+)\\s*$");
    private String id;
    private String gridMapFile;
    private HashMap<String, String> dnTable;
    private long timestamp;

    public GridMapServicePDP() {
        this.id = "undef";
        this.timestamp = 0L;
    }

    public GridMapServicePDP(String id) {
        this.id = id;
        this.timestamp = 0L;
    }

    public void initialize(ChainConfig config, String name, String id) throws InitializeException {
        String mapFile = (String)config.getProperty(name, GRID_MAP_FILE);
        if (mapFile == null) {
            logger.error((Object)"Gridmap file not specified");
            throw new InitializeException("Gridmap file not specified");
        }
        this.readGridmapFile(mapFile);
        this.gridMapFile = mapFile;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String name, String value) throws InitializeException {
        if (name.equals(GRID_MAP_FILE)) {
            this.readGridmapFile(value);
            this.gridMapFile = value;
        }
    }

    public String getProperty(String name) {
        if (name.equals(GRID_MAP_FILE)) {
            return this.gridMapFile;
        }
        return null;
    }

    public String[] getProperties() {
        return new String[]{GRID_MAP_FILE};
    }

    public boolean isTriggerable(String name) {
        return name.equals(GRID_MAP_FILE);
    }

    public void readGridmapFile(String mapFile) throws InitializeException {
        logger.debug((Object)("Initializing gridmap service PDP with " + mapFile + "(" + this.hashCode() + ")"));
        this.dnTable = new HashMap();
        this.timestamp = System.currentTimeMillis();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(mapFile));
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = mapFilePattern.matcher(line);
                if (matcher.matches()) {
                    String oldValue = this.dnTable.put(matcher.group(1), matcher.group(2));
                    if (oldValue != null) {
                        logger.warn((Object)("Replaced value for " + matcher.group(1) + ": " + oldValue));
                    }
                    logger.debug((Object)("Registered DN: " + matcher.group(1) + "(" + this.hashCode() + ")"));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioEx) {
            logger.error((Object)ioEx.getMessage(), (Throwable)ioEx);
            throw new InitializeException(ioEx.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public int getPermissionLevel(Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        Set<X500Principal> pSet = peerSubject.getPrincipals(X500Principal.class);
        if (pSet == null) {
            logger.warn((Object)"Cannot authorize: missing X500Principal in subject");
            return 0;
        }
        Iterator<X500Principal> allPrincipals = pSet.iterator();
        while (allPrincipals.hasNext()) {
            String identity = allPrincipals.next().getName();
            logger.debug((Object)("Checking identity: " + identity));
            if (this.dnTable.get(identity) == null) continue;
            logger.info((Object)("Identity authorized: " + identity + "(" + this.hashCode() + ")"));
            return 8;
        }
        return 1;
    }

    public void close() throws CloseException {
    }

    public Object clone() {
        GridMapServicePDP result = new GridMapServicePDP(this.id);
        result.gridMapFile = this.gridMapFile;
        result.timestamp = this.timestamp;
        result.dnTable = (HashMap)this.dnTable.clone();
        logger.debug((Object)("Cloned " + this.hashCode() + " in " + result.hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GridMapServicePDP)) {
            return false;
        }
        GridMapServicePDP pdp = (GridMapServicePDP)obj;
        return pdp.gridMapFile.equals(this.gridMapFile) && pdp.id.equals(this.id) && pdp.timestamp == this.timestamp;
    }
}

