/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.gjaf;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.gjaf.ServiceAuthorizationChain;
import org.glite.ce.commonj.authz.gjaf.ServiceInterceptor;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GJAFConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)GJAFConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/authzchain";
    private static final String NAME_ATTR = "name";
    private static String PLUGIN_TAG = "plugin";
    private static final String PLUGIN_NAME_ATTR = "name";
    private static final String PLUGIN_CLASSNAME_ATTR = "classname";
    private static String PARAM_TAG = "parameter";
    private static final String PARAM_NAME_ATTR = "name";
    private static final String PARAM_VALUE_ATTR = "value";
    private XPathExpression expr;
    private ServiceAuthorizationChain currentChain;
    private ServiceAuthorizationChain tmpChain;

    public GJAFConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
    }

    @Override
    public XPathExpression getXPath() {
        return this.expr;
    }

    @Override
    public Class<?> getCategory() {
        return ServiceAuthorizationInterface.class;
    }

    @Override
    public Object[] getConfigurationElement() {
        if (this.currentChain != null) {
            Object[] result = new Object[]{this.currentChain};
            return result;
        }
        return null;
    }

    @Override
    public boolean process(NodeList parsedElements) throws CommonConfigException {
        ArrayList<ServiceInterceptor> plugins = new ArrayList<ServiceInterceptor>();
        Element authzElem = (Element)parsedElements.item(0);
        if (authzElem == null) {
            throw new CommonConfigException("Missing authzchain element ");
        }
        String chainName = authzElem.getAttribute("name");
        if (chainName == "") {
            throw new CommonConfigException("Missing name");
        }
        NodeList plugElemList = authzElem.getElementsByTagName(PLUGIN_TAG);
        for (int k = 0; k < plugElemList.getLength(); ++k) {
            Element plugElement = (Element)plugElemList.item(k);
            String plugName = plugElement.getAttribute("name");
            if (plugName == "") {
                throw new CommonConfigException("Missing name");
            }
            String plugClassName = plugElement.getAttribute(PLUGIN_CLASSNAME_ATTR);
            if (plugClassName == "") {
                throw new CommonConfigException("Missing classname for " + plugName);
            }
            ServiceInterceptor currentPlugin = this.createInterceptor(plugClassName, plugName);
            NodeList paramElemList = plugElement.getElementsByTagName(PARAM_TAG);
            for (int j = 0; j < paramElemList.getLength(); ++j) {
                Element paraElement = (Element)paramElemList.item(j);
                String paraName = paraElement.getAttribute("name");
                String paraValue = paraElement.getAttribute(PARAM_VALUE_ATTR);
                try {
                    currentPlugin.setProperty(paraName, paraValue);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new CommonConfigException("Error setting properties for " + plugName);
                }
            }
            plugins.add(currentPlugin);
        }
        this.tmpChain = new ServiceAuthorizationChain();
        this.tmpChain.initialize(chainName, plugins);
        return !this.tmpChain.equals(this.currentChain);
    }

    @Override
    public boolean processTriggers() throws CommonConfigException {
        if (this.currentChain == null) {
            return false;
        }
        ArrayList<ServiceInterceptor> newPlugins = new ArrayList<ServiceInterceptor>();
        for (ServiceInterceptor plugin : this.currentChain.getInterceptors()) {
            logger.debug((Object)("Reloading interceptor: " + plugin.getId()));
            ServiceInterceptor newPlugin = this.createInterceptor(plugin.getClass().getName(), plugin.getId());
            try {
                for (String prop : plugin.getProperties()) {
                    newPlugin.setProperty(prop, plugin.getProperty(prop));
                }
                newPlugins.add(newPlugin);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new CommonConfigException("Error setting properties for " + plugin.getId());
            }
        }
        this.tmpChain = new ServiceAuthorizationChain();
        this.tmpChain.initialize(this.currentChain.getId(), newPlugins);
        return true;
    }

    @Override
    public void commit() {
        this.currentChain = this.tmpChain;
        this.tmpChain = null;
    }

    @Override
    public void rollback() {
        this.tmpChain = null;
    }

    @Override
    public File[] getTriggers() {
        if (this.currentChain != null) {
            return this.currentChain.getAllTriggers();
        }
        return null;
    }

    @Override
    public void clean() {
    }

    private ServiceInterceptor createInterceptor(String plugClassName, String plugName) throws CommonConfigException {
        ServiceInterceptor interceptor = null;
        try {
            Class<?> interceptorClass = Class.forName(plugClassName);
            Class[] constrArgClass = new Class[]{String.class};
            Constructor<?> constr = interceptorClass.getConstructor(constrArgClass);
            Object[] constrArgValue = new Object[]{plugName};
            interceptor = (ServiceInterceptor)constr.newInstance(constrArgValue);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new CommonConfigException("Cannot initialize " + plugName);
        }
        return interceptor;
    }
}

