/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.axis2;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.AdminTable;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.axis2.AuthorizationModule;
import org.glite.ce.commonj.configuration.CommonServiceConfig;
import org.glite.security.SecurityContext;
import org.glite.security.util.DN;
import org.glite.voms.FQAN;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizationHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger((String)AuthorizationHandler.class.getName());

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        ServiceAuthorizationInterface authzBox;
        SecurityContext secInfo = this.getSecurityContext(msgContext);
        String dnRFC2253 = secInfo.getClientDN().getRFCDNv2();
        String dnX500 = secInfo.getClientX500Name();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)secInfo.getClientX500Principal());
        subject.getPrincipals().add(new X500Principal(dnRFC2253));
        msgContext.setProperty("user.dn.X500", (Object)dnX500);
        msgContext.setProperty("user.dn.RFC2253", (Object)dnRFC2253);
        msgContext.setProperty("user.certificate", (Object)secInfo.getClientCert());
        X509Certificate[] userCertChain = secInfo.getClientCertChain();
        msgContext.setProperty("user.certificate.chain", (Object)userCertChain);
        subject.getPublicCredentials().add(userCertChain);
        ACValidator acValidator = AuthorizationModule.getACValidator();
        VOMSValidator mainValidator = new VOMSValidator(userCertChain, acValidator);
        mainValidator.validate();
        List vomsList = mainValidator.getVOMSAttributes();
        msgContext.setProperty("user.vomsattrs", (Object)vomsList);
        if (vomsList.size() > 0) {
            VOMSAttribute attr = (VOMSAttribute)vomsList.get(0);
            msgContext.setProperty("user.vo", (Object)attr.getAC().getVO());
        }
        String remoteAddress = secInfo.getRemoteAddr();
        msgContext.setProperty("REMOTE_REQUEST_ADDRESS", (Object)remoteAddress);
        QName operation = this.getOperation(msgContext);
        if (operation == null) {
            throw this.getAuthorizationFault("Cannot recognize operation", msgContext);
        }
        logger.debug((Object)("Checking operation " + operation));
        CommonServiceConfig commonConfig = this.getCommonConfiguration();
        if (commonConfig == null) {
            throw this.getAuthorizationFault("Authorization layer is not configured", msgContext);
        }
        AdminTable table = commonConfig.getAdminTable();
        if (table != null) {
            Boolean isAdmin = new Boolean(table.contains(dnX500));
            logger.debug((Object)("Admin test for " + dnX500 + ": " + isAdmin));
            msgContext.setProperty("IS_ADMIN", (Object)isAdmin);
        }
        if ((authzBox = commonConfig.getAuthorizationConfig()) == null) {
            throw this.getAuthorizationFault("Authorization layer is not configured", msgContext);
        }
        boolean authorized = false;
        try {
            authorized = authzBox.isPermitted(subject, new MessageContextWrapper(msgContext), operation);
            logger.info((Object)this.getLogInfoString(dnRFC2253, vomsList, operation.toString(), remoteAddress, authorized));
        }
        catch (AuthorizationException authEx) {
            logger.error((Object)authEx.getMessage(), (Throwable)authEx);
            throw this.getAuthorizationFault("Authorization failure: " + authEx.getMessage(), msgContext);
        }
        if (!authorized) {
            throw this.getAuthorizationFault(dnRFC2253 + " not authorized for " + operation, msgContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    protected QName getOperation(MessageContext context) {
        OperationContext opCtx = context.getOperationContext();
        AxisOperation operation = opCtx.getAxisOperation();
        return operation.getName();
    }

    protected abstract AxisFault getAuthorizationFault(String var1, MessageContext var2);

    protected abstract CommonServiceConfig getCommonConfiguration();

    private String getLogInfoString(String DN2, List<VOMSAttribute> attrs, String operation, String address, boolean authorized) {
        StringBuffer buffer = new StringBuffer("request for OPERATION=");
        buffer.append(operation).append("; REMOTE_REQUEST_ADDRESS=").append(address);
        buffer.append("; USER_DN=").append(DN2).append("; ");
        if (attrs != null && attrs.size() > 0) {
            buffer.append("USER_FQAN={ ");
            for (VOMSAttribute att : attrs) {
                List list = att.getListOfFQAN();
                if (list == null) continue;
                for (FQAN fqan : list) {
                    buffer.append(fqan).append("; ");
                }
            }
            buffer.append("}; ");
        }
        if (authorized) {
            buffer.append(" AUTHORIZED");
        } else {
            buffer.append(" NOT AUTHORIZED");
        }
        return buffer.toString();
    }

    private SecurityContext getSecurityContext(MessageContext msgContext) throws AxisFault {
        SecurityContext result = new SecurityContext();
        Object requestProperty = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (requestProperty != null && requestProperty instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)requestProperty;
            try {
                X509Certificate[] certChain = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                result.setClientCertChain(certChain);
                result.setRemoteAddr(request.getRemoteAddr());
                request.getAttribute("javax.servlet.request.key_size");
                String sslId = (String)request.getAttribute("javax.servlet.request.ssl_session");
                result.setSessionId(sslId);
            }
            catch (Throwable th) {
                logger.error((Object)th.getMessage(), th);
            }
            DN clientDN = result.getClientDN();
            String dnX500 = result.getClientX500Name();
            if (clientDN == null || dnX500 == null || dnX500.equals("")) {
                throw this.getAuthorizationFault("Cannot retrieve credentials", msgContext);
            }
        } else {
            throw this.getAuthorizationFault("Cannot retrieve credentials", msgContext);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageContextWrapper
    implements ServiceAuthorizationInterface.MessageContext {
        private MessageContext msgCtx;

        MessageContextWrapper(MessageContext ctx) {
            this.msgCtx = ctx;
        }

        @Override
        public boolean containsProperty(String name) {
            return this.msgCtx.getProperty(name) != null;
        }

        @Override
        public Object getProperty(String name) {
            return this.msgCtx.getProperty(name);
        }

        @Override
        public Iterator<String> getPropertyNames() {
            return this.msgCtx.getPropertyNames();
        }

        @Override
        public void removeProperty(String name) {
            this.msgCtx.removeProperty(name);
        }

        @Override
        public void setProperty(String name, Object value) {
            this.msgCtx.setProperty(name, value);
        }
    }
}

