/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.argus;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMWriter;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.client.PEPClient;
import org.glite.authz.pep.client.PEPClientException;
import org.glite.authz.pep.client.config.PEPClientConfiguration;
import org.glite.authz.pep.profile.GridCEAuthorizationProfile;
import org.glite.ce.commonj.authz.AuthorizationException;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.argus.ActionMappingInterface;
import org.glite.ce.commonj.authz.argus.PEPConfigurationItem;
import org.glite.voms.FQAN;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.PKIUtils;
import org.glite.voms.VOMSAttribute;

public class ArgusPEP
extends PEPClient
implements ServiceAuthorizationInterface {
    private static Logger logger = Logger.getLogger((String)ArgusPEP.class.getName());
    public static final String ID_ISSUER_ID = "http://glite.org/xacml/attribute/subject-issuer";
    private static HashMap<String, X509Certificate[]> caChains = new HashMap();
    private ActionMappingInterface actionMap;
    private Resource ceResource;
    private String caDir;

    public ArgusPEP(PEPConfigurationItem item) throws PEPClientException {
        super((PEPClientConfiguration)item);
        try {
            Class<?> mClass = Class.forName(item.getMappingClass());
            this.actionMap = (ActionMappingInterface)mClass.newInstance();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot load mapping class", (Throwable)ex);
            throw new PEPClientException("Cannot load mapping class");
        }
        logger.debug((Object)"Initializing argus pep client");
        this.ceResource = GridCEAuthorizationProfile.getInstance().createResourceId(item.getResourceID());
        this.caDir = item.getCADir();
    }

    public boolean isPermitted(javax.security.auth.Subject peerSubject, ServiceAuthorizationInterface.MessageContext context, QName operation) throws AuthorizationException {
        String tmpDN = (String)context.getProperty("user.dn.RFC2253");
        logger.debug((Object)("Calling argus pep client for " + tmpDN));
        try {
            Boolean tmpBool = (Boolean)context.getProperty("IS_ADMIN");
            boolean isAdmin = tmpBool != null && tmpBool != false;
            GridCEAuthorizationProfile ceProfile = GridCEAuthorizationProfile.getInstance();
            String xAction = this.actionMap.getXACMLAction(operation);
            if (xAction == null) {
                if (isAdmin) {
                    logger.info((Object)("Authorized un-mapped operation " + operation + " for administrator " + tmpDN));
                    return true;
                }
                throw new IllegalArgumentException("Operation " + operation + " not allowed for " + tmpDN);
            }
            Action action = ceProfile.createActionId(xAction);
            Environment env = ceProfile.createEnvironmentProfileId(ceProfile.getProfileId());
            Subject sbj = new Subject();
            Attribute attrSubjectId = new Attribute();
            attrSubjectId.setId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            attrSubjectId.setDataType("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
            attrSubjectId.getValues().add(context.getProperty("user.dn.RFC2253"));
            sbj.getAttributes().add(attrSubjectId);
            X509Certificate[] certs = this.getCompleteCertChain(context);
            Attribute attrIssuerId = new Attribute();
            attrIssuerId.setId(ID_ISSUER_ID);
            attrIssuerId.setDataType("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
            for (X509Certificate certItem : certs) {
                if (certItem.getBasicConstraints() < 0) continue;
                logger.debug((Object)("Insert issuer ID " + certItem.getIssuerDN().getName()));
                attrIssuerId.getValues().add(certItem.getIssuerDN().getName());
            }
            sbj.getAttributes().add(attrSubjectId);
            List vomsList = (List)context.getProperty("user.vomsattrs");
            if (vomsList != null) {
                Attribute attrPrimaryFQAN = new Attribute();
                attrPrimaryFQAN.setId("http://glite.org/xacml/attribute/fqan/primary");
                attrPrimaryFQAN.setDataType("http://glite.org/xacml/datatype/fqan");
                Attribute attrFQAN = new Attribute();
                attrFQAN.setId("http://glite.org/xacml/attribute/fqan");
                attrFQAN.setDataType("http://glite.org/xacml/datatype/fqan");
                Attribute attrVO = new Attribute();
                attrVO.setId("http://glite.org/xacml/attribute/virtual-organization");
                attrVO.setDataType("http://www.w3.org/2001/XMLSchema#string");
                boolean missingFQAN = true;
                for (VOMSAttribute vomsAttr : vomsList) {
                    List fqanList = vomsAttr.getListOfFQAN();
                    if (fqanList != null) {
                        for (FQAN fqan : fqanList) {
                            if (missingFQAN) {
                                attrPrimaryFQAN.getValues().add(fqan.getFQAN());
                                missingFQAN = false;
                            }
                            attrFQAN.getValues().add(fqan.getFQAN());
                        }
                    }
                    attrVO.getValues().add(vomsAttr.getVO());
                }
                if (!attrPrimaryFQAN.getValues().isEmpty()) {
                    sbj.getAttributes().add(attrPrimaryFQAN);
                } else {
                    logger.warn((Object)("found empty attrPrimaryFQAN DN=" + tmpDN + " operation=" + operation));
                }
                if (!attrFQAN.getValues().isEmpty()) {
                    sbj.getAttributes().add(attrFQAN);
                }
                if (!attrVO.getValues().isEmpty()) {
                    sbj.getAttributes().add(attrVO);
                }
            }
            Attribute attrKeyInfo = new Attribute();
            attrKeyInfo.setId("urn:oasis:names:tc:xacml:1.0:subject:key-info");
            attrKeyInfo.setDataType("http://www.w3.org/2001/XMLSchema#string");
            String keyInfo = this.convertCertToPEMString(certs, 1);
            attrKeyInfo.getValues().add(keyInfo);
            sbj.getAttributes().add(attrKeyInfo);
            Request request = new Request();
            request.setAction(action);
            request.setEnvironment(env);
            request.getResources().add(this.ceResource);
            request.getSubjects().add(sbj);
            Response response = super.authorize(request);
            List resList = response.getResults();
            if (resList.size() < 1) {
                throw new IllegalArgumentException("No decision from PEP daemon");
            }
            Result result = (Result)resList.get(0);
            if (result.getDecision() != 1 && !isAdmin) {
                logger.debug((Object)("Argus decision: " + result.getDecision()));
                return false;
            }
            List obList = result.getObligations();
            for (Obligation obItem : obList) {
                String obId = obItem.getId();
                logger.debug((Object)("Found obligation " + obId));
                String propName = this.actionMap.getAttributeMapping(obId, null);
                if (propName != null) {
                    logger.debug((Object)("Registered " + propName + " for " + tmpDN));
                    context.setProperty(propName, "true");
                }
                List attrList = obItem.getAttributeAssignments();
                for (AttributeAssignment attrItem : attrList) {
                    String attrId = attrItem.getAttributeId();
                    propName = this.actionMap.getAttributeMapping(obId, attrId);
                    if (propName == null) continue;
                    String attrValue = attrItem.getValue();
                    logger.debug((Object)("Registered " + propName + " for " + tmpDN + " with " + attrValue));
                    context.setProperty(propName, attrValue);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new AuthorizationException(ex.getMessage(), ex);
        }
        this.actionMap.checkMandatoryProperties(context.getPropertyNames());
        return true;
    }

    private String convertCertToPEMString(X509Certificate[] certs, int mode) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter writer = new PEMWriter((Writer)stringWriter);
        for (int k = 0; k < certs.length; ++k) {
            X509Certificate cert = certs[k];
            if (mode == 1 && k == certs.length - 1 || mode == 2 && cert.getBasicConstraints() >= 0) continue;
            writer.writeObject((Object)cert);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return stringWriter.toString();
    }

    private X509Certificate[] getCompleteCertChain(ServiceAuthorizationInterface.MessageContext context) {
        int k;
        int caIdx;
        X509Certificate[] certs = (X509Certificate[])context.getProperty("user.certificate.chain");
        for (caIdx = 0; caIdx < certs.length && certs[caIdx].getBasicConstraints() < 0; ++caIdx) {
        }
        X509Certificate[] tail = this.getChainForCA(certs[caIdx - 1].getIssuerX500Principal());
        X509Certificate[] result = new X509Certificate[caIdx + tail.length];
        for (k = 0; k < caIdx; ++k) {
            result[k] = certs[k];
        }
        for (k = 0; k < tail.length; ++k) {
            result[caIdx + k] = tail[k];
        }
        return result;
    }

    private synchronized X509Certificate[] getChainForCA(X500Principal caPrincipal) {
        long ts = System.currentTimeMillis();
        String caDN = caPrincipal.getName();
        X509Certificate[] result = caChains.get(caDN);
        if (result != null && result.length > 0 && result[0].getNotAfter().getTime() > ts) {
            return result;
        }
        try {
            logger.debug((Object)("Caching chain for " + caDN));
            ArrayList<X509Certificate> tmpList = new ArrayList<X509Certificate>(5);
            PKIStore localStore = PKIStoreFactory.getStore((String)this.caDir, (int)2);
            Hashtable caTable = localStore.getCAs();
            X509Certificate currCert = null;
            X500Principal tmpName = caPrincipal;
            do {
                currCert = (X509Certificate)((Vector)caTable.get(PKIUtils.getHash((X500Principal)tmpName))).get(0);
                tmpList.add(currCert);
                logger.debug((Object)("Cached " + tmpName.getName()));
                tmpName = currCert.getIssuerX500Principal();
            } while (!((Object)currCert.getIssuerDN()).equals(currCert.getSubjectDN()));
            result = new X509Certificate[tmpList.size()];
            tmpList.toArray(result);
            caChains.put(caDN, result);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            caChains.remove(caDN);
            throw new RuntimeException(ex);
        }
        return result;
    }
}

