/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz.argus;

import java.io.File;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.authz.ServiceAuthorizationInterface;
import org.glite.ce.commonj.authz.argus.ArgusPEP;
import org.glite.ce.commonj.authz.argus.PEPConfigurationItem;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgusConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)ArgusConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/argus-pep";
    private static String PAP_ENDPOINT_TAG = "endpoint";
    private static final String PAP_URL_ATTR = "url";
    private static final String CERT_FILE_ATTR = "cert";
    private static final String KEY_FILE_ATTR = "key";
    private static final String PWD_ATTR = "passwd";
    private static final String TIMEOUT_ATTR = "timeout";
    private static final String CONN_HOST_ATTR = "connection_per_host";
    private static final String MAX_CONN_ATTR = "max_connection";
    private static final String CA_DIR_ATTR = "ca_dir";
    private static final String RES_ID_ATTR = "resource_id";
    private static final String MAPPING_ATTR = "mapping_class";
    private XPathExpression expr;
    private ArgusPEP argus;
    private PEPConfigurationItem currConfig;
    private PEPConfigurationItem tmpConfig;

    public ArgusConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.argus = null;
        this.currConfig = null;
        this.tmpConfig = null;
    }

    @Override
    public XPathExpression getXPath() {
        return this.expr;
    }

    @Override
    public Class<?> getCategory() {
        return ServiceAuthorizationInterface.class;
    }

    @Override
    public Object[] getConfigurationElement() {
        if (this.argus != null) {
            Object[] result = new Object[]{this.argus};
            return result;
        }
        return null;
    }

    @Override
    public boolean process(NodeList parsedElements) throws CommonConfigException {
        Element argusElem = (Element)parsedElements.item(0);
        if (argusElem == null) {
            throw new CommonConfigException("Missing argus-pep element");
        }
        this.tmpConfig = new PEPConfigurationItem();
        String tmps = argusElem.getAttribute(RES_ID_ATTR);
        if (tmps == "") {
            throw new CommonConfigException("Missing mandatory attribute: resource_id");
        }
        this.tmpConfig.setResourceID(tmps);
        tmps = argusElem.getAttribute(MAPPING_ATTR);
        if (tmps == "") {
            throw new CommonConfigException("Missing mandatory attribute: mapping_class");
        }
        this.tmpConfig.setMappingClass(tmps);
        String timeoutStr = argusElem.getAttribute(TIMEOUT_ATTR);
        try {
            this.tmpConfig.setConnectionTimeout(Integer.parseInt(timeoutStr));
        }
        catch (Exception ex) {
            logger.debug((Object)"Missing or wrong argument timeout; default value used");
        }
        String connHostStr = argusElem.getAttribute(CONN_HOST_ATTR);
        try {
            this.tmpConfig.setMaxConnectionsPerHost(Integer.parseInt(connHostStr));
        }
        catch (Exception ex) {
            logger.debug((Object)"Missing or wrong argument connection_per_host; default value used");
        }
        String maxConnStr = argusElem.getAttribute(MAX_CONN_ATTR);
        try {
            this.tmpConfig.setMaxTotalConnections(Integer.parseInt(maxConnStr));
        }
        catch (Exception ex) {
            logger.debug((Object)"Missing or wrong argument max_connection; default value used");
        }
        try {
            this.tmpConfig.setKeyMaterial(argusElem.getAttribute(CERT_FILE_ATTR), argusElem.getAttribute(KEY_FILE_ATTR), argusElem.getAttribute(PWD_ATTR));
            String caDir = argusElem.getAttribute(CA_DIR_ATTR);
            if (caDir == "") {
                caDir = "/etc/grid-security/certificates";
            }
            if (!new File(caDir).isDirectory()) {
                throw new Exception("Missing or wrong CA directory");
            }
            this.tmpConfig.setTrustMaterial(caDir);
        }
        catch (Exception ex) {
            throw new CommonConfigException(ex.getMessage(), ex);
        }
        NodeList papElemList = argusElem.getElementsByTagName(PAP_ENDPOINT_TAG);
        for (int k = 0; k < papElemList.getLength(); ++k) {
            Element papElement = (Element)papElemList.item(k);
            String papEP = papElement.getAttribute(PAP_URL_ATTR);
            if (papEP == "") continue;
            this.tmpConfig.addPEPDaemonEndpoint(papEP);
        }
        boolean result = !this.tmpConfig.equals(this.currConfig);
        logger.debug((Object)("Argus configuration changed: " + result));
        return result;
    }

    @Override
    public boolean processTriggers() {
        return false;
    }

    @Override
    public void commit() {
        if (!this.tmpConfig.equals(this.currConfig)) {
            this.currConfig = this.tmpConfig;
            this.tmpConfig = null;
            try {
                this.argus = new ArgusPEP(this.currConfig);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot create ArgusPEP", (Throwable)ex);
            }
        }
    }

    @Override
    public void rollback() {
        this.tmpConfig = null;
    }

    @Override
    public File[] getTriggers() {
        return null;
    }

    @Override
    public void clean() {
        this.argus = null;
    }
}

