/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.authz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.glite.ce.commonj.authz.AdminTable;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.ConfigurationManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)AdminConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/adminlist";
    private static String FILENAME_ATTR = "filename";
    private XPathExpression expr;
    private AdminTable currentTable;
    private AdminTable tmpTable;
    private String currFilename;
    private String tmpFilename;

    public AdminConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
    }

    @Override
    public XPathExpression getXPath() {
        return this.expr;
    }

    @Override
    public Class<?> getCategory() {
        return AdminTable.class;
    }

    @Override
    public Object[] getConfigurationElement() {
        if (this.currentTable != null) {
            Object[] result = new Object[]{this.currentTable};
            return result;
        }
        return null;
    }

    @Override
    public boolean process(NodeList parsedElements) throws CommonConfigException {
        Element adminElem = (Element)parsedElements.item(0);
        if (adminElem == null) {
            throw new CommonConfigException("Missing adminlist element");
        }
        this.tmpFilename = adminElem.getAttribute(FILENAME_ATTR);
        this.tmpTable = this.readAdminTable(this.tmpFilename);
        return !this.tmpTable.equals(this.currentTable);
    }

    @Override
    public boolean processTriggers() throws CommonConfigException {
        this.tmpTable = this.readAdminTable(this.currFilename);
        return !this.tmpTable.equals(this.currentTable);
    }

    @Override
    public void commit() {
        this.currentTable = this.tmpTable;
        this.currFilename = this.tmpFilename;
        this.tmpTable = null;
    }

    @Override
    public void rollback() {
        this.tmpTable = null;
    }

    @Override
    public File[] getTriggers() {
        if (this.currFilename != null) {
            File[] result = new File[]{new File(this.currFilename)};
            return result;
        }
        return null;
    }

    @Override
    public void clean() {
    }

    private AdminTable readAdminTable(String filename) throws CommonConfigException {
        AdminTable result = new AdminTable();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (line.startsWith("\"") && line.endsWith("\"")) {
                        line = line.substring(1, line.length() - 1);
                    }
                    result.add(line);
                    logger.debug((Object)("Registered DN: " + line));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioEx) {
            throw new CommonConfigException(ioEx.getMessage(), ioEx);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
        return result;
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"/tmp/log4j.properties");
        try {
            ConfigurationManager cMan = new ConfigurationManager(args[0]);
            Object[] tmpo = cMan.getConfigurationElements(AdminTable.class);
            if (tmpo.length > 0) {
                AdminTable table = (AdminTable)tmpo[0];
                for (String key : table) {
                    logger.info((Object)("Found " + key));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

