/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.glite.security.util.IPAddressComparator;
import org.glite.security.util.proxy.ProxyCertificateInfo;
import org.glite.security.util.proxy.ProxyRestrictionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyChainInfo {
    private ProxyCertificateInfo[] m_certInfos;
    private int m_proxyType = -1;

    public ProxyChainInfo(X509Certificate[] chain) {
        this.m_certInfos = new ProxyCertificateInfo[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            this.m_certInfos[i] = new ProxyCertificateInfo(chain[i]);
        }
    }

    public int getProxyType() throws CertificateException {
        if (this.m_proxyType != -1) {
            return this.m_proxyType;
        }
        int type = -1;
        for (int i = this.m_certInfos.length - 1; i >= 0; --i) {
            ProxyCertificateInfo certInfo = this.m_certInfos[i];
            if (type == -1) {
                type = certInfo.getProxyType();
                continue;
            }
            if (type != 99 && type != certInfo.getProxyType()) {
                throw new CertificateException("Proxy type mismatch, proxies in a chain should be of one type, several were present.");
            }
            type = certInfo.getProxyType();
        }
        this.m_proxyType = type;
        return this.m_proxyType;
    }

    public boolean isLimited() throws CertificateException, IOException {
        for (int i = this.m_certInfos.length - 1; i >= 0; --i) {
            if (this.m_certInfos[i].getProxyType() == 99 || !this.m_certInfos[i].isLimited()) continue;
            return true;
        }
        return false;
    }

    public String[] getProxyTracingIssuers() throws IOException {
        int len = this.m_certInfos.length;
        String[] issuers = new String[len];
        for (int i = len - 1; i >= 0; --i) {
            issuers[len - i - 1] = this.m_certInfos[i].getProxyTracingIssuer();
        }
        return issuers;
    }

    public String[] getProxyTracingSubjects() throws IOException {
        int len = this.m_certInfos.length;
        String[] subjects = new String[len];
        for (int i = len - 1; i >= 0; --i) {
            subjects[len - i - 1] = this.m_certInfos[i].getProxyTracingSubject();
        }
        return subjects;
    }

    public String[] getSAMLExtensions() throws IOException {
        int len = this.m_certInfos.length;
        String[] samls = new String[len];
        for (int i = len - 1; i >= 0; --i) {
            samls[len - i - 1] = this.m_certInfos[i].getSAMLExtension();
        }
        return samls;
    }

    public int getProxyPathLimit() throws CertificateException, IOException {
        int limit = Integer.MAX_VALUE;
        for (int i = this.m_certInfos.length - 1; i >= 0; --i) {
            if (this.m_certInfos[i].getProxyType() == 99) continue;
            if (limit != Integer.MAX_VALUE) {
                --limit;
            }
            if (this.m_certInfos[i].getProxyPathLimit() == Integer.MAX_VALUE || this.m_certInfos[i].getProxyPathLimit() >= limit) continue;
            limit = this.m_certInfos[i].getProxyPathLimit();
        }
        return limit;
    }

    public byte[][][] getProxySourceRestrictions() throws IOException {
        return this.getProxyRestrictions(true);
    }

    public byte[][][] getProxyTargetRestrictions() throws IOException {
        return this.getProxyRestrictions(false);
    }

    private Vector<byte[]>[] union(byte[][] newSpaces, Vector<byte[]> ipV4Spaces, Vector<byte[]> ipV6Spaces) {
        if (newSpaces == null) {
            return new Vector[]{ipV4Spaces, ipV6Spaces};
        }
        Vector newIPv4 = ipV4Spaces == null ? new Vector() : (Vector)ipV4Spaces.clone();
        Vector newIPv6 = ipV6Spaces == null ? new Vector() : (Vector)ipV6Spaces.clone();
        for (int i = 0; i < newSpaces.length; ++i) {
            if (newSpaces[i].length == 8) {
                newIPv4.add(newSpaces[i]);
                continue;
            }
            if (newSpaces[i].length == 32) {
                newIPv6.add(newSpaces[i]);
                continue;
            }
            throw new IllegalArgumentException("IP space definition has to be either 8 bytes or 32 bytes, length was: " + newSpaces.length);
        }
        return new Vector[]{newIPv4, newIPv6};
    }

    private Vector<byte[]>[] intersect(byte[][] newSpaces, Vector<byte[]> ipV4Spaces, Vector<byte[]> ipV6Spaces) {
        if (newSpaces == null) {
            return new Vector[]{ipV4Spaces, ipV6Spaces};
        }
        Vector<byte[]> newIPv4 = new Vector<byte[]>();
        Vector newIPv6 = new Vector();
        for (int i = 0; i < newSpaces.length; ++i) {
            int len;
            Vector<byte[]> newIPs;
            if (newSpaces[i].length == 8) {
                newIPs = newIPv4;
                len = 8;
            } else if (newSpaces[i].length == 32) {
                newIPs = newIPv6;
                len = 32;
            } else {
                throw new IllegalArgumentException("Invalid namespace definition, length should be 8 or 32 bytes. It was: " + newSpaces[i].length + " bytes.");
            }
            if (ipV4Spaces != null && ipV6Spaces != null) {
                byte[] ip = IPAddressComparator.copyBytes(newSpaces[i], 0, len / 2);
                for (byte[] oldSpace : newIPs) {
                    if (!IPAddressComparator.isWithinAddressSpace(ip, oldSpace)) continue;
                    boolean newTighter = true;
                    for (int n = 0; n < len / 2; ++n) {
                        if ((oldSpace[n + len / 2] & 0xFF) >= (newSpaces[i][n + len / 2] & 0xFF)) continue;
                        newTighter = false;
                        break;
                    }
                    if (newTighter) {
                        newIPs.add(newSpaces[i]);
                        continue;
                    }
                    newIPs.add(oldSpace);
                }
                continue;
            }
            newIPs.add(newSpaces[i]);
        }
        return new Vector[]{newIPv4, newIPv6};
    }

    private byte[][][] getProxyRestrictions(boolean source) throws IOException {
        Vector<byte[]> allowedIPv4Spaces = null;
        Vector<byte[]> allowedIPv6Spaces = null;
        Vector<byte[]> excludedIPv4Spaces = null;
        Vector<byte[]> excludedIPv6Spaces = null;
        for (int i = this.m_certInfos.length - 1; i >= 0; --i) {
            ProxyRestrictionData restrictions = source ? this.m_certInfos[i].getProxySourceRestrictions() : this.m_certInfos[i].getProxyTargetRestrictions();
            if (restrictions == null) continue;
            byte[][][] spaces = restrictions.getIPSpaces();
            Vector<byte[]>[] newSpaces = this.intersect(spaces[0], allowedIPv4Spaces, allowedIPv6Spaces);
            allowedIPv4Spaces = newSpaces[0];
            allowedIPv6Spaces = newSpaces[1];
            newSpaces = this.union(spaces[1], excludedIPv4Spaces, excludedIPv6Spaces);
            excludedIPv4Spaces = newSpaces[0];
            excludedIPv6Spaces = newSpaces[1];
        }
        if (allowedIPv4Spaces == null && allowedIPv6Spaces == null && excludedIPv4Spaces == null && excludedIPv6Spaces == null) {
            return null;
        }
        byte[][][] newSpaces = new byte[2][][];
        if (allowedIPv4Spaces != null && allowedIPv6Spaces != null) {
            newSpaces[0] = IPAddressComparator.concatArrayArrays((byte[][])allowedIPv4Spaces.toArray((T[])new byte[0][0]), (byte[][])allowedIPv6Spaces.toArray((T[])new byte[0][0]));
        }
        if (excludedIPv4Spaces != null && excludedIPv6Spaces != null) {
            newSpaces[1] = IPAddressComparator.concatArrayArrays((byte[][])excludedIPv4Spaces.toArray((T[])new byte[0][0]), (byte[][])excludedIPv6Spaces.toArray((T[])new byte[0][0]));
        }
        return newSpaces;
    }
}

