/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model.util;

import java.util.List;
import java.util.StringTokenizer;
import org.glite.authz.common.model.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strings {
    private Strings() {
    }

    public static boolean isEmpty(String s) {
        String sTrimmed;
        return s == null || (sTrimmed = s.trim()).length() <= 0;
    }

    public static <T> boolean safeEquals(T s1, T s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public static String safeTrim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static String safeTrimOrNullString(String s) {
        String sTrimmed;
        if (s != null && (sTrimmed = s.trim()).length() > 0) {
            return sTrimmed;
        }
        return null;
    }

    public static List<String> toList(String valuesStr, String delimiter) {
        String trimmedValueStr = Strings.safeTrimOrNullString(valuesStr);
        if (trimmedValueStr == null) {
            return null;
        }
        StringTokenizer valueTokens = new StringTokenizer(trimmedValueStr, delimiter);
        LazyList<String> values = new LazyList<String>();
        while (valueTokens.hasMoreTokens()) {
            String value = Strings.safeTrimOrNullString(valueTokens.nextToken());
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }
}

