/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.glite.authz.common.model.util.LazySet;
import org.glite.authz.common.model.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Attribute
implements Serializable {
    public static final String DT_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String DT_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    public static final String DT_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    public static final String DT_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    public static final String DT_TIME = "http://www.w3.org/2001/XMLSchema#time";
    public static final String DT_DATE = "http://www.w3.org/2001/XMLSchema#date";
    public static final String DT_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    public static final String DT_DAY_TIME = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration";
    public static final String DT_YEAR_MONTH = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration";
    public static final String DT_ANY_URI = "http://www.w3.org/2001/XMLSchema#anyURI";
    public static final String DT_HEX_BINARY = "http://www.w3.org/2001/XMLSchema#hexBinary";
    public static final String DT_BASE64_BINARY = "http://www.w3.org/2001/XMLSchema#base64Binary";
    public static final String DT_RFC822_NAME = "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name";
    public static final String DT_X500_NAME = "urn:oasis:names:tc:xacml:1.0:data-type:x500Name";
    public static final String ID_ACT_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    public static final String ID_ACT_IMPLIED_ACTION = "urn:oasis:names:tc:xacml:1.0:action:implied-action";
    public static final String ID_ENV_CURRENT_TIME = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    public static final String ID_ENV_CURRENT_DATE = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    public static final String ID_ENV_CURRENT_DATE_TIME = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";
    public static final String ID_RES_LOCATION = "urn:oasis:names:tc:xacml:1.0:resource:resource-location";
    public static final String ID_RES_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    public static final String ID_RES_SIMPLE_FILE_NAME = "urn:oasis:names:tc:xacml:1.0:resource:simple-file-name";
    public static final String ID_SUB_AUTHN_DNS_NAME = "urn:oasis:names:tc:xacml:1.0:subject:authn-locality:dns-name";
    public static final String ID_SUB_AUTHN_IP_ADDRESS = "urn:oasis:names:tc:xacml:1.0:subject:authn-locality:ip-address";
    public static final String ID_SUB_AUTHN_METHOD = "urn:oasis:names:tc:xacml:1.0:subject:authentication-method";
    public static final String ID_SUB_AUTHN_TIME = "urn:oasis:names:tc:xacml:1.0:subject:authentication-time";
    public static final String ID_SUB_KEY_INFO = "urn:oasis:names:tc:xacml:1.0:subject:key-info";
    public static final String ID_SUB_REQUEST_TIME = "urn:oasis:names:tc:xacml:1.0:subject:request-time";
    public static final String ID_SUB_SESSION_START_TIME = "urn:oasis:names:tc:xacml:1.0:subject:session-start-time";
    public static final String ID_SUB_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    public static final String ID_SUB_ID_QUALIFIER = "urn:oasis:names:tc:xacml:1.0:subject:subject-id-qualifier";
    public static final String ID_SUB_CAT_ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    public static final String ID_SUB_CAT_CODEBASE = "urn:oasis:names:tc:xacml:1.0:subject-category:codebase";
    public static final String ID_SUB_CAT_INTERMEDIARY_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:intermediary-subject";
    public static final String ID_SUB_CAT_RECIPIENT_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject";
    public static final String ID_SUB_CAT_REQUEST_MACHINE = "urn:oasis:names:tc:xacml:1.0:subject-category:requesting-machine";
    private static final long serialVersionUID = -998357326993743203L;
    private String id;
    private String dataType = "http://www.w3.org/2001/XMLSchema#string";
    private String issuer;
    private Set<Object> values = new LazySet<Object>();

    public Attribute() {
    }

    public Attribute(String id, String dataType, String issuer) {
        this();
        this.id = Strings.safeTrimOrNullString(id);
        this.dataType = Strings.safeTrimOrNullString(dataType);
        this.issuer = Strings.safeTrimOrNullString(issuer);
    }

    public Attribute(String id, String dataType) {
        this(id, dataType, null);
    }

    public Attribute(String id) {
        this(id, DT_STRING);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = Strings.safeTrimOrNullString(newId);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String type) {
        this.dataType = Strings.safeTrimOrNullString(type);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String newIssuer) {
        this.issuer = Strings.safeTrimOrNullString(newIssuer);
    }

    public Set<Object> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attribute{ ");
        stringBuilder.append("id: ").append(this.id).append(", ");
        stringBuilder.append("dataType: ").append(this.dataType).append(", ");
        stringBuilder.append("issuer: ").append(this.issuer).append(", ");
        stringBuilder.append("values:[");
        Iterator<Object> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            stringBuilder.append(value);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (null == this.id ? 0 : this.id.hashCode());
        hash = 31 * hash + (null == this.dataType ? 0 : this.dataType.hashCode());
        hash = 31 * hash + (null == this.issuer ? 0 : this.issuer.hashCode());
        hash = 31 * hash + ((Object)this.values).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute otherAttribute = (Attribute)obj;
        return Strings.safeEquals(this.id, otherAttribute.getId()) && Strings.safeEquals(this.dataType, otherAttribute.getDataType()) && Strings.safeEquals(this.issuer, otherAttribute.getIssuer()) && ((Object)this.values).equals(otherAttribute.getValues());
    }
}

