/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.axis2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.glite.security.trustmanager.ContextWrapper;

public class AXIS2SocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"org.glite.security.trustmanager.axis2.AXIS2SocketFactory");
    private static ThreadLocal theAXIS2SocketFactoryProperties = new ThreadLocal();

    public static Properties getCurrentProperties() {
        Properties thisProperties = (Properties)theAXIS2SocketFactoryProperties.get();
        if (thisProperties == null) {
            thisProperties = System.getProperties();
        }
        return thisProperties;
    }

    public static void clearCurrentProperties() {
        theAXIS2SocketFactoryProperties.set(null);
    }

    public static void setCurrentProperties(Properties cp) {
        theAXIS2SocketFactoryProperties.set(cp);
    }

    private Socket createSocket() throws IOException {
        SSLSocket socket;
        try {
            ContextWrapper contextWrapper = new ContextWrapper(AXIS2SocketFactory.getCurrentProperties());
            socket = (SSLSocket)contextWrapper.getSocketFactory().createSocket();
            socket.setEnabledProtocols(new String[]{contextWrapper.getContext().getProtocol()});
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("createSocket(): SSL socket creation failed : " + e.getMessage()), (Throwable)e);
            throw new IOException(e.toString());
        }
        return socket;
    }

    private Socket createSocket(Socket s, boolean autoclose) throws IOException {
        LOGGER.fatal((Object)"createSocket(s, ac): function unimplemented");
        throw new IOException("createSocket(s, ac) unimplemented");
    }

    private final Socket connectSocket(Socket socket, SocketAddress remoteaddr, SocketAddress localaddr, int timeout) throws IOException {
        int newTimeout = timeout;
        if (localaddr != null) {
            socket.bind(localaddr);
        }
        if (timeout == 0) {
            String timeoutString = AXIS2SocketFactory.getCurrentProperties().getProperty("sslTimeout", "60000");
            newTimeout = Integer.parseInt(timeoutString);
        }
        socket.setSoTimeout(newTimeout);
        socket.connect(remoteaddr, newTimeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        int timeout = params.getConnectionTimeout();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        this.connectSocket(socket, remoteaddr, localaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        this.connectSocket(socket, remoteaddr, localaddr, 0);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        this.connectSocket(socket, remoteaddr, null, 0);
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket socket = this.createSocket(s, autoClose);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        this.connectSocket(socket, remoteaddr, null, 0);
        return socket;
    }
}

