/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.client;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.util.Base64;
import org.glite.authz.pep.client.PEPClientException;
import org.glite.authz.pep.client.config.PEPClientConfiguration;
import org.glite.authz.pep.client.http.HttpClientBuilder;
import org.glite.authz.pep.client.http.TLSProtocolSocketFactory;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.PolicyInformationPoint;

public class PEPClient {
    private final Log log = LogFactory.getLog(PEPClient.class);
    private List<PolicyInformationPoint> pips_ = null;
    private List<ObligationHandler> obligationHandlers_ = null;
    private List<String> pepdEndpoints_ = null;
    private HttpClient httpClient_ = null;

    public PEPClient(PEPClientConfiguration config) throws PEPClientException {
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.setConnectionTimeout(config.getConnectionTimeout());
        httpClientBuilder.setMaxConnectionsPerHost(config.getMaxConnectionsPerHost());
        httpClientBuilder.setMaxTotalConnections(config.getMaxTotalConnections());
        if (config.getTrustManager() != null) {
            httpClientBuilder.setHttpsProtocolSocketFactory(new TLSProtocolSocketFactory(config.getKeyManager(), config.getTrustManager()));
        }
        this.httpClient_ = httpClientBuilder.buildClient();
        this.pepdEndpoints_ = config.getPEPDaemonEndpoints();
        if (this.pepdEndpoints_.isEmpty()) {
            throw new PEPClientException("Configuration doesn't contain any PEP Server endpoint URL");
        }
        this.pips_ = config.getPolicyInformationPoints();
        this.obligationHandlers_ = config.getObligationHandlers();
    }

    public Response authorize(Request request) throws PEPClientException {
        Response response = null;
        PEPClientException cause = null;
        try {
            this.runPolicyInformationPoints(request);
        }
        catch (PIPProcessingException e) {
            throw new PEPClientException("PIP processing failure", (Exception)((Object)e));
        }
        for (String endpoint : this.pepdEndpoints_) {
            try {
                response = this.performRequest(endpoint, request);
                break;
            }
            catch (PEPClientException e) {
                this.log.error((Object)("request failed for PEP Server " + endpoint), (Throwable)((Object)e));
                cause = e;
            }
        }
        if (response == null) {
            String error = "No PEP Server " + this.pepdEndpoints_ + " was able to process the request";
            this.log.error((Object)error);
            PEPClientException exception = new PEPClientException(error);
            if (cause != null) {
                exception.setStackTrace(((Throwable)((Object)cause)).getStackTrace());
            }
            throw exception;
        }
        try {
            this.runObligationHandlers(request, response);
        }
        catch (ObligationProcessingException e) {
            throw new PEPClientException("ObligationHandler processing failure", (Exception)((Object)e));
        }
        return response;
    }

    protected Response performRequest(String pepUrl, Request authzRequest) throws PEPClientException {
        Response response;
        block12: {
            String b64Message = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                HessianOutput hout = new HessianOutput((OutputStream)out);
                hout.writeObject((Object)authzRequest);
                hout.flush();
                b64Message = Base64.encodeBytes(out.toByteArray());
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to serialize request object", (Throwable)e);
                throw new PEPClientException("Unable to serialize request object", e);
            }
            PostMethod postMethod = new PostMethod(pepUrl);
            try {
                StringRequestEntity requestEntity = new StringRequestEntity(b64Message, "application/octet-stream", "UTF-8");
                postMethod.setRequestEntity((RequestEntity)requestEntity);
            }
            catch (UnsupportedEncodingException e) {
                throw new PEPClientException(e);
            }
            response = null;
            try {
                this.httpClient_.executeMethod((HttpMethod)postMethod);
                if (postMethod.getStatusCode() == 200) {
                    try {
                        Base64.InputStream is = new Base64.InputStream(postMethod.getResponseBodyAsStream());
                        HessianInput hin = new HessianInput((InputStream)is);
                        response = (Response)hin.readObject(Response.class);
                        break block12;
                    }
                    catch (IOException e) {
                        this.log.error((Object)"Unable to deserialize response object", (Throwable)e);
                        throw new PEPClientException("Unable to deserialize response object", e);
                    }
                }
                String error = postMethod.getStatusCode() + " status code response from the PEP Server " + pepUrl;
                this.log.error((Object)error);
                throw new PEPClientException(error);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read response from PEP Server " + pepUrl), (Throwable)e);
                throw new PEPClientException("Unable to read response from PEP Server " + pepUrl, e);
            }
            finally {
                this.log.debug((Object)"release connection");
                postMethod.releaseConnection();
            }
        }
        return response;
    }

    protected void runPolicyInformationPoints(Request request) throws PIPProcessingException {
        for (PolicyInformationPoint pip : this.pips_) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("applying PIP " + pip.getId()));
            }
            boolean pipApplied = pip.populateRequest(request);
            if (!this.log.isErrorEnabled()) continue;
            this.log.debug((Object)("PIP " + pip.getId() + " applied: " + pipApplied));
        }
    }

    protected void runObligationHandlers(Request request, Response response) throws ObligationProcessingException {
        if (response == null) {
            return;
        }
        List results = response.getResults();
        for (Result result : results) {
            for (ObligationHandler oh : this.obligationHandlers_) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("applying OH " + oh.getObligationId()));
                }
                boolean ohApplied = oh.evaluateObligation(request, result);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("OH " + oh.getObligationId() + " applied: " + ohApplied));
            }
        }
    }
}

