/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class PKITrustManager
implements X509TrustManager {
    private X509TrustManager trustManager_ = null;

    public PKITrustManager(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        this.trustManager_ = this.createX509TrustManager(truststore);
    }

    protected X509TrustManager createX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(keystore);
        X509TrustManager trustManager = (X509TrustManager)tmfactory.getTrustManagers()[0];
        return trustManager;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager_.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager_.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager_.getAcceptedIssuers();
    }
}

