/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class PEMFileReader {
    private Log log = LogFactory.getLog(PEMFileReader.class);

    public PrivateKey readPrivateKey(String filename, String password) throws FileNotFoundException, IOException {
        File file = new File(filename);
        return this.readPrivateKey(file, password);
    }

    public PrivateKey readPrivateKey(File file, String password) throws FileNotFoundException, IOException {
        this.log.debug((Object)("file: " + file));
        FileReader fileReader = new FileReader(file);
        PEMReader reader = new PEMReader((Reader)fileReader, (PasswordFinder)new PEMPassword(password));
        Object object = null;
        do {
            if ((object = reader.readObject()) != null) continue;
            this.log.error((Object)("No KeyPair object found in file " + file));
            throw new IOException("No KeyPair object found in file " + file);
        } while (!(object instanceof KeyPair));
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        KeyPair keyPair = (KeyPair)object;
        return keyPair.getPrivate();
    }

    public X509Certificate[] readCertificates(String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        return this.readCertificates(file);
    }

    public X509Certificate[] readCertificates(File file) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(file);
        PEMReader reader = new PEMReader((Reader)fileReader, (PasswordFinder)new PEMPassword());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        Object object = null;
        do {
            try {
                object = reader.readObject();
                if (!(object instanceof X509CertificateObject)) continue;
                X509Certificate cert = (X509Certificate)object;
                certs.add(cert);
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (object != null);
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return certs.toArray(new X509Certificate[0]);
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private class PEMPassword
    implements PasswordFinder {
        private char[] password_ = null;

        public PEMPassword() {
            this.password_ = null;
        }

        public PEMPassword(String password) {
            this.password_ = (char[])(password == null ? null : password.toCharArray());
        }

        public char[] getPassword() {
            return this.password_;
        }
    }
}

