/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.delegation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.glite.security.delegation.GrDPX509Util;

public class GrDProxyDlgorOptions {
    static Logger logger = Logger.getLogger(GrDProxyDlgorOptions.class);
    private String issuerCertFile = null;
    private String issuerKeyFile = null;
    private String issuerPass = null;
    private String issuerProxyFile = null;
    private String delegationStorage = null;

    public GrDProxyDlgorOptions(String filename) throws IOException {
        logger.debug((Object)("Loading client options form: " + filename));
        FileNotFoundException saveException = null;
        InputStream st = null;
        try {
            st = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            saveException = e;
        }
        if (st == null) {
            st = GrDProxyDlgorOptions.class.getClassLoader().getResourceAsStream(filename);
        }
        if (st == null) {
            if (saveException != null && !(saveException instanceof FileNotFoundException)) {
                throw saveException;
            }
            throw new IOException("No file nor resource named '" + filename + "' found.");
        }
        Properties props = new Properties();
        props.load(st);
        this.init(props);
    }

    public GrDProxyDlgorOptions() {
    }

    private void init(Properties props) {
        this.issuerCertFile = props.getProperty("issuerCertFile");
        this.issuerKeyFile = props.getProperty("issuerKeyFile");
        this.issuerPass = props.getProperty("issuerPass");
        this.issuerProxyFile = props.getProperty("issuerProxyFile");
        this.delegationStorage = props.getProperty("delegationStorage");
    }

    public String getDlgorCertFile() {
        if (this.issuerCertFile == null) {
            return GrDPX509Util.getDefaultCertFile();
        }
        return this.issuerCertFile;
    }

    public String getDlgorKeyFile() {
        if (this.issuerKeyFile == null) {
            return GrDPX509Util.getDefaultKeyFile();
        }
        return this.issuerKeyFile;
    }

    public String getDlgorProxyFile() {
        if (this.issuerProxyFile == null) {
            return GrDPX509Util.getDefaultProxyFile();
        }
        return this.issuerProxyFile;
    }

    public String getDlgorPass() {
        return this.issuerPass;
    }

    public String getDlgorStorage() {
        if (this.delegationStorage == null) {
            return "\tmp";
        }
        return this.delegationStorage;
    }

    public void setDlgorCertFile(String cf) {
        this.issuerCertFile = cf;
    }

    public void setDlgorKeyFile(String kf) {
        this.issuerKeyFile = kf;
    }

    public void setDlgorProxyFile(String proxy) {
        this.issuerProxyFile = proxy;
    }

    public void setDlgorPass(String pass) {
        this.issuerPass = pass;
    }

    public void setDlgorStorage(String strg) {
        this.delegationStorage = strg;
    }
}

