/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TrustDirHandler {
    static final Logger LOGGER = Logger.getLogger((String)TrustDirHandler.class.getName());
    protected String m_dir;
    protected File[] fileList;
    public final Pattern caPattern = Pattern.compile(".*\\.[0-9]");

    public TrustDirHandler(String dir) {
        this.m_dir = dir;
    }

    public void init() throws IOException {
        File directory = new File(this.m_dir);
        this.fileList = directory.listFiles();
        if (this.fileList == null) {
            throw new IOException("Error while opening directory \"" + this.m_dir + "\" it doesn't exist or isn't a directory.");
        }
        if (this.fileList.length == 0) {
            throw new IOException("Directory \"" + this.m_dir + "\" is empty.");
        }
    }

    public File[] getCAs() {
        Vector<File> cas = new Vector<File>();
        for (int index = 0; index < this.fileList.length; ++index) {
            Matcher matcher;
            File currentFile = this.fileList[index];
            if (currentFile.isDirectory() || !(matcher = this.caPattern.matcher(currentFile.getName())).matches()) continue;
            cas.add(currentFile);
        }
        return cas.toArray(new File[0]);
    }
}

