/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.util.LazyList;
import org.glite.authz.common.model.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Obligation
implements Serializable {
    private static final long serialVersionUID = -5500418892138258526L;
    private String id;
    private int fulfillOn;
    private List<AttributeAssignment> attributeAssignments = new LazyList<AttributeAssignment>();

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = Strings.safeTrimOrNullString(newId);
    }

    public int getFulfillOn() {
        return this.fulfillOn;
    }

    public void setFulfillOn(int newFulfillOn) {
        if (newFulfillOn != 0 && newFulfillOn != 1) {
            throw new IllegalArgumentException("Invalid FulfillOn value");
        }
        this.fulfillOn = newFulfillOn;
    }

    public List<AttributeAssignment> getAttributeAssignments() {
        return this.attributeAssignments;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Obligation{ ");
        stringBuilder.append("id: ").append(this.id).append(", ");
        stringBuilder.append("fulfillOn(").append(this.fulfillOn).append("): ").append(Result.decisionToString(this.fulfillOn)).append(", ");
        stringBuilder.append("attributeAssingments: [");
        Iterator<AttributeAssignment> iterator = this.attributeAssignments.iterator();
        while (iterator.hasNext()) {
            AttributeAssignment assignment = iterator.next();
            stringBuilder.append(assignment);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + (null == this.id ? 0 : this.id.hashCode());
        hash = 31 * hash + this.fulfillOn;
        hash = 31 * hash + ((Object)this.attributeAssignments).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Obligation otherObligation = (Obligation)obj;
        return Strings.safeEquals(this.id, otherObligation.getId()) && this.fulfillOn == otherObligation.getFulfillOn() && ((Object)this.attributeAssignments).equals(otherObligation.getAttributeAssignments());
    }
}

