/*
 * Decompiled with CFR 0.152.
 */
package org.glite.ce.commonj.configuration.xppm.unittest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.log4j.Logger;
import org.glite.ce.commonj.configuration.CommonConfigException;
import org.glite.ce.commonj.configuration.xppm.ConfigurationHandler;
import org.glite.ce.commonj.configuration.xppm.unittest.TriggerElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerElementConfigHandler
extends ConfigurationHandler {
    private static Logger logger = Logger.getLogger((String)TriggerElementConfigHandler.class.getName());
    private static final String XPATH_STRING = "/service/trigger";
    private XPathExpression expr;
    private TriggerElement[] currElements;
    private TriggerElement[] tmpElements;

    public TriggerElementConfigHandler() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xpath = ConfigurationHandler.getXPathFactory().newXPath();
        this.expr = xpath.compile(XPATH_STRING);
        this.currElements = null;
        this.tmpElements = null;
    }

    public XPathExpression getXPath() {
        return this.expr;
    }

    public Class<?> getCategory() {
        return TriggerElement.class;
    }

    public Object[] getConfigurationElement() {
        return this.currElements;
    }

    public boolean process(NodeList parsedElements) throws CommonConfigException {
        ArrayList<TriggerElement> tmpList = new ArrayList<TriggerElement>();
        for (int k = 0; k < parsedElements.getLength(); ++k) {
            Element tElem = (Element)parsedElements.item(k);
            try {
                TriggerElement item = new TriggerElement(tElem.getAttribute("file"));
                logger.debug((Object)("Found trigger element: " + item.getContent()));
                tmpList.add(item);
                continue;
            }
            catch (IOException ioEx) {
                throw new CommonConfigException(ioEx.getMessage());
            }
        }
        this.tmpElements = new TriggerElement[tmpList.size()];
        tmpList.toArray(this.tmpElements);
        boolean result = this.tmpElements != this.currElements;
        logger.debug((Object)("Commit TriggerElement list: " + result));
        return result;
    }

    public boolean processTriggers() throws CommonConfigException {
        ArrayList<TriggerElement> tmpList = new ArrayList<TriggerElement>();
        for (TriggerElement oldElem : this.currElements) {
            try {
                TriggerElement newElem = new TriggerElement(oldElem.getFilename());
                tmpList.add(newElem);
            }
            catch (IOException ioEx) {
                throw new CommonConfigException(ioEx.getMessage());
            }
        }
        this.tmpElements = new TriggerElement[tmpList.size()];
        tmpList.toArray(this.tmpElements);
        boolean result = this.tmpElements != this.currElements;
        logger.debug((Object)("Commit TriggerElement list: " + result));
        return result;
    }

    public void commit() {
        this.currElements = this.tmpElements;
        this.tmpElements = null;
    }

    public void rollback() {
        this.tmpElements = null;
    }

    public File[] getTriggers() {
        ArrayList<File> triggers = new ArrayList<File>();
        for (TriggerElement item : this.currElements) {
            logger.debug((Object)("Detected trigger: " + item.getFilename()));
            triggers.add(new File(item.getFilename()));
        }
        File[] result = new File[triggers.size()];
        triggers.toArray(result);
        return result;
    }

    public void clean() {
    }
}

